/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.util.UcumServiceUtil;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.QuantityParam;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.fhir.ucum.Pair;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ScaledNumberField;

@Embeddable
@Entity
@Table(name="HFJ_SPIDX_QUANTITY_NRML", indexes={@Index(name="IDX_SP_QNTY_NRML_HASH_V2", columnList="HASH_IDENTITY,SP_VALUE,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_QNTY_NRML_HASH_UN_V2", columnList="HASH_IDENTITY_AND_UNITS,SP_VALUE,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_QNTY_NRML_HASH_SYSUN_V2", columnList="HASH_IDENTITY_SYS_UNITS,SP_VALUE,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_QNTY_NRML_RESID_V2", columnList="RES_ID,HASH_IDENTITY,HASH_IDENTITY_SYS_UNITS,HASH_IDENTITY_AND_UNITS,SP_VALUE,PARTITION_ID")})
public class ResourceIndexedSearchParamQuantityNormalized
extends BaseResourceIndexedSearchParamQuantity {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_SPIDX_QUANTITY_NRML", sequenceName="SEQ_SPIDX_QUANTITY_NRML")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_QUANTITY_NRML")
    @Column(name="SP_ID")
    private Long myId;
    @Column(name="SP_VALUE", nullable=true)
    @ScaledNumberField
    public Double myValue;
    @ManyToOne(optional=false, fetch=FetchType.LAZY, cascade={})
    @JoinColumn(foreignKey=@ForeignKey(name="FK_SP_QUANTITYNM_RES"), name="RES_ID", referencedColumnName="RES_ID", nullable=false)
    private ResourceTable myResource;

    public ResourceIndexedSearchParamQuantityNormalized() {
    }

    public ResourceIndexedSearchParamQuantityNormalized(PartitionSettings thePartitionSettings, String theResourceType, String theParamName, double theValue, String theSystem, String theUnits) {
        this();
        this.setPartitionSettings(thePartitionSettings);
        this.setResourceType(theResourceType);
        this.setParamName(theParamName);
        this.setSystem(theSystem);
        this.setValue(theValue);
        this.setUnits(theUnits);
        this.calculateHashes();
    }

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        super.copyMutableValuesFrom(theSource);
        ResourceIndexedSearchParamQuantityNormalized source = (ResourceIndexedSearchParamQuantityNormalized)theSource;
        this.mySystem = source.mySystem;
        this.myUnits = source.myUnits;
        this.myValue = source.myValue;
        this.setHashIdentity(source.getHashIdentity());
        this.setHashIdentityAndUnits(source.getHashIdentityAndUnits());
        this.setHashIdentitySystemAndUnits(source.getHashIdentitySystemAndUnits());
    }

    public Double getValue() {
        return this.myValue;
    }

    public ResourceIndexedSearchParamQuantityNormalized setValue(Double theValue) {
        this.myValue = theValue;
        return this;
    }

    public ResourceIndexedSearchParamQuantityNormalized setValue(double theValue) {
        this.myValue = theValue;
        return this;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        return new QuantityParam(null, this.getValue().doubleValue(), this.getSystem(), this.getUnits());
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("paramName", (Object)this.getParamName());
        b.append("resourceId", (Object)this.getResourcePid());
        b.append("system", (Object)this.getSystem());
        b.append("units", (Object)this.getUnits());
        b.append("value", (Object)this.getValue());
        b.append("missing", this.isMissing());
        b.append("hashIdentitySystemAndUnits", (Object)this.getHashIdentitySystemAndUnits());
        return b.build();
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamQuantityNormalized)) {
            return false;
        }
        ResourceIndexedSearchParamQuantityNormalized obj = (ResourceIndexedSearchParamQuantityNormalized)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getResourceType(), (Object)obj.getResourceType());
        b.append((Object)this.getParamName(), (Object)obj.getParamName());
        b.append((Object)this.getHashIdentity(), (Object)obj.getHashIdentity());
        b.append((Object)this.getHashIdentityAndUnits(), (Object)obj.getHashIdentityAndUnits());
        b.append((Object)this.getHashIdentitySystemAndUnits(), (Object)obj.getHashIdentitySystemAndUnits());
        b.append(this.isMissing(), obj.isMissing());
        b.append((Object)this.getValue(), (Object)obj.getValue());
        return b.isEquals();
    }

    @Override
    public boolean matches(IQueryParameterType theParam) {
        String quantityUnits;
        Pair canonicalForm;
        if (!(theParam instanceof QuantityParam)) {
            return false;
        }
        QuantityParam quantity = (QuantityParam)theParam;
        boolean retval = false;
        String quantitySystem = quantity.getSystem();
        BigDecimal quantityValue = quantity.getValue();
        Double quantityDoubleValue = null;
        if (quantityValue != null) {
            quantityDoubleValue = quantityValue.doubleValue();
        }
        if ((canonicalForm = UcumServiceUtil.getCanonicalForm(quantitySystem, quantityValue, quantityUnits = StringUtils.defaultString((String)quantity.getUnits()))) != null) {
            quantityDoubleValue = Double.parseDouble(canonicalForm.getValue().asDecimal());
            quantityUnits = canonicalForm.getCode();
        }
        if (quantitySystem == null && StringUtils.isBlank((CharSequence)quantityUnits)) {
            if (Objects.equals(this.getValue(), quantityDoubleValue)) {
                retval = true;
            }
        } else {
            String unitsString = StringUtils.defaultString((String)this.getUnits());
            if (quantitySystem == null) {
                if (unitsString.equalsIgnoreCase(quantityUnits) && Objects.equals(this.getValue(), quantityDoubleValue)) {
                    retval = true;
                }
            } else if (StringUtils.isBlank((CharSequence)quantityUnits)) {
                if (this.getSystem().equalsIgnoreCase(quantitySystem) && Objects.equals(this.getValue(), quantityDoubleValue)) {
                    retval = true;
                }
            } else if (this.getSystem().equalsIgnoreCase(quantitySystem) && unitsString.equalsIgnoreCase(quantityUnits) && Objects.equals(this.getValue(), quantityDoubleValue)) {
                retval = true;
            }
        }
        return retval;
    }

    @Override
    public ResourceTable getResource() {
        return this.myResource;
    }

    @Override
    public BaseResourceIndexedSearchParam setResource(ResourceTable theResource) {
        this.myResource = theResource;
        this.setResourceType(theResource.getResourceType());
        return this;
    }
}

