/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.util.StringUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Embeddable
@Entity
@Table(name="HFJ_SPIDX_STRING", indexes={@Index(name="IDX_SP_STRING_HASH_IDENT_V2", columnList="HASH_IDENTITY,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_STRING_HASH_NRM_V2", columnList="HASH_NORM_PREFIX,SP_VALUE_NORMALIZED,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_STRING_HASH_EXCT_V2", columnList="HASH_EXACT,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_STRING_RESID_V2", columnList="RES_ID,HASH_NORM_PREFIX,PARTITION_ID")})
public class ResourceIndexedSearchParamString
extends BaseResourceIndexedSearchParam {
    public static final int MAX_LENGTH = 200;
    public static final int HASH_PREFIX_LENGTH = 1;
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_SPIDX_STRING", sequenceName="SEQ_SPIDX_STRING")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_STRING")
    @Column(name="SP_ID")
    private Long myId;
    @ManyToOne(optional=false)
    @JoinColumn(name="RES_ID", referencedColumnName="RES_ID", nullable=false, foreignKey=@ForeignKey(name="FK_SPIDXSTR_RESOURCE"))
    private ResourceTable myResource;
    @Column(name="SP_VALUE_EXACT", length=200, nullable=true)
    private String myValueExact;
    @Column(name="SP_VALUE_NORMALIZED", length=200, nullable=true)
    private String myValueNormalized;
    @Column(name="HASH_NORM_PREFIX", nullable=true)
    private Long myHashNormalizedPrefix;
    @Column(name="HASH_IDENTITY", nullable=true)
    private Long myHashIdentity;
    @Column(name="HASH_EXACT", nullable=true)
    private Long myHashExact;

    public ResourceIndexedSearchParamString() {
    }

    public ResourceIndexedSearchParamString(PartitionSettings thePartitionSettings, StorageSettings theStorageSettings, String theResourceType, String theParamName, String theValueNormalized, String theValueExact) {
        this.setPartitionSettings(thePartitionSettings);
        this.setStorageSettings(theStorageSettings);
        this.setResourceType(theResourceType);
        this.setParamName(theParamName);
        this.setValueNormalized(theValueNormalized);
        this.setValueExact(theValueExact);
        this.calculateHashes();
    }

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        super.copyMutableValuesFrom(theSource);
        ResourceIndexedSearchParamString source = (ResourceIndexedSearchParamString)theSource;
        this.myValueExact = source.myValueExact;
        this.myValueNormalized = source.myValueNormalized;
        this.myHashExact = source.myHashExact;
        this.myHashIdentity = source.myHashIdentity;
        this.myHashNormalizedPrefix = source.myHashNormalizedPrefix;
    }

    @Override
    public void clearHashes() {
        this.myHashIdentity = null;
        this.myHashNormalizedPrefix = null;
        this.myHashExact = null;
    }

    @Override
    public void calculateHashes() {
        if (this.myHashIdentity != null || this.myHashExact != null || this.myHashNormalizedPrefix != null) {
            return;
        }
        String resourceType = this.getResourceType();
        String paramName = this.getParamName();
        String valueNormalized = this.getValueNormalized();
        String valueExact = this.getValueExact();
        this.setHashNormalizedPrefix(ResourceIndexedSearchParamString.calculateHashNormalized(this.getPartitionSettings(), this.getPartitionId(), this.getStorageSettings(), resourceType, paramName, valueNormalized));
        this.setHashExact(ResourceIndexedSearchParamString.calculateHashExact(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName, valueExact));
        this.setHashIdentity(ResourceIndexedSearchParamString.calculateHashIdentity(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName));
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamString)) {
            return false;
        }
        ResourceIndexedSearchParamString obj = (ResourceIndexedSearchParamString)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getResourceType(), (Object)obj.getResourceType());
        b.append((Object)this.getParamName(), (Object)obj.getParamName());
        b.append((Object)this.getValueExact(), (Object)obj.getValueExact());
        b.append((Object)this.getHashIdentity(), (Object)obj.getHashIdentity());
        b.append((Object)this.getHashExact(), (Object)obj.getHashExact());
        b.append((Object)this.getHashNormalizedPrefix(), (Object)obj.getHashNormalizedPrefix());
        b.append((Object)this.getValueNormalized(), (Object)obj.getValueNormalized());
        return b.isEquals();
    }

    private Long getHashIdentity() {
        return this.myHashIdentity;
    }

    public void setHashIdentity(Long theHashIdentity) {
        this.myHashIdentity = theHashIdentity;
    }

    public Long getHashExact() {
        return this.myHashExact;
    }

    public void setHashExact(Long theHashExact) {
        this.myHashExact = theHashExact;
    }

    public Long getHashNormalizedPrefix() {
        return this.myHashNormalizedPrefix;
    }

    public void setHashNormalizedPrefix(Long theHashNormalizedPrefix) {
        this.myHashNormalizedPrefix = theHashNormalizedPrefix;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    public String getValueExact() {
        return this.myValueExact;
    }

    public ResourceIndexedSearchParamString setValueExact(String theValueExact) {
        if (StringUtils.defaultString((String)theValueExact).length() > 200) {
            throw new IllegalArgumentException(Msg.code((int)1529) + "Value is too long: " + theValueExact.length());
        }
        this.myValueExact = theValueExact;
        return this;
    }

    public String getValueNormalized() {
        return this.myValueNormalized;
    }

    public ResourceIndexedSearchParamString setValueNormalized(String theValueNormalized) {
        if (StringUtils.defaultString((String)theValueNormalized).length() > 200) {
            throw new IllegalArgumentException(Msg.code((int)1530) + "Value is too long: " + theValueNormalized.length());
        }
        this.myValueNormalized = theValueNormalized;
        return this;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getResourceType());
        b.append((Object)this.getParamName());
        b.append((Object)this.getValueExact());
        b.append((Object)this.getHashIdentity());
        b.append((Object)this.getHashExact());
        b.append((Object)this.getHashNormalizedPrefix());
        b.append((Object)this.getValueNormalized());
        return b.toHashCode();
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        return new StringParam(this.getValueExact());
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("resourceType", (Object)this.getResourceType());
        b.append("paramName", (Object)this.getParamName());
        b.append("resourceId", (Object)this.getResourcePid());
        b.append("hashIdentity", (Object)this.getHashIdentity());
        b.append("hashNormalizedPrefix", (Object)this.getHashNormalizedPrefix());
        b.append("valueNormalized", (Object)this.getValueNormalized());
        b.append("partitionId", (Object)this.getPartitionId());
        return b.build();
    }

    @Override
    public boolean matches(IQueryParameterType theParam) {
        if (!(theParam instanceof StringParam)) {
            return false;
        }
        StringParam string = (StringParam)theParam;
        String normalizedString = StringUtil.normalizeStringForSearchIndexing((String)StringUtils.defaultString((String)string.getValue()));
        return StringUtils.defaultString((String)this.getValueNormalized()).startsWith(normalizedString);
    }

    public static long calculateHashExact(PartitionSettings thePartitionSettings, PartitionablePartitionId theRequestPartitionId, String theResourceType, String theParamName, String theValueExact) {
        RequestPartitionId requestPartitionId = PartitionablePartitionId.toRequestPartitionId(theRequestPartitionId);
        return ResourceIndexedSearchParamString.calculateHashExact(thePartitionSettings, requestPartitionId, theResourceType, theParamName, theValueExact);
    }

    public static long calculateHashExact(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName, String theValueExact) {
        return ResourceIndexedSearchParamString.hash(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName, theValueExact);
    }

    public static long calculateHashNormalized(PartitionSettings thePartitionSettings, PartitionablePartitionId theRequestPartitionId, StorageSettings theStorageSettings, String theResourceType, String theParamName, String theValueNormalized) {
        RequestPartitionId requestPartitionId = PartitionablePartitionId.toRequestPartitionId(theRequestPartitionId);
        return ResourceIndexedSearchParamString.calculateHashNormalized(thePartitionSettings, requestPartitionId, theStorageSettings, theResourceType, theParamName, theValueNormalized);
    }

    public static long calculateHashNormalized(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, StorageSettings theStorageSettings, String theResourceType, String theParamName, String theValueNormalized) {
        int hashPrefixLength = 1;
        if (theStorageSettings.isAllowContainsSearches()) {
            hashPrefixLength = 0;
        }
        String value = StringUtil.left((String)theValueNormalized, (int)hashPrefixLength);
        return ResourceIndexedSearchParamString.hash(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName, value);
    }

    @Override
    public ResourceTable getResource() {
        return this.myResource;
    }

    @Override
    public BaseResourceIndexedSearchParam setResource(ResourceTable theResource) {
        this.myResource = theResource;
        this.setResourceType(theResource.getResourceType());
        return this;
    }
}

