/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.UriParam;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;

@Embeddable
@Entity
@Table(name="HFJ_SPIDX_URI", indexes={@Index(name="IDX_SP_URI_HASH_URI_V2", columnList="HASH_URI,RES_ID,PARTITION_ID", unique=true), @Index(name="IDX_SP_URI_HASH_IDENTITY_V2", columnList="HASH_IDENTITY,SP_URI,RES_ID,PARTITION_ID", unique=true), @Index(name="IDX_SP_URI_COORDS", columnList="RES_ID")})
public class ResourceIndexedSearchParamUri
extends BaseResourceIndexedSearchParam {
    public static final int MAX_LENGTH = 500;
    private static final long serialVersionUID = 1L;
    @Column(name="SP_URI", nullable=true, length=500)
    @FullTextField
    public String myUri;
    @Id
    @SequenceGenerator(name="SEQ_SPIDX_URI", sequenceName="SEQ_SPIDX_URI")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_URI")
    @Column(name="SP_ID")
    private Long myId;
    @Column(name="HASH_URI", nullable=true)
    private Long myHashUri;
    @Column(name="HASH_IDENTITY", nullable=true)
    private Long myHashIdentity;
    @ManyToOne(optional=false, fetch=FetchType.LAZY, cascade={})
    @JoinColumn(foreignKey=@ForeignKey(name="FKGXSREUTYMMFJUWDSWV3Y887DO"), name="RES_ID", referencedColumnName="RES_ID", nullable=false)
    private ResourceTable myResource;

    public ResourceIndexedSearchParamUri() {
    }

    public ResourceIndexedSearchParamUri(PartitionSettings thePartitionSettings, String theResourceType, String theParamName, String theUri) {
        this.setPartitionSettings(thePartitionSettings);
        this.setResourceType(theResourceType);
        this.setParamName(theParamName);
        this.setUri(theUri);
        this.calculateHashes();
    }

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        super.copyMutableValuesFrom(theSource);
        ResourceIndexedSearchParamUri source = (ResourceIndexedSearchParamUri)theSource;
        this.myUri = source.myUri;
        this.myHashUri = source.myHashUri;
        this.myHashIdentity = source.myHashIdentity;
    }

    @Override
    public void clearHashes() {
        this.myHashIdentity = null;
        this.myHashUri = null;
    }

    @Override
    public void calculateHashes() {
        if (this.myHashIdentity != null || this.myHashUri != null) {
            return;
        }
        String resourceType = this.getResourceType();
        String paramName = this.getParamName();
        String uri = this.getUri();
        this.setHashIdentity(ResourceIndexedSearchParamUri.calculateHashIdentity(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName));
        this.setHashUri(ResourceIndexedSearchParamUri.calculateHashUri(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName, uri));
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamUri)) {
            return false;
        }
        ResourceIndexedSearchParamUri obj = (ResourceIndexedSearchParamUri)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getResourceType(), (Object)obj.getResourceType());
        b.append((Object)this.getParamName(), (Object)obj.getParamName());
        b.append((Object)this.getUri(), (Object)obj.getUri());
        b.append((Object)this.getHashUri(), (Object)obj.getHashUri());
        b.append((Object)this.getHashIdentity(), (Object)obj.getHashIdentity());
        return b.isEquals();
    }

    private Long getHashIdentity() {
        return this.myHashIdentity;
    }

    private void setHashIdentity(long theHashIdentity) {
        this.myHashIdentity = theHashIdentity;
    }

    public Long getHashUri() {
        return this.myHashUri;
    }

    public void setHashUri(Long theHashUri) {
        this.myHashUri = theHashUri;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    public String getUri() {
        return this.myUri;
    }

    public ResourceIndexedSearchParamUri setUri(String theUri) {
        this.myUri = (String)StringUtils.defaultIfBlank((CharSequence)theUri, null);
        return this;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getResourceType());
        b.append((Object)this.getParamName());
        b.append((Object)this.getUri());
        b.append((Object)this.getHashUri());
        b.append((Object)this.getHashIdentity());
        return b.toHashCode();
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        return new UriParam(this.getUri());
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.append("id", (Object)this.getId());
        b.append("resourceId", (Object)this.getResourcePid());
        b.append("paramName", (Object)this.getParamName());
        b.append("uri", (Object)this.myUri);
        b.append("hashUri", (Object)this.myHashUri);
        return b.toString();
    }

    @Override
    public boolean matches(IQueryParameterType theParam) {
        if (!(theParam instanceof UriParam)) {
            return false;
        }
        UriParam uri = (UriParam)theParam;
        return StringUtils.defaultString((String)this.getUri()).equalsIgnoreCase(uri.getValueNotNull());
    }

    public static long calculateHashUri(PartitionSettings thePartitionSettings, PartitionablePartitionId theRequestPartitionId, String theResourceType, String theParamName, String theUri) {
        RequestPartitionId requestPartitionId = PartitionablePartitionId.toRequestPartitionId(theRequestPartitionId);
        return ResourceIndexedSearchParamUri.calculateHashUri(thePartitionSettings, requestPartitionId, theResourceType, theParamName, theUri);
    }

    public static long calculateHashUri(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName, String theUri) {
        return ResourceIndexedSearchParamUri.hash(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName, theUri);
    }

    @Override
    public ResourceTable getResource() {
        return this.myResource;
    }

    @Override
    public BaseResourceIndexedSearchParam setResource(ResourceTable theResource) {
        this.myResource = theResource;
        this.setResourceType(theResource.getResourceType());
        return this;
    }
}

