/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.util.Date;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;
import org.hl7.fhir.instance.model.api.IIdType;

@Entity
@Table(name="HFJ_RES_LINK", indexes={@Index(name="IDX_RL_SRC", columnList="SRC_RESOURCE_ID"), @Index(name="IDX_RL_TGT_v2", columnList="TARGET_RESOURCE_ID, SRC_PATH, SRC_RESOURCE_ID, TARGET_RESOURCE_TYPE,PARTITION_ID")})
public class ResourceLink
extends BaseResourceIndex {
    public static final int SRC_PATH_LENGTH = 500;
    private static final long serialVersionUID = 1L;
    @SequenceGenerator(name="SEQ_RESLINK_ID", sequenceName="SEQ_RESLINK_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESLINK_ID")
    @Id
    @Column(name="PID")
    private Long myId;
    @Column(name="SRC_PATH", length=500, nullable=false)
    private String mySourcePath;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="SRC_RESOURCE_ID", referencedColumnName="RES_ID", nullable=false, foreignKey=@ForeignKey(name="FK_RESLINK_SOURCE"))
    private ResourceTable mySourceResource;
    @Column(name="SRC_RESOURCE_ID", insertable=false, updatable=false, nullable=false)
    private Long mySourceResourcePid;
    @Column(name="SOURCE_RESOURCE_TYPE", updatable=false, nullable=false, length=40)
    @FullTextField
    private String mySourceResourceType;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TARGET_RESOURCE_ID", referencedColumnName="RES_ID", nullable=true, insertable=false, updatable=false, foreignKey=@ForeignKey(name="FK_RESLINK_TARGET"))
    private ResourceTable myTargetResource;
    @Column(name="TARGET_RESOURCE_ID", insertable=true, updatable=true, nullable=true)
    @FullTextField
    private Long myTargetResourcePid;
    @Column(name="TARGET_RESOURCE_TYPE", nullable=false, length=40)
    @FullTextField
    private String myTargetResourceType;
    @Column(name="TARGET_RESOURCE_URL", length=200, nullable=true)
    @FullTextField
    private String myTargetResourceUrl;
    @Column(name="TARGET_RESOURCE_VERSION", nullable=true)
    private Long myTargetResourceVersion;
    @FullTextField
    @Column(name="SP_UPDATED", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myUpdated;
    @Transient
    private transient String myTargetResourceId;

    public Long getTargetResourceVersion() {
        return this.myTargetResourceVersion;
    }

    public void setTargetResourceVersion(Long theTargetResourceVersion) {
        this.myTargetResourceVersion = theTargetResourceVersion;
    }

    public String getTargetResourceId() {
        if (this.myTargetResourceId == null && this.myTargetResource != null) {
            this.myTargetResourceId = this.getTargetResource().getIdDt().getIdPart();
        }
        return this.myTargetResourceId;
    }

    public String getSourceResourceType() {
        return this.mySourceResourceType;
    }

    public String getTargetResourceType() {
        return this.myTargetResourceType;
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceLink)) {
            return false;
        }
        ResourceLink obj = (ResourceLink)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.mySourcePath, (Object)obj.mySourcePath);
        b.append((Object)this.mySourceResource, (Object)obj.mySourceResource);
        b.append((Object)this.myTargetResourceUrl, (Object)obj.myTargetResourceUrl);
        b.append((Object)this.myTargetResourceType, (Object)obj.myTargetResourceType);
        b.append((Object)this.myTargetResourceVersion, (Object)obj.myTargetResourceVersion);
        if (this.getTargetResourcePid() == null) {
            b.append((Object)this.getTargetResourceId(), (Object)obj.getTargetResourceId());
        } else {
            b.append((Object)this.getTargetResourcePid(), (Object)obj.getTargetResourcePid());
        }
        return b.isEquals();
    }

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        ResourceLink source = (ResourceLink)theSource;
        this.mySourcePath = source.getSourcePath();
        this.myTargetResource = source.getTargetResource();
        this.myTargetResourceId = source.getTargetResourceId();
        this.myTargetResourcePid = source.getTargetResourcePid();
        this.myTargetResourceType = source.getTargetResourceType();
        this.myTargetResourceVersion = source.getTargetResourceVersion();
        this.myTargetResourceUrl = source.getTargetResourceUrl();
    }

    public String getSourcePath() {
        return this.mySourcePath;
    }

    public void setSourcePath(String theSourcePath) {
        this.mySourcePath = theSourcePath;
    }

    public Long getSourceResourcePid() {
        return this.mySourceResourcePid;
    }

    public ResourceTable getSourceResource() {
        return this.mySourceResource;
    }

    public void setSourceResource(ResourceTable theSourceResource) {
        this.mySourceResource = theSourceResource;
        this.mySourceResourcePid = theSourceResource.getId();
        this.mySourceResourceType = theSourceResource.getResourceType();
    }

    public void setTargetResource(String theResourceType, Long theResourcePid, String theTargetResourceId) {
        Validate.notBlank((CharSequence)theResourceType);
        this.myTargetResourceType = theResourceType;
        this.myTargetResourcePid = theResourcePid;
        this.myTargetResourceId = theTargetResourceId;
    }

    public String getTargetResourceUrl() {
        return this.myTargetResourceUrl;
    }

    public void setTargetResourceUrl(IIdType theTargetResourceUrl) {
        Validate.isTrue((boolean)theTargetResourceUrl.hasBaseUrl());
        Validate.isTrue((boolean)theTargetResourceUrl.hasResourceType());
        this.myTargetResourceType = theTargetResourceUrl.getResourceType();
        this.myTargetResourceUrl = theTargetResourceUrl.getValue();
    }

    public Long getTargetResourcePid() {
        return this.myTargetResourcePid;
    }

    public void setTargetResourceUrlCanonical(String theTargetResourceUrl) {
        Validate.notBlank((CharSequence)theTargetResourceUrl);
        this.myTargetResourceType = "(unknown)";
        this.myTargetResourceUrl = theTargetResourceUrl;
    }

    public Date getUpdated() {
        return this.myUpdated;
    }

    public void setUpdated(Date theUpdated) {
        this.myUpdated = theUpdated;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    @Override
    public void clearHashes() {
    }

    @Override
    public void calculateHashes() {
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.mySourcePath);
        b.append((Object)this.mySourceResource);
        b.append((Object)this.myTargetResourceUrl);
        b.append((Object)this.myTargetResourceVersion);
        if (this.getTargetResourcePid() == null) {
            b.append((Object)this.getTargetResourceId());
        } else {
            b.append((Object)this.getTargetResourcePid());
        }
        return b.toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResourceLink[");
        b.append("path=").append(this.mySourcePath);
        b.append(", src=").append(this.mySourceResourcePid);
        b.append(", target=").append(this.myTargetResourcePid);
        b.append(", targetType=").append(this.myTargetResourceType);
        b.append(", targetVersion=").append(this.myTargetResourceVersion);
        b.append(", targetUrl=").append(this.myTargetResourceUrl);
        b.append("]");
        return b.toString();
    }

    public ResourceTable getTargetResource() {
        return this.myTargetResource;
    }

    public ResourceLink cloneWithoutTargetPid() {
        ResourceLink retVal = new ResourceLink();
        retVal.mySourceResource = this.mySourceResource;
        retVal.mySourceResourcePid = this.mySourceResource.getId();
        retVal.mySourceResourceType = this.mySourceResource.getResourceType();
        retVal.mySourcePath = this.mySourcePath;
        retVal.myUpdated = this.myUpdated;
        retVal.myTargetResourceType = this.myTargetResourceType;
        if (this.myTargetResourceId != null) {
            retVal.myTargetResourceId = this.myTargetResourceId;
        } else if (this.myTargetResource != null) {
            retVal.myTargetResourceId = this.myTargetResource.getIdDt().getIdPart();
        }
        retVal.myTargetResourceUrl = this.myTargetResourceUrl;
        retVal.myTargetResourceVersion = this.myTargetResourceVersion;
        return retVal;
    }

    public static ResourceLink forAbsoluteReference(String theSourcePath, ResourceTable theSourceResource, IIdType theTargetResourceUrl, Date theUpdated) {
        ResourceLink retVal = new ResourceLink();
        retVal.setSourcePath(theSourcePath);
        retVal.setSourceResource(theSourceResource);
        retVal.setTargetResourceUrl(theTargetResourceUrl);
        retVal.setUpdated(theUpdated);
        return retVal;
    }

    public static ResourceLink forLogicalReference(String theSourcePath, ResourceTable theSourceResource, String theTargetResourceUrl, Date theUpdated) {
        ResourceLink retVal = new ResourceLink();
        retVal.setSourcePath(theSourcePath);
        retVal.setSourceResource(theSourceResource);
        retVal.setTargetResourceUrlCanonical(theTargetResourceUrl);
        retVal.setUpdated(theUpdated);
        return retVal;
    }

    public static ResourceLink forLocalReference(String theSourcePath, ResourceTable theSourceResource, String theTargetResourceType, Long theTargetResourcePid, String theTargetResourceId, Date theUpdated, @Nullable Long theTargetResourceVersion) {
        ResourceLink retVal = new ResourceLink();
        retVal.setSourcePath(theSourcePath);
        retVal.setSourceResource(theSourceResource);
        retVal.setTargetResource(theTargetResourceType, theTargetResourcePid, theTargetResourceId);
        retVal.setTargetResourceVersion(theTargetResourceVersion);
        retVal.setUpdated(theUpdated);
        return retVal;
    }
}

