/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;

@Entity
@Table(name="HFJ_RES_SEARCH_URL", indexes={@Index(name="IDX_RESSEARCHURL_RES", columnList="RES_ID"), @Index(name="IDX_RESSEARCHURL_TIME", columnList="CREATED_TIME")})
public class ResourceSearchUrlEntity {
    public static final String RES_SEARCH_URL_COLUMN_NAME = "RES_SEARCH_URL";
    public static final int RES_SEARCH_URL_LENGTH = 768;
    @Id
    @Column(name="RES_SEARCH_URL", length=768, nullable=false)
    private String mySearchUrl;
    @Column(name="RES_ID", updatable=false, nullable=false)
    private Long myResourcePid;
    @Column(name="CREATED_TIME", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myCreatedTime;

    public static ResourceSearchUrlEntity from(String theUrl, Long theId) {
        return new ResourceSearchUrlEntity().setResourcePid(theId).setSearchUrl(theUrl).setCreatedTime(new Date());
    }

    public Long getResourcePid() {
        return this.myResourcePid;
    }

    public ResourceSearchUrlEntity setResourcePid(Long theResourcePid) {
        this.myResourcePid = theResourcePid;
        return this;
    }

    public Date getCreatedTime() {
        return this.myCreatedTime;
    }

    public ResourceSearchUrlEntity setCreatedTime(Date theCreatedTime) {
        this.myCreatedTime = theCreatedTime;
        return this;
    }

    public String getSearchUrl() {
        return this.mySearchUrl;
    }

    public ResourceSearchUrlEntity setSearchUrl(String theSearchUrl) {
        this.mySearchUrl = theSearchUrl;
        return this;
    }
}

