/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.dialect.HapiSequenceStyleGenerator;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryProvenanceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboStringUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboTokenNonUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamCoords;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamNumber;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantityNormalized;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamUri;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.SearchParamPresentEntity;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.jpa.model.search.ExtendedHSearchIndexData;
import ca.uhn.fhir.jpa.model.search.ResourceTableRoutingBinder;
import ca.uhn.fhir.jpa.model.search.SearchParamTextPropertyBinder;
import ca.uhn.fhir.model.primitive.IdDt;
import com.google.common.annotations.VisibleForTesting;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.Session;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.annotations.GeneratorType;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.PropertyBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.RoutingBinderRef;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.GenericField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.Indexed;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.IndexingDependency;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ObjectPath;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.PropertyBinding;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.PropertyValue;
import org.hibernate.tuple.ValueGenerator;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.InstantType;

@Indexed(routingBinder=@RoutingBinderRef(type=ResourceTableRoutingBinder.class))
@Entity
@Table(name="HFJ_RESOURCE", uniqueConstraints={@UniqueConstraint(name="IDX_RES_TYPE_FHIR_ID", columnNames={"RES_TYPE", "FHIR_ID"})}, indexes={@Index(name="IDX_RES_DATE", columnList="RES_UPDATED"), @Index(name="IDX_RES_FHIR_ID", columnList="FHIR_ID"), @Index(name="IDX_RES_TYPE_DEL_UPDATED", columnList="RES_TYPE,RES_DELETED_AT,RES_UPDATED,PARTITION_ID,RES_ID"), @Index(name="IDX_RES_RESID_UPDATED", columnList="RES_ID, RES_UPDATED, PARTITION_ID")})
@NamedEntityGraph(name="Resource.noJoins")
public class ResourceTable
extends BaseHasResource
implements Serializable,
IBasePersistedResource<JpaPid> {
    public static final int RESTYPE_LEN = 40;
    public static final String HFJ_RESOURCE = "HFJ_RESOURCE";
    public static final String RES_TYPE = "RES_TYPE";
    public static final String FHIR_ID = "FHIR_ID";
    private static final int MAX_LANGUAGE_LENGTH = 20;
    private static final long serialVersionUID = 1L;
    public static final int MAX_FORCED_ID_LENGTH = 100;
    public static final String IDX_RES_TYPE_FHIR_ID = "IDX_RES_TYPE_FHIR_ID";
    @Transient
    @FullTextField.List(value={@FullTextField(name="myContentText", searchable=Searchable.YES, projectable=Projectable.YES, analyzer="standardAnalyzer"), @FullTextField(name="myContentTextEdgeNGram", searchable=Searchable.YES, projectable=Projectable.NO, analyzer="autocompleteEdgeAnalyzer"), @FullTextField(name="myContentTextNGram", searchable=Searchable.YES, projectable=Projectable.NO, analyzer="autocompleteNGramAnalyzer"), @FullTextField(name="myContentTextPhonetic", searchable=Searchable.YES, projectable=Projectable.NO, analyzer="autocompletePhoneticAnalyzer")})
    @OptimisticLock(excluded=true)
    @IndexingDependency(derivedFrom={@ObjectPath(value={@PropertyValue(propertyName="myVersion")})})
    private String myContentText;
    @Column(name="HASH_SHA256", length=64, nullable=true)
    @OptimisticLock(excluded=true)
    private String myHashSha256;
    @Column(name="SP_HAS_LINKS")
    @OptimisticLock(excluded=true)
    private boolean myHasLinks;
    @Id
    @GenericGenerator(name="SEQ_RESOURCE_ID", type=HapiSequenceStyleGenerator.class)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESOURCE_ID")
    @Column(name="RES_ID")
    @GenericField(projectable=Projectable.YES)
    private Long myId;
    @Column(name="SP_INDEX_STATUS", nullable=true)
    @OptimisticLock(excluded=true)
    private Long myIndexStatus;
    @Column(name="RES_LANGUAGE", length=20, nullable=true)
    @OptimisticLock(excluded=true)
    private String myLanguage;
    @Transient
    @FullTextField.List(value={@FullTextField(name="myNarrativeText", searchable=Searchable.YES, projectable=Projectable.YES, analyzer="standardAnalyzer"), @FullTextField(name="myNarrativeTextEdgeNGram", searchable=Searchable.YES, projectable=Projectable.NO, analyzer="autocompleteEdgeAnalyzer"), @FullTextField(name="myNarrativeTextNGram", searchable=Searchable.YES, projectable=Projectable.NO, analyzer="autocompleteNGramAnalyzer"), @FullTextField(name="myNarrativeTextPhonetic", searchable=Searchable.YES, projectable=Projectable.NO, analyzer="autocompletePhoneticAnalyzer")})
    @OptimisticLock(excluded=true)
    @IndexingDependency(derivedFrom={@ObjectPath(value={@PropertyValue(propertyName="myVersion")})})
    private String myNarrativeText;
    @Transient
    @IndexingDependency(derivedFrom={@ObjectPath(value={@PropertyValue(propertyName="myVersion")})})
    @PropertyBinding(binder=@PropertyBinderRef(type=SearchParamTextPropertyBinder.class))
    private ExtendedHSearchIndexData myLuceneIndexData;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamCoords> myParamsCoords;
    @Column(name="SP_COORDS_PRESENT")
    @OptimisticLock(excluded=true)
    private boolean myParamsCoordsPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamDate> myParamsDate;
    @Column(name="SP_DATE_PRESENT")
    @OptimisticLock(excluded=true)
    private boolean myParamsDatePopulated;
    @OptimisticLock(excluded=true)
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    private Collection<ResourceIndexedSearchParamNumber> myParamsNumber;
    @Column(name="SP_NUMBER_PRESENT")
    @OptimisticLock(excluded=true)
    private boolean myParamsNumberPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamQuantity> myParamsQuantity;
    @Column(name="SP_QUANTITY_PRESENT")
    @OptimisticLock(excluded=true)
    private boolean myParamsQuantityPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamQuantityNormalized> myParamsQuantityNormalized;
    @Column(name="SP_QUANTITY_NRML_PRESENT")
    @OptimisticLock(excluded=true)
    private Boolean myParamsQuantityNormalizedPopulated = Boolean.FALSE;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamString> myParamsString;
    @Column(name="SP_STRING_PRESENT")
    @OptimisticLock(excluded=true)
    private boolean myParamsStringPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamToken> myParamsToken;
    @Column(name="SP_TOKEN_PRESENT")
    @OptimisticLock(excluded=true)
    private boolean myParamsTokenPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamUri> myParamsUri;
    @Column(name="SP_URI_PRESENT")
    @OptimisticLock(excluded=true)
    private boolean myParamsUriPopulated;
    @OptimisticLock(excluded=true)
    @Column(name="SP_CMPSTR_UNIQ_PRESENT")
    private Boolean myParamsComboStringUniquePresent = false;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedComboStringUnique> myParamsComboStringUnique;
    @OptimisticLock(excluded=true)
    @Column(name="SP_CMPTOKS_PRESENT")
    private Boolean myParamsComboTokensNonUniquePresent = false;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedComboTokenNonUnique> myParamsComboTokensNonUnique;
    @OneToMany(mappedBy="mySourceResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceLink> myResourceLinks;
    @FullTextField
    @Transient
    @IndexingDependency(derivedFrom={@ObjectPath(value={@PropertyValue(propertyName="myResourceLinks")})})
    private String myResourceLinksField;
    @OneToMany(mappedBy="myTargetResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceLink> myResourceLinksAsTarget;
    @Column(name="RES_TYPE", length=40, nullable=false)
    @FullTextField
    @OptimisticLock(excluded=true)
    private String myResourceType;
    @OneToMany(mappedBy="myResource", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @OptimisticLock(excluded=true)
    private Collection<SearchParamPresentEntity> mySearchParamPresents;
    @OneToMany(mappedBy="myResource", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @OptimisticLock(excluded=true)
    private Set<ResourceTag> myTags;
    @Transient
    private transient boolean myUnchangedInCurrentOperation;
    @Column(name="FHIR_ID", length=64, updatable=false)
    @GeneratorType(when=GenerationTime.INSERT, type=FhirIdGenerator.class)
    @OptimisticLock(excluded=true)
    private String myFhirId;
    @OptimisticLock(excluded=true)
    @Column(name="SEARCH_URL_PRESENT", nullable=true)
    private Boolean mySearchUrlPresent = false;
    @Version
    @Column(name="RES_VER")
    private long myVersion;
    @OneToMany(mappedBy="myResourceTable", fetch=FetchType.LAZY)
    private Collection<ResourceHistoryProvenanceEntity> myProvenance;
    @Transient
    private transient ResourceHistoryTable myCurrentVersionEntity;
    @Transient
    private transient ResourceHistoryTable myNewVersionEntity;
    @Transient
    private transient boolean myVersionUpdatedInCurrentTransaction;
    @Transient
    private volatile String myCreatedByMatchUrl;
    @Transient
    private volatile String myUpdatedByMatchUrl;

    public void markVersionUpdatedInCurrentTransaction() {
        if (!this.myVersionUpdatedInCurrentTransaction) {
            ++this.myVersion;
            this.myVersionUpdatedInCurrentTransaction = true;
        }
    }

    @PostPersist
    public void postPersist() {
        this.myVersionUpdatedInCurrentTransaction = false;
    }

    @Override
    public ResourceTag addTag(TagDefinition theTag) {
        for (ResourceTag next : this.getTags()) {
            if (!next.getTag().equals(theTag)) continue;
            return next;
        }
        ResourceTag tag = new ResourceTag(this, theTag, this.getPartitionId());
        this.getTags().add(tag);
        return tag;
    }

    public String getHashSha256() {
        return this.myHashSha256;
    }

    public void setHashSha256(String theHashSha256) {
        this.myHashSha256 = theHashSha256;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    public void setId(Long theId) {
        this.myId = theId;
    }

    public Long getIndexStatus() {
        return this.myIndexStatus;
    }

    public void setIndexStatus(Long theIndexStatus) {
        this.myIndexStatus = theIndexStatus;
    }

    public Collection<ResourceIndexedComboStringUnique> getParamsComboStringUnique() {
        if (this.myParamsComboStringUnique == null) {
            this.myParamsComboStringUnique = new ArrayList<ResourceIndexedComboStringUnique>();
        }
        return this.myParamsComboStringUnique;
    }

    public Collection<ResourceIndexedComboTokenNonUnique> getmyParamsComboTokensNonUnique() {
        if (this.myParamsComboTokensNonUnique == null) {
            this.myParamsComboTokensNonUnique = new ArrayList<ResourceIndexedComboTokenNonUnique>();
        }
        return this.myParamsComboTokensNonUnique;
    }

    public Collection<ResourceIndexedSearchParamCoords> getParamsCoords() {
        if (this.myParamsCoords == null) {
            this.myParamsCoords = new ArrayList<ResourceIndexedSearchParamCoords>();
        }
        return this.myParamsCoords;
    }

    public void setParamsCoords(Collection<ResourceIndexedSearchParamCoords> theParamsCoords) {
        if (!this.isParamsTokenPopulated() && theParamsCoords.isEmpty()) {
            return;
        }
        this.getParamsCoords().clear();
        this.getParamsCoords().addAll(theParamsCoords);
    }

    public Collection<ResourceIndexedSearchParamDate> getParamsDate() {
        if (this.myParamsDate == null) {
            this.myParamsDate = new ArrayList<ResourceIndexedSearchParamDate>();
        }
        return this.myParamsDate;
    }

    public void setParamsDate(Collection<ResourceIndexedSearchParamDate> theParamsDate) {
        if (!this.isParamsDatePopulated() && theParamsDate.isEmpty()) {
            return;
        }
        this.getParamsDate().clear();
        this.getParamsDate().addAll(theParamsDate);
    }

    public Collection<ResourceIndexedSearchParamNumber> getParamsNumber() {
        if (this.myParamsNumber == null) {
            this.myParamsNumber = new ArrayList<ResourceIndexedSearchParamNumber>();
        }
        return this.myParamsNumber;
    }

    public void setParamsNumber(Collection<ResourceIndexedSearchParamNumber> theNumberParams) {
        if (!this.isParamsNumberPopulated() && theNumberParams.isEmpty()) {
            return;
        }
        this.getParamsNumber().clear();
        this.getParamsNumber().addAll(theNumberParams);
    }

    public Collection<ResourceIndexedSearchParamQuantity> getParamsQuantity() {
        if (this.myParamsQuantity == null) {
            this.myParamsQuantity = new ArrayList<ResourceIndexedSearchParamQuantity>();
        }
        return this.myParamsQuantity;
    }

    public void setParamsQuantity(Collection<ResourceIndexedSearchParamQuantity> theQuantityParams) {
        if (!this.isParamsQuantityPopulated() && theQuantityParams.isEmpty()) {
            return;
        }
        this.getParamsQuantity().clear();
        this.getParamsQuantity().addAll(theQuantityParams);
    }

    public Collection<ResourceIndexedSearchParamQuantityNormalized> getParamsQuantityNormalized() {
        if (this.myParamsQuantityNormalized == null) {
            this.myParamsQuantityNormalized = new ArrayList<ResourceIndexedSearchParamQuantityNormalized>();
        }
        return this.myParamsQuantityNormalized;
    }

    public void setParamsQuantityNormalized(Collection<ResourceIndexedSearchParamQuantityNormalized> theQuantityNormalizedParams) {
        if (!this.isParamsQuantityNormalizedPopulated().booleanValue() && theQuantityNormalizedParams.isEmpty()) {
            return;
        }
        this.getParamsQuantityNormalized().clear();
        this.getParamsQuantityNormalized().addAll(theQuantityNormalizedParams);
    }

    public Collection<ResourceIndexedSearchParamString> getParamsString() {
        if (this.myParamsString == null) {
            this.myParamsString = new ArrayList<ResourceIndexedSearchParamString>();
        }
        return this.myParamsString;
    }

    public void setParamsString(Collection<ResourceIndexedSearchParamString> theParamsString) {
        if (!this.isParamsStringPopulated() && theParamsString.isEmpty()) {
            return;
        }
        this.getParamsString().clear();
        this.getParamsString().addAll(theParamsString);
    }

    public Collection<ResourceIndexedSearchParamToken> getParamsToken() {
        if (this.myParamsToken == null) {
            this.myParamsToken = new ArrayList<ResourceIndexedSearchParamToken>();
        }
        return this.myParamsToken;
    }

    public void setParamsToken(Collection<ResourceIndexedSearchParamToken> theParamsToken) {
        if (!this.isParamsTokenPopulated() && theParamsToken.isEmpty()) {
            return;
        }
        this.getParamsToken().clear();
        this.getParamsToken().addAll(theParamsToken);
    }

    public Collection<ResourceIndexedSearchParamUri> getParamsUri() {
        if (this.myParamsUri == null) {
            this.myParamsUri = new ArrayList<ResourceIndexedSearchParamUri>();
        }
        return this.myParamsUri;
    }

    public void setParamsUri(Collection<ResourceIndexedSearchParamUri> theParamsUri) {
        if (!this.isParamsTokenPopulated() && theParamsUri.isEmpty()) {
            return;
        }
        this.getParamsUri().clear();
        this.getParamsUri().addAll(theParamsUri);
    }

    @Override
    public Long getResourceId() {
        return this.getId();
    }

    public Collection<ResourceLink> getResourceLinks() {
        if (this.myResourceLinks == null) {
            this.myResourceLinks = new ArrayList<ResourceLink>();
        }
        return this.myResourceLinks;
    }

    public void setResourceLinks(Collection<ResourceLink> theLinks) {
        if (!this.isHasLinks() && theLinks.isEmpty()) {
            return;
        }
        this.getResourceLinks().clear();
        this.getResourceLinks().addAll(theLinks);
    }

    @Override
    public String getResourceType() {
        return this.myResourceType;
    }

    public ResourceTable setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
        return this;
    }

    public Collection<ResourceTag> getTags() {
        if (this.myTags == null) {
            this.myTags = new HashSet<ResourceTag>();
        }
        return this.myTags;
    }

    @Override
    public long getVersion() {
        return this.myVersion;
    }

    public void initializeVersion() {
        assert (this.myId == null);
        this.myVersion = 1L;
    }

    @VisibleForTesting
    public void setVersionForUnitTest(long theVersion) {
        this.myVersion = theVersion;
    }

    @Override
    public boolean isDeleted() {
        return this.getDeleted() != null;
    }

    @Override
    public void setNotDeleted() {
        this.setDeleted(null);
    }

    public boolean isHasLinks() {
        return this.myHasLinks;
    }

    public void setHasLinks(boolean theHasLinks) {
        this.myHasLinks = theHasLinks;
    }

    public void clearAllParamsPopulated() {
        this.myParamsTokenPopulated = false;
        this.myParamsCoordsPopulated = false;
        this.myParamsDatePopulated = false;
        this.myParamsNumberPopulated = false;
        this.myParamsStringPopulated = false;
        this.myParamsQuantityPopulated = false;
        this.myParamsQuantityNormalizedPopulated = false;
        this.myParamsUriPopulated = false;
        this.myHasLinks = false;
    }

    public boolean isParamsComboStringUniquePresent() {
        if (this.myParamsComboStringUniquePresent == null) {
            return false;
        }
        return this.myParamsComboStringUniquePresent;
    }

    public void setParamsComboStringUniquePresent(boolean theParamsComboStringUniquePresent) {
        this.myParamsComboStringUniquePresent = theParamsComboStringUniquePresent;
    }

    public boolean isParamsComboTokensNonUniquePresent() {
        if (this.myParamsComboTokensNonUniquePresent == null) {
            return false;
        }
        return this.myParamsComboTokensNonUniquePresent;
    }

    public void setParamsComboTokensNonUniquePresent(boolean theParamsComboTokensNonUniquePresent) {
        this.myParamsComboTokensNonUniquePresent = theParamsComboTokensNonUniquePresent;
    }

    public boolean isParamsCoordsPopulated() {
        return this.myParamsCoordsPopulated;
    }

    public void setParamsCoordsPopulated(boolean theParamsCoordsPopulated) {
        this.myParamsCoordsPopulated = theParamsCoordsPopulated;
    }

    public boolean isParamsDatePopulated() {
        return this.myParamsDatePopulated;
    }

    public void setParamsDatePopulated(boolean theParamsDatePopulated) {
        this.myParamsDatePopulated = theParamsDatePopulated;
    }

    public boolean isParamsNumberPopulated() {
        return this.myParamsNumberPopulated;
    }

    public void setParamsNumberPopulated(boolean theParamsNumberPopulated) {
        this.myParamsNumberPopulated = theParamsNumberPopulated;
    }

    public boolean isParamsQuantityPopulated() {
        return this.myParamsQuantityPopulated;
    }

    public void setParamsQuantityPopulated(boolean theParamsQuantityPopulated) {
        this.myParamsQuantityPopulated = theParamsQuantityPopulated;
    }

    public Boolean isParamsQuantityNormalizedPopulated() {
        if (this.myParamsQuantityNormalizedPopulated == null) {
            return Boolean.FALSE;
        }
        return this.myParamsQuantityNormalizedPopulated;
    }

    public void setParamsQuantityNormalizedPopulated(Boolean theParamsQuantityNormalizedPopulated) {
        this.myParamsQuantityNormalizedPopulated = theParamsQuantityNormalizedPopulated == null ? Boolean.FALSE : theParamsQuantityNormalizedPopulated;
    }

    public boolean isParamsStringPopulated() {
        return this.myParamsStringPopulated;
    }

    public void setParamsStringPopulated(boolean theParamsStringPopulated) {
        this.myParamsStringPopulated = theParamsStringPopulated;
    }

    public boolean isParamsTokenPopulated() {
        return this.myParamsTokenPopulated;
    }

    public void setParamsTokenPopulated(boolean theParamsTokenPopulated) {
        this.myParamsTokenPopulated = theParamsTokenPopulated;
    }

    public boolean isParamsUriPopulated() {
        return this.myParamsUriPopulated;
    }

    public void setParamsUriPopulated(boolean theParamsUriPopulated) {
        this.myParamsUriPopulated = theParamsUriPopulated;
    }

    public boolean isUnchangedInCurrentOperation() {
        return this.myUnchangedInCurrentOperation;
    }

    public void setUnchangedInCurrentOperation(boolean theUnchangedInCurrentOperation) {
        this.myUnchangedInCurrentOperation = theUnchangedInCurrentOperation;
    }

    public String getContentText() {
        return this.myContentText;
    }

    public void setContentText(String theContentText) {
        this.myContentText = theContentText;
    }

    public void setNarrativeText(String theNarrativeText) {
        this.myNarrativeText = theNarrativeText;
    }

    public boolean isSearchUrlPresent() {
        return Boolean.TRUE.equals(this.mySearchUrlPresent);
    }

    public void setSearchUrlPresent(boolean theSearchUrlPresent) {
        this.mySearchUrlPresent = theSearchUrlPresent;
    }

    public ResourceHistoryTable toHistory(boolean theCreateVersionTags) {
        boolean createVersionTags = theCreateVersionTags;
        ResourceHistoryTable retVal = this.myNewVersionEntity;
        if (retVal == null) {
            this.myNewVersionEntity = retVal = new ResourceHistoryTable();
        } else {
            createVersionTags = false;
        }
        retVal.setResourceId(this.myId);
        retVal.setResourceType(this.myResourceType);
        retVal.setTransientForcedId(this.getFhirId());
        retVal.setFhirVersion(this.getFhirVersion());
        retVal.setResourceTable(this);
        retVal.setPartitionId(this.getPartitionId());
        retVal.setHasTags(this.isHasTags());
        if (this.isHasTags() && createVersionTags) {
            for (ResourceTag next : this.getTags()) {
                retVal.addTag(next);
            }
        }
        this.populateHistoryEntityVersionAndDates(retVal);
        return retVal;
    }

    public void populateHistoryEntityVersionAndDates(ResourceHistoryTable theResourceHistoryTable) {
        theResourceHistoryTable.setVersion(this.getVersion());
        theResourceHistoryTable.setPublished(this.getPublishedDate());
        theResourceHistoryTable.setUpdated(this.getUpdatedDate());
        theResourceHistoryTable.setDeleted(this.getDeleted());
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("pid", (Object)this.myId);
        b.append("fhirId", (Object)this.myFhirId);
        b.append("resourceType", (Object)this.myResourceType);
        b.append("version", this.myVersion);
        if (this.getPartitionId() != null) {
            b.append("partitionId", (Object)this.getPartitionId().getPartitionId());
        }
        b.append("lastUpdated", (Object)this.getUpdated().getValueAsString());
        if (this.getDeleted() != null) {
            b.append("deleted", (Object)new InstantType(this.getDeleted()).getValueAsString());
        }
        return b.build();
    }

    @PrePersist
    @PreUpdate
    public void preSave() {
        this.myResourceLinksField = this.myHasLinks && this.myResourceLinks != null ? this.getResourceLinks().stream().map(ResourceLink::getTargetResourcePid).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(" ")) : null;
    }

    public ResourceHistoryTable getCurrentVersionEntity() {
        return this.myCurrentVersionEntity;
    }

    public void setCurrentVersionEntity(ResourceHistoryTable theCurrentVersionEntity) {
        this.myCurrentVersionEntity = theCurrentVersionEntity;
    }

    @Override
    public JpaPid getPersistentId() {
        return JpaPid.fromId(this.getId());
    }

    @Override
    public IdDt getIdDt() {
        IdDt retVal = new IdDt();
        this.populateId((IIdType)retVal);
        return retVal;
    }

    public IIdType getIdType(FhirContext theContext) {
        IIdType retVal = theContext.getVersion().newIdType();
        this.populateId(retVal);
        return retVal;
    }

    private void populateId(IIdType retVal) {
        String resourceId;
        if (this.myFhirId != null && !this.myFhirId.isEmpty()) {
            resourceId = this.myFhirId;
        } else {
            Long id = this.getResourceId();
            resourceId = Long.toString(id);
        }
        retVal.setValue(this.getResourceType() + "/" + resourceId + "/_history/" + this.getVersion());
    }

    public String getCreatedByMatchUrl() {
        return this.myCreatedByMatchUrl;
    }

    public void setCreatedByMatchUrl(String theCreatedByMatchUrl) {
        this.myCreatedByMatchUrl = theCreatedByMatchUrl;
    }

    public String getUpdatedByMatchUrl() {
        return this.myUpdatedByMatchUrl;
    }

    public void setUpdatedByMatchUrl(String theUpdatedByMatchUrl) {
        this.myUpdatedByMatchUrl = theUpdatedByMatchUrl;
    }

    public boolean isVersionUpdatedInCurrentTransaction() {
        return this.myVersionUpdatedInCurrentTransaction;
    }

    public void setLuceneIndexData(ExtendedHSearchIndexData theLuceneIndexData) {
        this.myLuceneIndexData = theLuceneIndexData;
    }

    public Collection<SearchParamPresentEntity> getSearchParamPresents() {
        if (this.mySearchParamPresents == null) {
            this.mySearchParamPresents = new ArrayList<SearchParamPresentEntity>();
        }
        return this.mySearchParamPresents;
    }

    public String getFhirId() {
        return this.myFhirId;
    }

    public void setFhirId(String theFhirId) {
        this.myFhirId = theFhirId;
    }

    public String asTypedFhirResourceId() {
        return this.getResourceType() + "/" + this.getFhirId();
    }

    public static final class FhirIdGenerator
    implements ValueGenerator<String> {
        public String generateValue(Session session, Object owner) {
            ResourceTable that = (ResourceTable)owner;
            return that.myFhirId != null ? that.myFhirId : that.myId.toString();
        }
    }
}

