/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseTag;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="HFJ_RES_TAG", indexes={@Index(name="IDX_RES_TAG_RES_TAG", columnList="RES_ID, TAG_ID, PARTITION_ID"), @Index(name="IDX_RES_TAG_TAG_RES", columnList="TAG_ID, RES_ID, PARTITION_ID")}, uniqueConstraints={@UniqueConstraint(name="IDX_RESTAG_TAGID", columnNames={"RES_ID", "TAG_ID"})})
public class ResourceTag
extends BaseTag {
    private static final long serialVersionUID = 1L;
    @SequenceGenerator(name="SEQ_RESTAG_ID", sequenceName="SEQ_RESTAG_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESTAG_ID")
    @Id
    @Column(name="PID")
    private Long myId;
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="RES_ID", referencedColumnName="RES_ID", foreignKey=@ForeignKey(name="FK_RESTAG_RESOURCE"))
    private ResourceTable myResource;
    @Column(name="RES_TYPE", length=40, nullable=false)
    private String myResourceType;
    @Column(name="RES_ID", insertable=false, updatable=false)
    private Long myResourceId;

    public ResourceTag() {
    }

    public ResourceTag(ResourceTable theResourceTable, TagDefinition theTag, PartitionablePartitionId theRequestPartitionId) {
        this.setTag(theTag);
        this.setResource(theResourceTable);
        this.setResourceId(theResourceTable.getId());
        this.setResourceType(theResourceTable.getResourceType());
        this.setPartitionId(theRequestPartitionId);
    }

    public Long getResourceId() {
        return this.myResourceId;
    }

    public void setResourceId(Long theResourceId) {
        this.myResourceId = theResourceId;
    }

    public ResourceTable getResource() {
        return this.myResource;
    }

    public void setResource(ResourceTable theResource) {
        this.myResource = theResource;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTag)) {
            return false;
        }
        ResourceTag other = (ResourceTag)obj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getResourceId(), (Object)other.getResourceId());
        b.append((Object)this.getTag(), (Object)other.getTag());
        return b.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getResourceId());
        b.append((Object)this.getTag());
        return b.toHashCode();
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        if (this.getPartitionId() != null) {
            b.append("partition", (Object)this.getPartitionId().getPartitionId());
        }
        b.append("resId", (Object)this.getResourceId());
        b.append("tag", (Object)this.getTag().getId());
        return b.build();
    }
}

