/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.search;

import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.search.CompositeSearchIndexData;
import ca.uhn.fhir.jpa.model.search.DateSearchIndexData;
import ca.uhn.fhir.jpa.model.search.HSearchElementCache;
import ca.uhn.fhir.jpa.model.search.QuantitySearchIndexData;
import ca.uhn.fhir.jpa.model.util.UcumServiceUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.fhir.ucum.Pair;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSearchIndexWriter {
    private static final Logger ourLog = LoggerFactory.getLogger(HSearchIndexWriter.class);
    public static final String NESTED_SEARCH_PARAM_ROOT = "nsp";
    public static final String SEARCH_PARAM_ROOT = "sp";
    public static final String INDEX_TYPE_STRING = "string";
    public static final String IDX_STRING_NORMALIZED = "norm";
    public static final String IDX_STRING_EXACT = "exact";
    public static final String IDX_STRING_TEXT = "text";
    public static final String IDX_STRING_LOWER = "lower";
    public static final String INDEX_TYPE_TOKEN = "token";
    public static final String TOKEN_CODE = "code";
    public static final String TOKEN_SYSTEM = "system";
    public static final String TOKEN_SYSTEM_CODE = "code-system";
    public static final String INDEX_TYPE_QUANTITY = "quantity";
    public static final String VALUE_FIELD = "value";
    public static final String QTY_CODE = "code";
    public static final String QTY_SYSTEM = "system";
    public static final String QTY_VALUE = "value";
    public static final String QTY_CODE_NORM = "code-norm";
    public static final String QTY_VALUE_NORM = "value-norm";
    public static final String URI_VALUE = "uri-value";
    public static final String NUMBER_VALUE = "number-value";
    public static final String DATE_LOWER_ORD = "lower-ord";
    public static final String DATE_LOWER = "lower";
    public static final String DATE_UPPER_ORD = "upper-ord";
    public static final String DATE_UPPER = "upper";
    final HSearchElementCache myNodeCache;
    final StorageSettings myStorageSettings;

    HSearchIndexWriter(StorageSettings theStorageSettings, DocumentElement theRoot) {
        this.myStorageSettings = theStorageSettings;
        this.myNodeCache = new HSearchElementCache(theRoot);
    }

    public DocumentElement getSearchParamIndexNode(String theSearchParamName, String theIndexType) {
        return this.myNodeCache.getObjectElement(SEARCH_PARAM_ROOT, theSearchParamName, theIndexType);
    }

    public static HSearchIndexWriter forRoot(StorageSettings theStorageSettings, DocumentElement theDocument) {
        return new HSearchIndexWriter(theStorageSettings, theDocument);
    }

    public void writeStringIndex(String theSearchParam, String theValue) {
        DocumentElement stringIndexNode = this.getSearchParamIndexNode(theSearchParam, INDEX_TYPE_STRING);
        this.writeBasicStringFields(stringIndexNode, theValue);
        this.addDocumentValue(stringIndexNode, IDX_STRING_EXACT, theValue);
        this.addDocumentValue(stringIndexNode, IDX_STRING_TEXT, theValue);
        this.addDocumentValue(stringIndexNode, "lower", theValue);
        ourLog.debug("Adding Search Param Text: {} -- {}", (Object)theSearchParam, (Object)theValue);
    }

    public void writeBasicStringFields(DocumentElement theIndexNode, String theValue) {
        this.addDocumentValue(theIndexNode, IDX_STRING_NORMALIZED, theValue);
    }

    public void writeTokenIndex(String theSearchParam, IBaseCoding theValue) {
        DocumentElement nestedRoot = this.myNodeCache.getObjectElement(NESTED_SEARCH_PARAM_ROOT);
        DocumentElement nestedSpNode = nestedRoot.addObject(theSearchParam);
        DocumentElement nestedTokenNode = nestedSpNode.addObject(INDEX_TYPE_TOKEN);
        this.writeTokenFields(nestedTokenNode, theValue);
        if (StringUtils.isNotEmpty((CharSequence)theValue.getDisplay())) {
            DocumentElement nestedStringNode = nestedSpNode.addObject(INDEX_TYPE_STRING);
            this.addDocumentValue(nestedStringNode, IDX_STRING_TEXT, theValue.getDisplay());
        }
        DocumentElement tokenIndexNode = this.getSearchParamIndexNode(theSearchParam, INDEX_TYPE_TOKEN);
        this.writeTokenFields(tokenIndexNode, theValue);
        ourLog.debug("Adding Search Param Token: {} -- {}", (Object)theSearchParam, (Object)theValue);
    }

    public void writeTokenFields(DocumentElement theDocumentElement, IBaseCoding theValue) {
        this.addDocumentValue(theDocumentElement, "code", theValue.getCode());
        this.addDocumentValue(theDocumentElement, "system", theValue.getSystem());
        this.addDocumentValue(theDocumentElement, TOKEN_SYSTEM_CODE, theValue.getSystem() + "|" + theValue.getCode());
    }

    private void addDocumentValue(DocumentElement theDocumentElement, String theKey, Object theValue) {
        if (theValue != null) {
            theDocumentElement.addValue(theKey, theValue);
        }
    }

    public void writeReferenceIndex(String theSearchParam, String theValue) {
        DocumentElement referenceIndexNode = this.getSearchParamIndexNode(theSearchParam, "reference");
        this.addDocumentValue(referenceIndexNode, "value", theValue);
        ourLog.trace("Adding Search Param Reference: {} -- {}", (Object)theSearchParam, (Object)theValue);
    }

    public void writeDateIndex(String theSearchParam, DateSearchIndexData theValue) {
        DocumentElement dateIndexNode = this.getSearchParamIndexNode(theSearchParam, "dt");
        this.writeDateFields(dateIndexNode, theValue);
        ourLog.trace("Adding Search Param Date. param: {} -- {}", (Object)theSearchParam, (Object)theValue);
    }

    public void writeDateFields(DocumentElement dateIndexNode, DateSearchIndexData theValue) {
        this.addDocumentValue(dateIndexNode, DATE_LOWER_ORD, theValue.getLowerBoundOrdinal());
        this.addDocumentValue(dateIndexNode, "lower", theValue.getLowerBoundDate().toInstant());
        this.addDocumentValue(dateIndexNode, DATE_UPPER_ORD, theValue.getUpperBoundOrdinal());
        this.addDocumentValue(dateIndexNode, DATE_UPPER, theValue.getUpperBoundDate().toInstant());
    }

    public void writeQuantityIndex(String theSearchParam, QuantitySearchIndexData theValue) {
        DocumentElement nestedRoot = this.myNodeCache.getObjectElement(NESTED_SEARCH_PARAM_ROOT);
        DocumentElement nestedSpNode = nestedRoot.addObject(theSearchParam);
        DocumentElement nestedQtyNode = nestedSpNode.addObject(INDEX_TYPE_QUANTITY);
        ourLog.trace("Adding Search Param Quantity: {} -- {}", (Object)theSearchParam, (Object)theValue);
        this.writeQuantityFields(nestedQtyNode, theValue);
    }

    public void writeQuantityFields(DocumentElement nestedQtyNode, QuantitySearchIndexData theValue) {
        this.addDocumentValue(nestedQtyNode, "code", theValue.getCode());
        this.addDocumentValue(nestedQtyNode, "system", theValue.getSystem());
        this.addDocumentValue(nestedQtyNode, "value", theValue.getValue());
        if (!this.myStorageSettings.getNormalizedQuantitySearchLevel().storageOrSearchSupported()) {
            return;
        }
        Pair canonicalForm = UcumServiceUtil.getCanonicalForm(theValue.getSystem(), BigDecimal.valueOf(theValue.getValue()), theValue.getCode());
        if (canonicalForm == null) {
            return;
        }
        double canonicalValue = Double.parseDouble(canonicalForm.getValue().asDecimal());
        String canonicalUnits = canonicalForm.getCode();
        this.addDocumentValue(nestedQtyNode, QTY_CODE_NORM, canonicalUnits);
        this.addDocumentValue(nestedQtyNode, QTY_VALUE_NORM, canonicalValue);
    }

    public void writeUriIndex(String theParamName, Collection<String> theUriValueCollection) {
        DocumentElement uriNode = this.myNodeCache.getObjectElement(SEARCH_PARAM_ROOT).addObject(theParamName);
        for (String uriSearchIndexValue : theUriValueCollection) {
            ourLog.trace("Adding Search Param Uri: {} -- {}", (Object)theParamName, (Object)uriSearchIndexValue);
            this.writeUriFields(uriNode, uriSearchIndexValue);
        }
    }

    public void writeUriFields(DocumentElement uriNode, String uriSearchIndexValue) {
        this.addDocumentValue(uriNode, URI_VALUE, uriSearchIndexValue);
    }

    public void writeNumberIndex(String theParamName, Collection<BigDecimal> theNumberValueCollection) {
        DocumentElement numberNode = this.myNodeCache.getObjectElement(SEARCH_PARAM_ROOT).addObject(theParamName);
        for (BigDecimal numberSearchIndexValue : theNumberValueCollection) {
            ourLog.trace("Adding Search Param Number: {} -- {}", (Object)theParamName, (Object)numberSearchIndexValue);
            this.writeNumberFields(numberNode, numberSearchIndexValue);
        }
    }

    public void writeNumberFields(DocumentElement numberNode, BigDecimal numberSearchIndexValue) {
        this.addDocumentValue(numberNode, NUMBER_VALUE, numberSearchIndexValue.doubleValue());
    }

    public void writeCompositeIndex(String ignoredParamName, Set<CompositeSearchIndexData> theCompositeSearchIndexData) {
        for (CompositeSearchIndexData compositeSearchIndexDatum : theCompositeSearchIndexData) {
            compositeSearchIndexDatum.writeIndexEntry(this, this.myNodeCache);
        }
    }
}

