/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.config;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.hl7.fhir.dstu2.model.Subscription;

public abstract class BaseSubscriptionSettings {
    public static final String DEFAULT_EMAIL_FROM_ADDRESS = "noreply@unknown.com";
    public static final String DEFAULT_WEBSOCKET_CONTEXT_PATH = "/websocket";
    private final Set<Subscription.SubscriptionChannelType> mySupportedSubscriptionTypes = new HashSet<Subscription.SubscriptionChannelType>();
    private String myEmailFromAddress = "noreply@unknown.com";
    private String myWebsocketContextPath = "/websocket";
    private boolean myQualifySubscriptionMatchingChannelName = true;
    private boolean myCrossPartitionSubscriptionEnabled = true;
    private boolean myEnableInMemorySubscriptionMatching = true;
    private boolean myTriggerSubscriptionsForNonVersioningChanges;
    private boolean myAllowOnlyInMemorySubscriptions = false;

    public void addSupportedSubscriptionType(Subscription.SubscriptionChannelType theSubscriptionChannelType) {
        this.mySupportedSubscriptionTypes.add(theSubscriptionChannelType);
    }

    public Set<Subscription.SubscriptionChannelType> getSupportedSubscriptionTypes() {
        return Collections.unmodifiableSet(this.mySupportedSubscriptionTypes);
    }

    public boolean hasSupportedSubscriptionTypes() {
        return CollectionUtils.isNotEmpty(this.mySupportedSubscriptionTypes);
    }

    @VisibleForTesting
    public void clearSupportedSubscriptionTypesForUnitTest() {
        this.mySupportedSubscriptionTypes.clear();
    }

    public String getEmailFromAddress() {
        return this.myEmailFromAddress;
    }

    public void setEmailFromAddress(String theEmailFromAddress) {
        this.myEmailFromAddress = theEmailFromAddress;
    }

    public String getWebsocketContextPath() {
        return this.myWebsocketContextPath;
    }

    public void setWebsocketContextPath(String theWebsocketContextPath) {
        this.myWebsocketContextPath = theWebsocketContextPath;
    }

    public boolean isQualifySubscriptionMatchingChannelName() {
        return this.myQualifySubscriptionMatchingChannelName;
    }

    public void setQualifySubscriptionMatchingChannelName(boolean theQualifySubscriptionMatchingChannelName) {
        this.myQualifySubscriptionMatchingChannelName = theQualifySubscriptionMatchingChannelName;
    }

    public boolean isCrossPartitionSubscriptionEnabled() {
        return this.myCrossPartitionSubscriptionEnabled;
    }

    public void setCrossPartitionSubscriptionEnabled(boolean theAllowCrossPartitionSubscription) {
        this.myCrossPartitionSubscriptionEnabled = theAllowCrossPartitionSubscription;
    }

    public void setOnlyAllowInMemorySubscriptions(boolean theAllowOnlyInMemorySearchParams) {
        this.myAllowOnlyInMemorySubscriptions = theAllowOnlyInMemorySearchParams;
    }

    public boolean isOnlyAllowInMemorySubscriptions() {
        return this.myAllowOnlyInMemorySubscriptions;
    }

    public boolean isEnableInMemorySubscriptionMatching() {
        return this.myEnableInMemorySubscriptionMatching;
    }

    public void setEnableInMemorySubscriptionMatching(boolean theEnableInMemorySubscriptionMatching) {
        this.myEnableInMemorySubscriptionMatching = theEnableInMemorySubscriptionMatching;
    }

    public boolean isTriggerSubscriptionsForNonVersioningChanges() {
        return this.myTriggerSubscriptionsForNonVersioningChanges;
    }

    public void setTriggerSubscriptionsForNonVersioningChanges(boolean theTriggerSubscriptionsForNonVersioningChanges) {
        this.myTriggerSubscriptionsForNonVersioningChanges = theTriggerSubscriptionsForNonVersioningChanges;
    }
}

