/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.jpa.model.entity.NpmPackageEntity;
import ca.uhn.fhir.jpa.model.entity.NpmPackageVersionResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.util.StringUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="NPM_PACKAGE_VER", uniqueConstraints={}, indexes={@Index(name="IDX_PACKVER", columnList="PACKAGE_ID,VERSION_ID", unique=true), @Index(name="FK_NPM_PKV_PKG", columnList="PACKAGE_PID"), @Index(name="FK_NPM_PKV_RESID", columnList="BINARY_RES_ID")})
public class NpmPackageVersionEntity {
    public static final int VERSION_ID_LENGTH = 200;
    public static final int PACKAGE_DESC_LENGTH = 200;
    public static final int FHIR_VERSION_LENGTH = 10;
    public static final int FHIR_VERSION_ID_LENGTH = 20;
    @SequenceGenerator(name="SEQ_NPM_PACKVER", sequenceName="SEQ_NPM_PACKVER")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_NPM_PACKVER")
    @Id
    @Column(name="PID")
    private Long myId;
    @Column(name="PACKAGE_ID", length=200, nullable=false)
    private String myPackageId;
    @Column(name="VERSION_ID", length=200, nullable=false)
    private String myVersionId;
    @ManyToOne
    @JoinColumn(name="PACKAGE_PID", nullable=false, foreignKey=@ForeignKey(name="FK_NPM_PKV_PKG"))
    private NpmPackageEntity myPackage;
    @ManyToOne
    @JoinColumn(name="BINARY_RES_ID", referencedColumnName="RES_ID", nullable=false, foreignKey=@ForeignKey(name="FK_NPM_PKV_RESID"))
    private ResourceTable myPackageBinary;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="SAVED_TIME", nullable=false)
    private Date mySavedTime;
    @Column(name="PKG_DESC", nullable=true, length=200)
    private String myDescription;
    @Column(name="DESC_UPPER", nullable=true, length=200)
    private String myDescriptionUpper;
    @Column(name="CURRENT_VERSION", nullable=false)
    private boolean myCurrentVersion;
    @Column(name="FHIR_VERSION_ID", length=20, nullable=false)
    private String myFhirVersionId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="FHIR_VERSION", length=10, nullable=false)
    private FhirVersionEnum myFhirVersion;
    @Column(name="PACKAGE_SIZE_BYTES", nullable=false)
    private long myPackageSizeBytes;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Version
    @Column(name="UPDATED_TIME", nullable=false)
    private Date myUpdatedTime;
    @OneToMany(mappedBy="myPackageVersion")
    private List<NpmPackageVersionResourceEntity> myResources;

    public Date getUpdatedTime() {
        return this.myUpdatedTime;
    }

    public long getPackageSizeBytes() {
        return this.myPackageSizeBytes;
    }

    public void setPackageSizeBytes(long thePackageSizeBytes) {
        this.myPackageSizeBytes = thePackageSizeBytes;
    }

    public boolean isCurrentVersion() {
        return this.myCurrentVersion;
    }

    public void setCurrentVersion(boolean theCurrentVersion) {
        this.myCurrentVersion = theCurrentVersion;
    }

    public String getPackageId() {
        return this.myPackageId;
    }

    public void setPackageId(String thePackageId) {
        this.myPackageId = thePackageId;
    }

    public String getVersionId() {
        return this.myVersionId;
    }

    public void setVersionId(String theVersionId) {
        this.myVersionId = theVersionId;
    }

    public String getFhirVersionId() {
        return this.myFhirVersionId;
    }

    public void setFhirVersionId(String theFhirVersionId) {
        this.myFhirVersionId = theFhirVersionId;
    }

    public FhirVersionEnum getFhirVersion() {
        return this.myFhirVersion;
    }

    public void setFhirVersion(FhirVersionEnum theFhirVersion) {
        this.myFhirVersion = theFhirVersion;
    }

    public NpmPackageEntity getPackage() {
        return this.myPackage;
    }

    public void setPackage(NpmPackageEntity thePackage) {
        this.myPackage = thePackage;
    }

    public ResourceTable getPackageBinary() {
        return this.myPackageBinary;
    }

    public void setPackageBinary(ResourceTable thePackageBinary) {
        this.myPackageBinary = thePackageBinary;
    }

    public void setSavedTime(Date theSavedTime) {
        this.mySavedTime = theSavedTime;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String theDescription) {
        this.myDescription = theDescription;
        this.myDescriptionUpper = StringUtil.normalizeStringForSearchIndexing((String)theDescription);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("myId", (Object)this.myId).append("myPackageId", (Object)this.myPackageId).append("myVersionId", (Object)this.myVersionId).append("myDescriptionUpper", (Object)this.myDescriptionUpper).append("myFhirVersionId", (Object)this.myFhirVersionId).toString();
    }

    public List<NpmPackageVersionResourceEntity> getResources() {
        return this.myResources;
    }
}

