/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.ResourceEncodingEnum;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryProvenanceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTag;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.model.primitive.IdDt;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.OptimisticLock;

@Entity
@Table(name="HFJ_RES_VER", uniqueConstraints={@UniqueConstraint(name="IDX_RESVER_ID_VER", columnNames={"RES_ID", "RES_VER"})}, indexes={@Index(name="IDX_RESVER_TYPE_DATE", columnList="RES_TYPE,RES_UPDATED,RES_ID"), @Index(name="IDX_RESVER_ID_DATE", columnList="RES_ID,RES_UPDATED"), @Index(name="IDX_RESVER_DATE", columnList="RES_UPDATED,RES_ID")})
public class ResourceHistoryTable
extends BaseHasResource
implements Serializable {
    public static final String IDX_RESVER_ID_VER = "IDX_RESVER_ID_VER";
    public static final int SOURCE_URI_LENGTH = 100;
    public static final int ENCODING_COL_LENGTH = 5;
    public static final String HFJ_RES_VER = "HFJ_RES_VER";
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_RESOURCE_HISTORY_ID", sequenceName="SEQ_RESOURCE_HISTORY_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESOURCE_HISTORY_ID")
    @Column(name="PID")
    private Long myId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="RES_ID", nullable=false, updatable=false, foreignKey=@ForeignKey(name="FK_RESOURCE_HISTORY_RESOURCE"))
    private ResourceTable myResourceTable;
    @Column(name="RES_ID", nullable=false, updatable=false, insertable=false)
    private Long myResourceId;
    @Column(name="RES_TYPE", length=40, nullable=false)
    private String myResourceType;
    @Column(name="RES_VER", nullable=false)
    private Long myResourceVersion;
    @OneToMany(mappedBy="myResourceHistory", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    private Collection<ResourceHistoryTag> myTags;
    @Column(name="RES_TEXT", length=0x7FFFFFFE, nullable=true)
    @Lob
    @OptimisticLock(excluded=true)
    private byte[] myResource;
    @Column(name="RES_TEXT_VC", length=0x7FFFFFFF, nullable=true)
    @OptimisticLock(excluded=true)
    private String myResourceTextVc;
    @Column(name="RES_ENCODING", nullable=false, length=5)
    @Enumerated(value=EnumType.STRING)
    @OptimisticLock(excluded=true)
    private ResourceEncodingEnum myEncoding;
    @OneToOne(mappedBy="myResourceHistoryTable", cascade={CascadeType.REMOVE})
    private ResourceHistoryProvenanceEntity myProvenance;
    @Column(name="SOURCE_URI", length=100, nullable=true)
    private String mySourceUri;
    @Column(name="REQUEST_ID", length=16, nullable=true)
    private String myRequestId;
    @Transient
    private transient ResourceHistoryProvenanceEntity myNewHistoryProvenanceEntity;
    @Transient
    private transient String myTransientForcedId;

    public String getSourceUri() {
        return this.mySourceUri;
    }

    public void setSourceUri(String theSourceUri) {
        this.mySourceUri = theSourceUri;
    }

    public String getRequestId() {
        return this.myRequestId;
    }

    public void setRequestId(String theRequestId) {
        this.myRequestId = theRequestId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("resourceId", (Object)this.myResourceId).append("resourceType", (Object)this.myResourceType).append("resourceVersion", (Object)this.myResourceVersion).append("pid", (Object)this.myId).toString();
    }

    public String getResourceTextVc() {
        return this.myResourceTextVc;
    }

    public void setResourceTextVc(String theResourceTextVc) {
        this.myResourceTextVc = theResourceTextVc;
    }

    public ResourceHistoryProvenanceEntity getProvenance() {
        return this.myProvenance;
    }

    public void addTag(ResourceTag theTag) {
        ResourceHistoryTag tag = new ResourceHistoryTag(this, theTag.getTag(), this.getPartitionId());
        tag.setResourceType(theTag.getResourceType());
        this.getTags().add(tag);
    }

    @Override
    public ResourceHistoryTag addTag(TagDefinition theTag) {
        for (ResourceHistoryTag next : this.getTags()) {
            if (!next.getTag().equals(theTag)) continue;
            return next;
        }
        ResourceHistoryTag historyTag = new ResourceHistoryTag(this, theTag, this.getPartitionId());
        this.getTags().add(historyTag);
        return historyTag;
    }

    public ResourceEncodingEnum getEncoding() {
        return this.myEncoding;
    }

    public void setEncoding(ResourceEncodingEnum theEncoding) {
        this.myEncoding = theEncoding;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    public Long getMyId() {
        return this.myId;
    }

    public void setMyId(Long theId) {
        this.myId = theId;
    }

    public byte[] getResource() {
        return this.myResource;
    }

    public void setResource(byte[] theResource) {
        this.myResource = theResource;
    }

    @Override
    public Long getResourceId() {
        return this.myResourceId;
    }

    public void setResourceId(Long theResourceId) {
        this.myResourceId = theResourceId;
    }

    @Override
    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public Collection<ResourceHistoryTag> getTags() {
        if (this.myTags == null) {
            this.myTags = new ArrayList<ResourceHistoryTag>();
        }
        return this.myTags;
    }

    @Override
    public long getVersion() {
        return this.myResourceVersion;
    }

    public void setVersion(long theVersion) {
        this.myResourceVersion = theVersion;
    }

    @Override
    public boolean isDeleted() {
        return this.getDeleted() != null;
    }

    @Override
    public void setNotDeleted() {
        this.setDeleted(null);
    }

    @Override
    public JpaPid getPersistentId() {
        return JpaPid.fromId(this.myResourceId);
    }

    public ResourceTable getResourceTable() {
        return this.myResourceTable;
    }

    public void setResourceTable(ResourceTable theResourceTable) {
        this.myResourceTable = theResourceTable;
    }

    @Override
    public IdDt getIdDt() {
        String resourceIdPart = this.getTransientForcedId() != null ? this.getTransientForcedId() : this.getResourceTable().getFhirId();
        return new IdDt(this.getResourceType() + "/" + resourceIdPart + "/_history/" + this.getVersion());
    }

    public boolean hasResource() {
        return this.myResource != null || this.myResourceTextVc != null;
    }

    public ResourceHistoryProvenanceEntity toProvenance() {
        if (this.myNewHistoryProvenanceEntity == null) {
            this.myNewHistoryProvenanceEntity = new ResourceHistoryProvenanceEntity();
        }
        return this.myNewHistoryProvenanceEntity;
    }

    public String getTransientForcedId() {
        return this.myTransientForcedId;
    }

    public void setTransientForcedId(String theTransientForcedId) {
        this.myTransientForcedId = theTransientForcedId;
    }
}

