/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedCombo;
import ca.uhn.fhir.jpa.model.entity.IResourceIndexComboSearchParameter;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.util.SearchParamHash;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IIdType;

@Entity
@Table(name="HFJ_IDX_CMP_STRING_UNIQ", indexes={@Index(name="IDX_IDXCMPSTRUNIQ_STRING", columnList="IDX_STRING", unique=true), @Index(name="IDX_IDXCMPSTRUNIQ_RESOURCE", columnList="RES_ID", unique=false)})
public class ResourceIndexedComboStringUnique
extends BaseResourceIndexedCombo
implements Comparable<ResourceIndexedComboStringUnique>,
IResourceIndexComboSearchParameter {
    public static final int MAX_STRING_LENGTH = 500;
    public static final String IDX_IDXCMPSTRUNIQ_STRING = "IDX_IDXCMPSTRUNIQ_STRING";
    public static final String IDX_IDXCMPSTRUNIQ_RESOURCE = "IDX_IDXCMPSTRUNIQ_RESOURCE";
    @SequenceGenerator(name="SEQ_IDXCMPSTRUNIQ_ID", sequenceName="SEQ_IDXCMPSTRUNIQ_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_IDXCMPSTRUNIQ_ID")
    @Id
    @Column(name="PID")
    private Long myId;
    @ManyToOne
    @JoinColumn(name="RES_ID", referencedColumnName="RES_ID", foreignKey=@ForeignKey(name="FK_IDXCMPSTRUNIQ_RES_ID"))
    private ResourceTable myResource;
    @Column(name="RES_ID", insertable=false, updatable=false)
    private Long myResourceId;
    @Column(name="HASH_COMPLETE")
    private Long myHashComplete;
    @Column(name="HASH_COMPLETE_2")
    private Long myHashComplete2;
    @Column(name="IDX_STRING", nullable=false, length=500)
    private String myIndexString;
    @Column(name="PARTITION_ID", insertable=false, updatable=false, nullable=true)
    private Integer myPartitionIdValue;

    public ResourceIndexedComboStringUnique() {
    }

    public ResourceIndexedComboStringUnique(ResourceTable theResource, String theIndexString, IIdType theSearchParameterId) {
        this.setResource(theResource);
        this.setIndexString(theIndexString);
        this.setPartitionId(theResource.getPartitionId());
        this.setSearchParameterId(theSearchParameterId);
    }

    @Override
    public int compareTo(ResourceIndexedComboStringUnique theO) {
        CompareToBuilder b = new CompareToBuilder();
        b.append((Object)this.myIndexString, (Object)theO.getIndexString());
        return b.toComparison();
    }

    @Override
    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (!(theO instanceof ResourceIndexedComboStringUnique)) {
            return false;
        }
        this.calculateHashes();
        ResourceIndexedComboStringUnique that = (ResourceIndexedComboStringUnique)theO;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.myHashComplete, (Object)that.myHashComplete);
        b.append((Object)this.myHashComplete2, (Object)that.myHashComplete2);
        return b.isEquals();
    }

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        ResourceIndexedComboStringUnique source = (ResourceIndexedComboStringUnique)theSource;
        this.myIndexString = source.myIndexString;
        this.myHashComplete = source.myHashComplete;
        this.myHashComplete2 = source.myHashComplete2;
    }

    @Override
    public String getIndexString() {
        return this.myIndexString;
    }

    public void setIndexString(String theIndexString) {
        this.myIndexString = theIndexString;
    }

    @Override
    public ResourceTable getResource() {
        return this.myResource;
    }

    @Override
    public void setResource(ResourceTable theResource) {
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        this.myResource = theResource;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    public Long getHashComplete() {
        return this.myHashComplete;
    }

    public void setHashComplete(Long theHashComplete) {
        this.myHashComplete = theHashComplete;
    }

    public Long getHashComplete2() {
        return this.myHashComplete2;
    }

    public void setHashComplete2(Long theHashComplete2) {
        this.myHashComplete2 = theHashComplete2;
    }

    @Override
    public void setPlaceholderHashesIfMissing() {
        super.setPlaceholderHashesIfMissing();
        if (this.myHashComplete == null) {
            this.myHashComplete = 0L;
        }
        if (this.myHashComplete2 == null) {
            this.myHashComplete2 = 0L;
        }
    }

    @Override
    public void calculateHashes() {
        if (this.myHashComplete == null) {
            this.setHashComplete(ResourceIndexedComboStringUnique.calculateHashComplete(this.myIndexString));
            this.setHashComplete2(ResourceIndexedComboStringUnique.calculateHashComplete2(this.myIndexString));
        }
    }

    public static long calculateHashComplete(String theQueryString) {
        return SearchParamHash.hashSearchParam(theQueryString);
    }

    public static long calculateHashComplete2(String theQueryString) {
        String newQueryString = theQueryString + "ABC123";
        return ResourceIndexedComboStringUnique.calculateHashComplete(newQueryString);
    }

    @Override
    public void clearHashes() {
        this.myHashComplete = null;
        this.myHashComplete2 = null;
    }

    @Override
    public int hashCode() {
        this.calculateHashes();
        HashCodeBuilder b = new HashCodeBuilder(17, 37);
        b.append((Object)this.myHashComplete);
        b.append((Object)this.myHashComplete2);
        return b.toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.myId).append("resourceId", (Object)this.myResourceId).append("indexString", (Object)this.myIndexString).append("hashComplete", (Object)this.myHashComplete).append("hashComplete2", (Object)this.myHashComplete2).append("partition", (Object)this.getPartitionId()).toString();
    }
}

