/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.listener.IndexStorageOptimizationListener;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.util.DateUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;
import org.hl7.fhir.r4.model.DateTimeType;

@Embeddable
@EntityListeners(value={IndexStorageOptimizationListener.class})
@Entity
@Table(name="HFJ_SPIDX_DATE", indexes={@Index(name="IDX_SP_DATE_HASH_V2", columnList="HASH_IDENTITY,SP_VALUE_LOW,SP_VALUE_HIGH,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_DATE_HASH_HIGH_V2", columnList="HASH_IDENTITY,SP_VALUE_HIGH,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_DATE_ORD_HASH_V2", columnList="HASH_IDENTITY,SP_VALUE_LOW_DATE_ORDINAL,SP_VALUE_HIGH_DATE_ORDINAL,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_DATE_ORD_HASH_HIGH_V2", columnList="HASH_IDENTITY,SP_VALUE_HIGH_DATE_ORDINAL,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_DATE_RESID_V2", columnList="RES_ID,HASH_IDENTITY,SP_VALUE_LOW,SP_VALUE_HIGH,SP_VALUE_LOW_DATE_ORDINAL,SP_VALUE_HIGH_DATE_ORDINAL,PARTITION_ID")})
public class ResourceIndexedSearchParamDate
extends BaseResourceIndexedSearchParam {
    private static final long serialVersionUID = 1L;
    @Column(name="SP_VALUE_HIGH", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    @FullTextField
    public Date myValueHigh;
    @Column(name="SP_VALUE_LOW", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    @FullTextField
    public Date myValueLow;
    @Column(name="SP_VALUE_LOW_DATE_ORDINAL")
    public Integer myValueLowDateOrdinal;
    @Column(name="SP_VALUE_HIGH_DATE_ORDINAL")
    public Integer myValueHighDateOrdinal;
    @Transient
    private transient String myOriginalValue;
    @Id
    @SequenceGenerator(name="SEQ_SPIDX_DATE", sequenceName="SEQ_SPIDX_DATE")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_DATE")
    @Column(name="SP_ID")
    private Long myId;
    @ManyToOne(optional=false, fetch=FetchType.LAZY, cascade={})
    @JoinColumn(nullable=false, name="RES_ID", referencedColumnName="RES_ID", foreignKey=@ForeignKey(name="FK_SP_DATE_RES"))
    private ResourceTable myResource;

    public ResourceIndexedSearchParamDate() {
    }

    public ResourceIndexedSearchParamDate(PartitionSettings thePartitionSettings, String theResourceType, String theParamName, Date theLow, String theLowString, Date theHigh, String theHighString, String theOriginalValue) {
        this.setPartitionSettings(thePartitionSettings);
        this.setResourceType(theResourceType);
        this.setParamName(theParamName);
        this.setValueLow(theLow);
        this.setValueHigh(theHigh);
        if (theHigh != null && theHighString == null) {
            theHighString = DateUtils.convertDateToIso8601String((Date)theHigh);
        }
        if (theLow != null && theLowString == null) {
            theLowString = DateUtils.convertDateToIso8601String((Date)theLow);
        }
        this.computeValueHighDateOrdinal(theHighString);
        this.computeValueLowDateOrdinal(theLowString);
        this.reComputeValueHighDate(theHigh, theHighString);
        this.myOriginalValue = theOriginalValue;
        this.calculateHashes();
    }

    private void computeValueHighDateOrdinal(String theHigh) {
        if (!StringUtils.isBlank((CharSequence)theHigh)) {
            this.myValueHighDateOrdinal = this.generateHighOrdinalDateInteger(theHigh);
        }
    }

    private void reComputeValueHighDate(Date theHigh, String theHighString) {
        if (StringUtils.isBlank((CharSequence)theHighString) || theHigh == null) {
            return;
        }
        if (theHighString.length() == 4 || theHighString.length() == 7 || theHighString.length() == 10) {
            String theCompleteDateStr = (String)DateUtils.getCompletedDate((String)theHighString).getRight();
            try {
                Date complateDate = new SimpleDateFormat("yyyy-MM-dd").parse(theCompleteDateStr);
                this.myValueHigh = DateUtils.getEndOfDay((Date)complateDate);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private int generateLowOrdinalDateInteger(String theDateString) {
        if (theDateString.contains("T")) {
            theDateString = theDateString.substring(0, theDateString.indexOf("T"));
        }
        theDateString = (String)DateUtils.getCompletedDate((String)theDateString).getLeft();
        theDateString = theDateString.replace("-", "");
        return Integer.valueOf(theDateString);
    }

    private int generateHighOrdinalDateInteger(String theDateString) {
        if (theDateString.contains("T")) {
            theDateString = theDateString.substring(0, theDateString.indexOf("T"));
        }
        theDateString = (String)DateUtils.getCompletedDate((String)theDateString).getRight();
        theDateString = theDateString.replace("-", "");
        return Integer.valueOf(theDateString);
    }

    private void computeValueLowDateOrdinal(String theLow) {
        if (StringUtils.isNotBlank((CharSequence)theLow)) {
            this.myValueLowDateOrdinal = this.generateLowOrdinalDateInteger(theLow);
        }
    }

    public Integer getValueLowDateOrdinal() {
        return this.myValueLowDateOrdinal;
    }

    public Integer getValueHighDateOrdinal() {
        return this.myValueHighDateOrdinal;
    }

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        super.copyMutableValuesFrom(theSource);
        ResourceIndexedSearchParamDate source = (ResourceIndexedSearchParamDate)theSource;
        this.myValueHigh = source.myValueHigh;
        this.myValueLow = source.myValueLow;
        this.myValueHighDateOrdinal = source.myValueHighDateOrdinal;
        this.myValueLowDateOrdinal = source.myValueLowDateOrdinal;
        this.myHashIdentity = source.myHashIdentity;
    }

    @Override
    public void clearHashes() {
        this.myHashIdentity = null;
    }

    @Override
    public void calculateHashes() {
        if (this.myHashIdentity != null) {
            return;
        }
        String resourceType = this.getResourceType();
        String paramName = this.getParamName();
        this.setHashIdentity(ResourceIndexedSearchParamDate.calculateHashIdentity(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName));
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamDate)) {
            return false;
        }
        ResourceIndexedSearchParamDate obj = (ResourceIndexedSearchParamDate)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getHashIdentity(), (Object)obj.getHashIdentity());
        b.append((Object)this.getTimeFromDate(this.getValueHigh()), (Object)this.getTimeFromDate(obj.getValueHigh()));
        b.append((Object)this.getTimeFromDate(this.getValueLow()), (Object)this.getTimeFromDate(obj.getValueLow()));
        b.append((Object)this.getValueLowDateOrdinal(), (Object)obj.getValueLowDateOrdinal());
        b.append((Object)this.getValueHighDateOrdinal(), (Object)obj.getValueHighDateOrdinal());
        b.append(this.isMissing(), obj.isMissing());
        return b.isEquals();
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    protected Long getTimeFromDate(Date date) {
        if (date != null) {
            return date.getTime();
        }
        return null;
    }

    public Date getValueHigh() {
        return this.myValueHigh;
    }

    public ResourceIndexedSearchParamDate setValueHigh(Date theValueHigh) {
        this.myValueHigh = theValueHigh;
        return this;
    }

    public Date getValueLow() {
        return this.myValueLow;
    }

    public ResourceIndexedSearchParamDate setValueLow(Date theValueLow) {
        this.myValueLow = theValueLow;
        return this;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getHashIdentity());
        b.append((Object)this.getTimeFromDate(this.getValueHigh()));
        b.append((Object)this.getTimeFromDate(this.getValueLow()));
        b.append((Object)this.getValueHighDateOrdinal());
        b.append((Object)this.getValueLowDateOrdinal());
        b.append(this.isMissing());
        return b.toHashCode();
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        DateTimeType value = new DateTimeType(this.myOriginalValue);
        if (value.getPrecision().ordinal() > TemporalPrecisionEnum.DAY.ordinal()) {
            value.setTimeZoneZulu(true);
        }
        return new DateParam(value.getValueAsString());
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("partitionId", (Object)this.getPartitionId());
        b.append("paramName", (Object)this.getParamName());
        b.append("resourceId", (Object)this.getResourcePid());
        b.append("valueLow", (Object)new InstantDt(this.getValueLow()));
        b.append("valueHigh", (Object)new InstantDt(this.getValueHigh()));
        b.append("ordLow", (Object)this.myValueLowDateOrdinal);
        b.append("ordHigh", (Object)this.myValueHighDateOrdinal);
        b.append("hashIdentity", (Object)this.myHashIdentity);
        b.append("missing", this.isMissing());
        return b.build();
    }

    @Override
    public boolean matches(IQueryParameterType theParam) {
        if (!(theParam instanceof DateParam)) {
            return false;
        }
        DateParam dateParam = (DateParam)theParam;
        DateRangeParam range = new DateRangeParam(dateParam);
        boolean result = dateParam.getPrecision().ordinal() <= TemporalPrecisionEnum.DAY.ordinal() ? this.matchesOrdinalDateBounds(range) : this.matchesDateBounds(range);
        return result;
    }

    private boolean matchesDateBounds(DateRangeParam range) {
        Date lowerBound = range.getLowerBoundAsInstant();
        Date upperBound = range.getUpperBoundAsInstant();
        if (lowerBound == null && upperBound == null) {
            return false;
        }
        boolean result = true;
        if (lowerBound != null) {
            result &= this.myValueLow.after(lowerBound) || this.myValueLow.equals(lowerBound);
            result &= this.myValueHigh.after(lowerBound) || this.myValueHigh.equals(lowerBound);
        }
        if (upperBound != null) {
            result &= this.myValueLow.before(upperBound) || this.myValueLow.equals(upperBound);
            result &= this.myValueHigh.before(upperBound) || this.myValueHigh.equals(upperBound);
        }
        return result;
    }

    private boolean matchesOrdinalDateBounds(DateRangeParam range) {
        boolean result = true;
        Integer lowerBoundAsDateInteger = range.getLowerBoundAsDateInteger();
        Integer upperBoundAsDateInteger = range.getUpperBoundAsDateInteger();
        if (upperBoundAsDateInteger == null && lowerBoundAsDateInteger == null) {
            return false;
        }
        if (lowerBoundAsDateInteger != null) {
            result &= this.myValueLowDateOrdinal.equals(lowerBoundAsDateInteger) || this.myValueLowDateOrdinal > lowerBoundAsDateInteger;
            result &= this.myValueHighDateOrdinal.equals(lowerBoundAsDateInteger) || this.myValueHighDateOrdinal > lowerBoundAsDateInteger;
        }
        if (upperBoundAsDateInteger != null) {
            result &= this.myValueHighDateOrdinal.equals(upperBoundAsDateInteger) || this.myValueHighDateOrdinal < upperBoundAsDateInteger;
            result &= this.myValueLowDateOrdinal.equals(upperBoundAsDateInteger) || this.myValueLowDateOrdinal < upperBoundAsDateInteger;
        }
        return result;
    }

    public static Long calculateOrdinalValue(Date theDate) {
        if (theDate == null) {
            return null;
        }
        return DateUtils.convertDateToDayInteger((Date)theDate);
    }

    @Override
    public ResourceTable getResource() {
        return this.myResource;
    }

    @Override
    public BaseResourceIndexedSearchParam setResource(ResourceTable theResource) {
        this.myResource = theResource;
        this.setResourceType(theResource.getResourceType());
        return this;
    }
}

