/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.listener.IndexStorageOptimizationListener;
import ca.uhn.fhir.jpa.model.util.SearchParamHash;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.TokenParam;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;

@Embeddable
@EntityListeners(value={IndexStorageOptimizationListener.class})
@Entity
@Table(name="HFJ_SPIDX_TOKEN", indexes={@Index(name="IDX_SP_TOKEN_HASH_V2", columnList="HASH_IDENTITY,SP_SYSTEM,SP_VALUE,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_TOKEN_HASH_S_V2", columnList="HASH_SYS,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_TOKEN_HASH_SV_V2", columnList="HASH_SYS_AND_VALUE,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_TOKEN_HASH_V_V2", columnList="HASH_VALUE,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_TOKEN_RESID_V2", columnList="RES_ID,HASH_SYS_AND_VALUE,HASH_VALUE,HASH_SYS,HASH_IDENTITY,PARTITION_ID")})
public class ResourceIndexedSearchParamToken
extends BaseResourceIndexedSearchParam {
    public static final int MAX_LENGTH = 200;
    private static final long serialVersionUID = 1L;
    @FullTextField
    @Column(name="SP_SYSTEM", nullable=true, length=200)
    public String mySystem;
    @FullTextField
    @Column(name="SP_VALUE", nullable=true, length=200)
    private String myValue;
    @Id
    @SequenceGenerator(name="SEQ_SPIDX_TOKEN", sequenceName="SEQ_SPIDX_TOKEN")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_TOKEN")
    @Column(name="SP_ID")
    private Long myId;
    @Column(name="HASH_SYS", nullable=true)
    private Long myHashSystem;
    @Column(name="HASH_SYS_AND_VALUE", nullable=true)
    private Long myHashSystemAndValue;
    @Column(name="HASH_VALUE", nullable=true)
    private Long myHashValue;
    @ManyToOne(optional=false, fetch=FetchType.LAZY, cascade={})
    @JoinColumn(foreignKey=@ForeignKey(name="FK_SP_TOKEN_RES"), name="RES_ID", referencedColumnName="RES_ID", nullable=false)
    private ResourceTable myResource;

    public ResourceIndexedSearchParamToken() {
    }

    public ResourceIndexedSearchParamToken(PartitionSettings thePartitionSettings, String theResourceType, String theParamName, String theSystem, String theValue) {
        this.setPartitionSettings(thePartitionSettings);
        this.setResourceType(theResourceType);
        this.setParamName(theParamName);
        this.setSystem(theSystem);
        this.setValue(theValue);
        this.calculateHashes();
    }

    public ResourceIndexedSearchParamToken(PartitionSettings thePartitionSettings, String theResourceType, String theParamName, boolean theMissing) {
        this.setPartitionSettings(thePartitionSettings);
        this.setResourceType(theResourceType);
        this.setParamName(theParamName);
        this.setMissing(theMissing);
        this.calculateHashes();
    }

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        super.copyMutableValuesFrom(theSource);
        ResourceIndexedSearchParamToken source = (ResourceIndexedSearchParamToken)theSource;
        this.mySystem = source.mySystem;
        this.myValue = source.myValue;
        this.myHashSystem = source.myHashSystem;
        this.myHashSystemAndValue = source.getHashSystemAndValue();
        this.myHashValue = source.myHashValue;
        this.myHashIdentity = source.myHashIdentity;
    }

    @Override
    public void clearHashes() {
        this.myHashIdentity = null;
        this.myHashSystem = null;
        this.myHashSystemAndValue = null;
        this.myHashValue = null;
    }

    @Override
    public void calculateHashes() {
        boolean calculatePartialHashes;
        if (this.myHashIdentity != null || this.myHashSystem != null || this.myHashValue != null || this.myHashSystemAndValue != null) {
            return;
        }
        String resourceType = this.getResourceType();
        String paramName = this.getParamName();
        String system = this.getSystem();
        String value = this.getValue();
        this.setHashIdentity(ResourceIndexedSearchParamToken.calculateHashIdentity(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName));
        this.setHashSystemAndValue(ResourceIndexedSearchParamToken.calculateHashSystemAndValue(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName, system, value));
        boolean bl = calculatePartialHashes = !StringUtils.endsWith((CharSequence)paramName, (CharSequence)":of-type");
        if (calculatePartialHashes) {
            this.setHashSystem(ResourceIndexedSearchParamToken.calculateHashSystem(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName, system));
            this.setHashValue(ResourceIndexedSearchParamToken.calculateHashValue(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName, value));
        }
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamToken)) {
            return false;
        }
        ResourceIndexedSearchParamToken obj = (ResourceIndexedSearchParamToken)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getHashIdentity(), (Object)obj.getHashIdentity());
        b.append((Object)this.getHashSystem(), (Object)obj.getHashSystem());
        b.append((Object)this.getHashValue(), (Object)obj.getHashValue());
        b.append((Object)this.getHashSystemAndValue(), (Object)obj.getHashSystemAndValue());
        b.append(this.isMissing(), obj.isMissing());
        return b.isEquals();
    }

    public Long getHashSystem() {
        return this.myHashSystem;
    }

    private void setHashSystem(Long theHashSystem) {
        this.myHashSystem = theHashSystem;
    }

    public Long getHashSystemAndValue() {
        return this.myHashSystemAndValue;
    }

    private void setHashSystemAndValue(Long theHashSystemAndValue) {
        this.myHashSystemAndValue = theHashSystemAndValue;
    }

    public Long getHashValue() {
        return this.myHashValue;
    }

    private void setHashValue(Long theHashValue) {
        this.myHashValue = theHashValue;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public void setSystem(String theSystem) {
        this.mySystem = (String)StringUtils.defaultIfBlank((CharSequence)theSystem, null);
        this.myHashSystemAndValue = null;
    }

    public String getValue() {
        return this.myValue;
    }

    public ResourceIndexedSearchParamToken setValue(String theValue) {
        this.myValue = (String)StringUtils.defaultIfBlank((CharSequence)theValue, null);
        this.myHashSystemAndValue = null;
        return this;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getHashIdentity());
        b.append((Object)this.getHashValue());
        b.append((Object)this.getHashSystem());
        b.append((Object)this.getHashSystemAndValue());
        b.append(this.isMissing());
        return b.toHashCode();
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        return new TokenParam(this.getSystem(), this.getValue());
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("id", (Object)this.getId());
        if (this.getPartitionId() != null) {
            b.append("partitionId", (Object)this.getPartitionId().getPartitionId());
        }
        b.append("resourceType", (Object)this.getResourceType());
        b.append("paramName", (Object)this.getParamName());
        if (this.isMissing()) {
            b.append("missing", true);
        } else {
            b.append("system", (Object)this.getSystem());
            b.append("value", (Object)this.getValue());
        }
        b.append("hashIdentity", (Object)this.myHashIdentity);
        b.append("hashSystem", (Object)this.myHashSystem);
        b.append("hashValue", (Object)this.myHashValue);
        b.append("hashSysAndValue", (Object)this.myHashSystemAndValue);
        b.append("partition", (Object)this.getPartitionId());
        return b.build();
    }

    @Override
    public boolean matches(IQueryParameterType theParam) {
        if (!(theParam instanceof TokenParam)) {
            return false;
        }
        TokenParam token = (TokenParam)theParam;
        boolean retVal = false;
        String valueString = StringUtils.defaultString((String)this.getValue());
        String tokenValueString = StringUtils.defaultString((String)token.getValue());
        if (token.getSystem() == null || token.getSystem().isEmpty()) {
            if (valueString.equalsIgnoreCase(tokenValueString)) {
                retVal = true;
            }
        } else if (tokenValueString == null || tokenValueString.isEmpty()) {
            if (token.getSystem().equalsIgnoreCase(this.getSystem())) {
                retVal = true;
            }
        } else if (token.getSystem().equalsIgnoreCase(this.getSystem()) && valueString.equalsIgnoreCase(tokenValueString)) {
            retVal = true;
        }
        return retVal;
    }

    public static long calculateHashSystem(PartitionSettings thePartitionSettings, PartitionablePartitionId theRequestPartitionId, String theResourceType, String theParamName, String theSystem) {
        RequestPartitionId requestPartitionId = PartitionablePartitionId.toRequestPartitionId(theRequestPartitionId);
        return ResourceIndexedSearchParamToken.calculateHashSystem(thePartitionSettings, requestPartitionId, theResourceType, theParamName, theSystem);
    }

    public static long calculateHashSystem(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName, String theSystem) {
        return SearchParamHash.hashSearchParam(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName, StringUtils.trim((String)theSystem));
    }

    public static long calculateHashSystemAndValue(PartitionSettings thePartitionSettings, PartitionablePartitionId theRequestPartitionId, String theResourceType, String theParamName, String theSystem, String theValue) {
        RequestPartitionId requestPartitionId = PartitionablePartitionId.toRequestPartitionId(theRequestPartitionId);
        return ResourceIndexedSearchParamToken.calculateHashSystemAndValue(thePartitionSettings, requestPartitionId, theResourceType, theParamName, theSystem, theValue);
    }

    public static long calculateHashSystemAndValue(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName, String theSystem, String theValue) {
        return SearchParamHash.hashSearchParam(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName, StringUtils.defaultString((String)StringUtils.trim((String)theSystem)), StringUtils.trim((String)theValue));
    }

    public static long calculateHashValue(PartitionSettings thePartitionSettings, PartitionablePartitionId theRequestPartitionId, String theResourceType, String theParamName, String theValue) {
        RequestPartitionId requestPartitionId = PartitionablePartitionId.toRequestPartitionId(theRequestPartitionId);
        return ResourceIndexedSearchParamToken.calculateHashValue(thePartitionSettings, requestPartitionId, theResourceType, theParamName, theValue);
    }

    public static long calculateHashValue(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName, String theValue) {
        String value = StringUtils.trim((String)theValue);
        return SearchParamHash.hashSearchParam(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName, value);
    }

    @Override
    public ResourceTable getResource() {
        return this.myResource;
    }

    @Override
    public BaseResourceIndexedSearchParam setResource(ResourceTable theResource) {
        this.myResource = theResource;
        this.setResourceType(theResource.getResourceType());
        return this;
    }

    @PrePersist
    @PreUpdate
    public void truncateFieldsForDB() {
        this.mySystem = StringUtils.truncate((String)this.mySystem, (int)200);
        this.myValue = StringUtils.truncate((String)this.myValue, (int)200);
    }
}

