/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

@Embeddable
public class ResourceSearchUrlEntityPK
implements Serializable {
    public static final String RES_SEARCH_URL_COLUMN_NAME = "RES_SEARCH_URL";
    public static final String PARTITION_ID_COLUMN_NAME = "PARTITION_ID";
    public static final int RES_SEARCH_URL_LENGTH = 768;
    private static final long serialVersionUID = 1L;
    private static final int PARTITION_ID_NULL_EQUIVALENT = -1;
    @Column(name="RES_SEARCH_URL", length=768, nullable=false)
    private String my_A_SearchUrl;
    @Column(name="PARTITION_ID", nullable=false, insertable=true, updatable=false)
    private Integer my_B_PartitionId;

    public ResourceSearchUrlEntityPK() {
    }

    public static ResourceSearchUrlEntityPK from(String theSearchUrl, ResourceTable theResourceTable, boolean theSearchUrlDuplicateAcrossPartitionsEnabled) {
        return new ResourceSearchUrlEntityPK(theSearchUrl, ResourceSearchUrlEntityPK.computePartitionIdOrNullEquivalent(theResourceTable, theSearchUrlDuplicateAcrossPartitionsEnabled));
    }

    public ResourceSearchUrlEntityPK(String theSearchUrl, int thePartitionId) {
        this.my_A_SearchUrl = theSearchUrl;
        this.my_B_PartitionId = thePartitionId;
    }

    public String getSearchUrl() {
        return this.my_A_SearchUrl;
    }

    public void setSearchUrl(String theMy_A_SearchUrl) {
        this.my_A_SearchUrl = theMy_A_SearchUrl;
    }

    public Integer getPartitionId() {
        return this.my_B_PartitionId;
    }

    public void setPartitionId(Integer theMy_B_PartitionId) {
        this.my_B_PartitionId = theMy_B_PartitionId;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        ResourceSearchUrlEntityPK that = (ResourceSearchUrlEntityPK)theO;
        return Objects.equals(this.my_A_SearchUrl, that.my_A_SearchUrl) && Objects.equals(this.my_B_PartitionId, that.my_B_PartitionId);
    }

    public int hashCode() {
        return Objects.hash(this.my_A_SearchUrl, this.my_B_PartitionId);
    }

    public String toString() {
        return new StringJoiner(", ", ResourceSearchUrlEntityPK.class.getSimpleName() + "[", "]").add("my_A_SearchUrl='" + this.my_A_SearchUrl + "'").add("my_B_PartitionId=" + this.my_B_PartitionId).toString();
    }

    private static int computePartitionIdOrNullEquivalent(ResourceTable theTheResourceTable, boolean theTheSearchUrlDuplicateAcrossPartitionsEnabled) {
        if (!theTheSearchUrlDuplicateAcrossPartitionsEnabled) {
            return -1;
        }
        return Optional.ofNullable(theTheResourceTable.getPartitionId()).map(PartitionablePartitionId::getPartitionId).orElse(-1);
    }
}

