/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.search;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.search.CompositeSearchIndexData;
import ca.uhn.fhir.jpa.model.search.DateSearchIndexData;
import ca.uhn.fhir.jpa.model.search.HSearchIndexWriter;
import ca.uhn.fhir.jpa.model.search.QuantitySearchIndexData;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedHSearchIndexData {
    private static final Logger ourLog = LoggerFactory.getLogger(ExtendedHSearchIndexData.class);
    final FhirContext myFhirContext;
    final StorageSettings myStorageSettings;
    final SetMultimap<String, String> mySearchParamStrings = HashMultimap.create();
    final SetMultimap<String, IBaseCoding> mySearchParamTokens = HashMultimap.create();
    final SetMultimap<String, BigDecimal> mySearchParamNumbers = HashMultimap.create();
    final SetMultimap<String, String> mySearchParamLinks = HashMultimap.create();
    final SetMultimap<String, String> mySearchParamUri = HashMultimap.create();
    final SetMultimap<String, DateSearchIndexData> mySearchParamDates = HashMultimap.create();
    final SetMultimap<String, QuantitySearchIndexData> mySearchParamQuantities = HashMultimap.create();
    final SetMultimap<String, CompositeSearchIndexData> mySearchParamComposites = HashMultimap.create();
    private String myForcedId;
    private String myResourceJSON;
    private IBaseResource myResource;

    public ExtendedHSearchIndexData(FhirContext theFhirContext, StorageSettings theStorageSettings, IBaseResource theResource) {
        this.myFhirContext = theFhirContext;
        this.myStorageSettings = theStorageSettings;
        this.myResource = theResource;
    }

    private <V> BiConsumer<String, V> ifNotContained(BiConsumer<String, V> theIndexWriter) {
        return (s, v) -> {
            if (!s.contains(".")) {
                theIndexWriter.accept((String)s, (Object)v);
            }
        };
    }

    public void writeIndexElements(DocumentElement theDocument) {
        HSearchIndexWriter indexWriter = HSearchIndexWriter.forRoot(this.myStorageSettings, theDocument);
        ourLog.debug("Writing JPA index to Hibernate Search");
        theDocument.addValue("myForcedId", (Object)this.myForcedId);
        if (this.myResourceJSON != null) {
            theDocument.addValue("myRawResource", (Object)this.myResourceJSON);
        }
        this.mySearchParamStrings.forEach(this.ifNotContained(indexWriter::writeStringIndex));
        this.mySearchParamTokens.forEach(this.ifNotContained(indexWriter::writeTokenIndex));
        this.mySearchParamLinks.forEach(this.ifNotContained(indexWriter::writeReferenceIndex));
        this.mySearchParamQuantities.forEach(this.ifNotContained(indexWriter::writeQuantityIndex));
        Multimaps.asMap(this.mySearchParamNumbers).forEach(this.ifNotContained(indexWriter::writeNumberIndex));
        this.mySearchParamDates.forEach(this.ifNotContained(indexWriter::writeDateIndex));
        Multimaps.asMap(this.mySearchParamUri).forEach(this.ifNotContained(indexWriter::writeUriIndex));
        Multimaps.asMap(this.mySearchParamComposites).forEach(indexWriter::writeCompositeIndex);
    }

    public void addStringIndexData(String theSpName, String theText) {
        this.mySearchParamStrings.put((Object)theSpName, (Object)theText);
    }

    public void addTokenIndexDataIfNotPresent(String theSpName, String theSystem, String theValue) {
        boolean isPresent = this.mySearchParamTokens.get((Object)theSpName).stream().anyMatch(c -> Objects.equals(c.getSystem(), theSystem) && Objects.equals(c.getCode(), theValue));
        if (!isPresent) {
            this.addTokenIndexData(theSpName, (IBaseCoding)new CodingDt(theSystem, theValue));
        }
    }

    public void addTokenIndexData(String theSpName, IBaseCoding theNextValue) {
        this.mySearchParamTokens.put((Object)theSpName, (Object)theNextValue);
    }

    public void addUriIndexData(String theSpName, String theValue) {
        this.mySearchParamUri.put((Object)theSpName, (Object)theValue);
    }

    public void addResourceLinkIndexData(String theSpName, String theTargetResourceId) {
        this.mySearchParamLinks.put((Object)theSpName, (Object)theTargetResourceId);
    }

    public void addDateIndexData(String theSpName, Date theLowerBound, int theLowerBoundOrdinal, Date theUpperBound, int theUpperBoundOrdinal) {
        this.addDateIndexData(theSpName, new DateSearchIndexData(theLowerBound, theLowerBoundOrdinal, theUpperBound, theUpperBoundOrdinal));
    }

    public void addDateIndexData(String theSpName, DateSearchIndexData value) {
        this.mySearchParamDates.put((Object)theSpName, (Object)value);
    }

    public SetMultimap<String, DateSearchIndexData> getDateIndexData() {
        return this.mySearchParamDates;
    }

    public void addNumberIndexDataIfNotPresent(String theParamName, BigDecimal theValue) {
        this.mySearchParamNumbers.put((Object)theParamName, (Object)theValue);
    }

    public void addQuantityIndexData(String theSpName, QuantitySearchIndexData value) {
        this.mySearchParamQuantities.put((Object)theSpName, (Object)value);
    }

    public SetMultimap<String, QuantitySearchIndexData> getQuantityIndexData() {
        return this.mySearchParamQuantities;
    }

    public void setForcedId(String theForcedId) {
        this.myForcedId = theForcedId;
    }

    public String getForcedId() {
        return this.myForcedId;
    }

    public void setRawResourceData(String theResourceJSON) {
        this.myResourceJSON = theResourceJSON;
    }

    public SetMultimap<String, CompositeSearchIndexData> getSearchParamComposites() {
        return this.mySearchParamComposites;
    }

    public void addCompositeIndexData(String theSearchParamName, CompositeSearchIndexData theBuildCompositeIndexData) {
        this.mySearchParamComposites.put((Object)theSearchParamName, (Object)theBuildCompositeIndexData);
    }
}

