/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.empi.api.EmpiLinkSourceEnum;
import ca.uhn.fhir.empi.api.EmpiMatchResultEnum;
import ca.uhn.fhir.empi.model.EmpiTransactionContext;
import ca.uhn.fhir.empi.util.EmpiUtil;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.TransactionLogMessages;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.validation.IResourceLoader;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class BaseEmpiProvider {
    protected final FhirContext myFhirContext;
    private final IResourceLoader myResourceLoader;

    public BaseEmpiProvider(FhirContext theFhirContext, IResourceLoader theResourceLoader) {
        this.myFhirContext = theFhirContext;
        this.myResourceLoader = theResourceLoader;
    }

    protected IAnyResource getLatestPersonFromIdOrThrowException(String theParamName, String theId) {
        IdDt personId = this.getPersonIdDtOrThrowException(theParamName, theId);
        return this.loadResource((IIdType)personId.toUnqualifiedVersionless());
    }

    private IdDt getPersonIdDtOrThrowException(String theParamName, String theId) {
        IdDt personId = new IdDt(theId);
        if (!"Person".equals(personId.getResourceType()) || personId.getIdPart() == null) {
            throw new InvalidRequestException(theParamName + " must have form Person/<id> where <id> is the id of the person");
        }
        return personId;
    }

    protected IAnyResource getLatestTargetFromIdOrThrowException(String theParamName, String theId) {
        IIdType targetId = this.getTargetIdDtOrThrowException(theParamName, theId);
        return this.loadResource(targetId.toUnqualifiedVersionless());
    }

    protected IIdType getTargetIdDtOrThrowException(String theParamName, String theId) {
        IdDt targetId = new IdDt(theId);
        String resourceType = targetId.getResourceType();
        if (!EmpiUtil.supportedTargetType(resourceType) || targetId.getIdPart() == null) {
            throw new InvalidRequestException(theParamName + " must have form Patient/<id> or Practitioner/<id> where <id> is the id of the resource");
        }
        return targetId;
    }

    protected IAnyResource loadResource(IIdType theResourceId) {
        Class resourceClass = this.myFhirContext.getResourceDefinition(theResourceId.getResourceType()).getImplementingClass();
        return (IAnyResource)this.myResourceLoader.load(resourceClass, theResourceId);
    }

    protected void validateMergeParameters(IPrimitiveType<String> theFromPersonId, IPrimitiveType<String> theToPersonId) {
        this.validateNotNull("fromPersonId", theFromPersonId);
        this.validateNotNull("toPersonId", theToPersonId);
        if (((String)theFromPersonId.getValue()).equals(theToPersonId.getValue())) {
            throw new InvalidRequestException("fromPersonId must be different from toPersonId");
        }
    }

    protected void validateMergeResources(IAnyResource theFromPerson, IAnyResource theToPerson) {
        this.validateIsEmpiManaged("fromPersonId", theFromPerson);
        this.validateIsEmpiManaged("toPersonId", theToPerson);
    }

    private void validateIsEmpiManaged(String theName, IAnyResource thePerson) {
        if (!"Person".equals(this.myFhirContext.getResourceType((IBaseResource)thePerson))) {
            throw new InvalidRequestException("Only Person resources can be merged.  The " + theName + " points to a " + this.myFhirContext.getResourceType((IBaseResource)thePerson));
        }
        if (!EmpiUtil.isEmpiManaged((IBaseResource)thePerson)) {
            throw new InvalidRequestException("Only EMPI managed resources can be merged.  Empi managed resource have the HAPI-EMPI tag.");
        }
    }

    private void validateNotNull(String theName, IPrimitiveType<String> theString) {
        if (theString == null || theString.getValue() == null) {
            throw new InvalidRequestException(theName + " cannot be null");
        }
    }

    protected void validateUpdateLinkParameters(IPrimitiveType<String> thePersonId, IPrimitiveType<String> theTargetId, IPrimitiveType<String> theMatchResult) {
        this.validateNotNull("personId", thePersonId);
        this.validateNotNull("targetId", theTargetId);
        this.validateNotNull("matchResult", theMatchResult);
        EmpiMatchResultEnum matchResult = EmpiMatchResultEnum.valueOf((String)theMatchResult.getValue());
        switch (matchResult) {
            case NO_MATCH: 
            case MATCH: {
                break;
            }
            default: {
                throw new InvalidRequestException("$empi-update-link illegal matchResult value '" + (Object)((Object)matchResult) + "'.  Must be " + (Object)((Object)EmpiMatchResultEnum.NO_MATCH) + " or " + (Object)((Object)EmpiMatchResultEnum.MATCH));
            }
        }
    }

    protected void validateNotDuplicateParameters(IPrimitiveType<String> thePersonId, IPrimitiveType<String> theTargetId) {
        this.validateNotNull("personId", thePersonId);
        this.validateNotNull("targetId", theTargetId);
    }

    protected EmpiTransactionContext createEmpiContext(RequestDetails theRequestDetails) {
        TransactionLogMessages transactionLogMessages = TransactionLogMessages.createFromTransactionGuid(theRequestDetails.getTransactionGuid());
        return new EmpiTransactionContext(transactionLogMessages, EmpiTransactionContext.OperationType.MERGE_PERSONS);
    }

    protected EmpiMatchResultEnum extractMatchResultOrNull(IPrimitiveType<String> theMatchResult) {
        String matchResult = this.extractStringNull(theMatchResult);
        if (matchResult == null) {
            return null;
        }
        return EmpiMatchResultEnum.valueOf(matchResult);
    }

    protected EmpiLinkSourceEnum extractLinkSourceOrNull(IPrimitiveType<String> theLinkSource) {
        String linkSource = this.extractStringNull(theLinkSource);
        if (linkSource == null) {
            return null;
        }
        return EmpiLinkSourceEnum.valueOf(linkSource);
    }

    private String extractStringNull(IPrimitiveType<String> theString) {
        if (theString == null) {
            return null;
        }
        return (String)theString.getValue();
    }

    protected IIdType extractPersonIdDtOrNull(String theName, IPrimitiveType<String> thePersonId) {
        String personId = this.extractStringNull(thePersonId);
        if (personId == null) {
            return null;
        }
        return this.getPersonIdDtOrThrowException(theName, personId);
    }

    protected IIdType extractTargetIdDtOrNull(String theName, IPrimitiveType<String> theTargetId) {
        String targetId = this.extractStringNull(theTargetId);
        if (targetId == null) {
            return null;
        }
        return this.getTargetIdDtOrThrowException(theName, targetId);
    }

    protected void validateSameVersion(IAnyResource theResource, IPrimitiveType<String> theResourceId) {
        String storedId = theResource.getIdElement().getValue();
        String requestedId = (String)theResourceId.getValue();
        if (this.hasVersionIdPart(requestedId) && !storedId.equals(requestedId)) {
            throw new ResourceVersionConflictException("Requested resource " + requestedId + " is not the latest version.  Latest version is " + storedId);
        }
    }

    private boolean hasVersionIdPart(String theId) {
        return new IdDt(theId).hasVersionIdPart();
    }
}

