/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.provider;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.empi.api.IEmpiBatchSvc;
import ca.uhn.fhir.empi.api.IEmpiLinkQuerySvc;
import ca.uhn.fhir.empi.api.IEmpiLinkUpdaterSvc;
import ca.uhn.fhir.empi.api.IEmpiMatchFinderSvc;
import ca.uhn.fhir.empi.api.IEmpiPersonMergerSvc;
import ca.uhn.fhir.empi.api.IEmpiResetSvc;
import ca.uhn.fhir.empi.provider.EmpiProviderDstu3;
import ca.uhn.fhir.empi.provider.EmpiProviderR4;
import ca.uhn.fhir.rest.server.provider.ResourceProviderFactory;
import ca.uhn.fhir.validation.IResourceLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmpiProviderLoader {
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private ResourceProviderFactory myResourceProviderFactory;
    @Autowired
    private IEmpiMatchFinderSvc myEmpiMatchFinderSvc;
    @Autowired
    private IEmpiPersonMergerSvc myPersonMergerSvc;
    @Autowired
    private IEmpiLinkUpdaterSvc myEmpiLinkUpdaterSvc;
    @Autowired
    private IEmpiLinkQuerySvc myEmpiLinkQuerySvc;
    @Autowired
    private IResourceLoader myResourceLoader;
    @Autowired
    private IEmpiResetSvc myEmpiResetSvc;
    @Autowired
    private IEmpiBatchSvc myEmpiBatchSvc;

    public void loadProvider() {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case DSTU3: {
                this.myResourceProviderFactory.addSupplier(() -> new EmpiProviderDstu3(this.myFhirContext, this.myEmpiMatchFinderSvc, this.myPersonMergerSvc, this.myEmpiLinkUpdaterSvc, this.myEmpiLinkQuerySvc, this.myResourceLoader, this.myEmpiResetSvc, this.myEmpiBatchSvc));
                break;
            }
            case R4: {
                this.myResourceProviderFactory.addSupplier(() -> new EmpiProviderR4(this.myFhirContext, this.myEmpiMatchFinderSvc, this.myPersonMergerSvc, this.myEmpiLinkUpdaterSvc, this.myEmpiLinkQuerySvc, this.myResourceLoader, this.myEmpiResetSvc, this.myEmpiBatchSvc));
                break;
            }
            default: {
                throw new ConfigurationException("EMPI not supported for FHIR version " + this.myFhirContext.getVersion().getVersion());
            }
        }
    }
}

