/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.empi.api.EmpiLinkSourceEnum;
import ca.uhn.fhir.empi.api.EmpiMatchResultEnum;
import ca.uhn.fhir.empi.api.IEmpiBatchSvc;
import ca.uhn.fhir.empi.api.IEmpiLinkQuerySvc;
import ca.uhn.fhir.empi.api.IEmpiLinkUpdaterSvc;
import ca.uhn.fhir.empi.api.IEmpiMatchFinderSvc;
import ca.uhn.fhir.empi.api.IEmpiPersonMergerSvc;
import ca.uhn.fhir.empi.api.IEmpiResetSvc;
import ca.uhn.fhir.empi.provider.BaseEmpiProvider;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.validation.IResourceLoader;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Person;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public class EmpiProviderR4
extends BaseEmpiProvider {
    private final IEmpiMatchFinderSvc myEmpiMatchFinderSvc;
    private final IEmpiPersonMergerSvc myPersonMergerSvc;
    private final IEmpiLinkUpdaterSvc myEmpiLinkUpdaterSvc;
    private final IEmpiLinkQuerySvc myEmpiLinkQuerySvc;
    private final IEmpiResetSvc myEmpiExpungeSvc;
    private final IEmpiBatchSvc myEmpiBatchSvc;

    public EmpiProviderR4(FhirContext theFhirContext, IEmpiMatchFinderSvc theEmpiMatchFinderSvc, IEmpiPersonMergerSvc thePersonMergerSvc, IEmpiLinkUpdaterSvc theEmpiLinkUpdaterSvc, IEmpiLinkQuerySvc theEmpiLinkQuerySvc, IResourceLoader theResourceLoader, IEmpiResetSvc theEmpiExpungeSvc, IEmpiBatchSvc theEmpiBatchSvc) {
        super(theFhirContext, theResourceLoader);
        this.myEmpiMatchFinderSvc = theEmpiMatchFinderSvc;
        this.myPersonMergerSvc = thePersonMergerSvc;
        this.myEmpiLinkUpdaterSvc = theEmpiLinkUpdaterSvc;
        this.myEmpiLinkQuerySvc = theEmpiLinkQuerySvc;
        this.myEmpiExpungeSvc = theEmpiExpungeSvc;
        this.myEmpiBatchSvc = theEmpiBatchSvc;
    }

    @Operation(name="$match", type=Patient.class)
    public Bundle match(@OperationParam(name="resource", min=1, max=1) Patient thePatient) {
        if (thePatient == null) {
            throw new InvalidRequestException("resource may not be null");
        }
        List<IAnyResource> matches = this.myEmpiMatchFinderSvc.findMatches("Patient", (IAnyResource)thePatient);
        Bundle retVal = new Bundle();
        retVal.setType(Bundle.BundleType.SEARCHSET);
        retVal.setId(UUID.randomUUID().toString());
        retVal.getMeta().setLastUpdatedElement(InstantType.now());
        for (IAnyResource next : matches) {
            retVal.addEntry().setResource((Resource)next);
        }
        return retVal;
    }

    @Operation(name="$empi-merge-persons", type=Person.class)
    public Person mergePersons(@OperationParam(name="fromPersonId", min=1, max=1) StringType theFromPersonId, @OperationParam(name="toPersonId", min=1, max=1) StringType theToPersonId, RequestDetails theRequestDetails) {
        this.validateMergeParameters((IPrimitiveType<String>)theFromPersonId, (IPrimitiveType<String>)theToPersonId);
        IAnyResource fromPerson = this.getLatestPersonFromIdOrThrowException("fromPersonId", (String)theFromPersonId.getValue());
        IAnyResource toPerson = this.getLatestPersonFromIdOrThrowException("toPersonId", (String)theToPersonId.getValue());
        this.validateMergeResources(fromPerson, toPerson);
        this.validateSameVersion(fromPerson, (IPrimitiveType<String>)theFromPersonId);
        this.validateSameVersion(toPerson, (IPrimitiveType<String>)theToPersonId);
        return (Person)this.myPersonMergerSvc.mergePersons(fromPerson, toPerson, this.createEmpiContext(theRequestDetails));
    }

    @Operation(name="$empi-update-link", type=Person.class)
    public Person updateLink(@OperationParam(name="personId", min=1, max=1) StringType thePersonId, @OperationParam(name="targetId", min=1, max=1) StringType theTargetId, @OperationParam(name="matchResult", min=1, max=1) StringType theMatchResult, ServletRequestDetails theRequestDetails) {
        this.validateUpdateLinkParameters((IPrimitiveType<String>)thePersonId, (IPrimitiveType<String>)theTargetId, (IPrimitiveType<String>)theMatchResult);
        EmpiMatchResultEnum matchResult = this.extractMatchResultOrNull((IPrimitiveType<String>)theMatchResult);
        IAnyResource person = this.getLatestPersonFromIdOrThrowException("personId", (String)thePersonId.getValue());
        IAnyResource target = this.getLatestTargetFromIdOrThrowException("targetId", (String)theTargetId.getValue());
        this.validateSameVersion(person, (IPrimitiveType<String>)thePersonId);
        this.validateSameVersion(target, (IPrimitiveType<String>)theTargetId);
        return (Person)this.myEmpiLinkUpdaterSvc.updateLink(person, target, matchResult, this.createEmpiContext((RequestDetails)theRequestDetails));
    }

    @Operation(name="$empi-clear", returnParameters={@OperationParam(name="submitted", type=DecimalType.class)})
    public Parameters clearEmpiLinks(@OperationParam(name="targetType", min=0, max=1) StringType theTargetType) {
        long resetCount = theTargetType == null || StringUtils.isBlank((CharSequence)((CharSequence)theTargetType.getValue())) ? this.myEmpiExpungeSvc.removeAllEmpiLinks() : this.myEmpiExpungeSvc.expungeAllEmpiLinksOfTargetType(theTargetType.getValueNotNull());
        Parameters parameters = new Parameters();
        parameters.addParameter().setName("deleted").setValue((Type)new DecimalType(resetCount));
        return parameters;
    }

    @Operation(name="$empi-query-links", idempotent=true)
    public Parameters queryLinks(@OperationParam(name="personId", min=0, max=1) StringType thePersonId, @OperationParam(name="targetId", min=0, max=1) StringType theTargetId, @OperationParam(name="matchResult", min=0, max=1) StringType theMatchResult, @OperationParam(name="linkSource", min=0, max=1) StringType theLinkSource, ServletRequestDetails theRequestDetails) {
        IIdType personId = this.extractPersonIdDtOrNull("personId", (IPrimitiveType<String>)thePersonId);
        IIdType targetId = this.extractTargetIdDtOrNull("targetId", (IPrimitiveType<String>)theTargetId);
        EmpiMatchResultEnum matchResult = this.extractMatchResultOrNull((IPrimitiveType<String>)theMatchResult);
        EmpiLinkSourceEnum linkSource = this.extractLinkSourceOrNull((IPrimitiveType<String>)theLinkSource);
        return (Parameters)this.myEmpiLinkQuerySvc.queryLinks(personId, targetId, matchResult, linkSource, this.createEmpiContext((RequestDetails)theRequestDetails));
    }

    @Operation(name="$empi-duplicate-persons", idempotent=true)
    public Parameters getDuplicatePersons(ServletRequestDetails theRequestDetails) {
        return (Parameters)this.myEmpiLinkQuerySvc.getPossibleDuplicates(this.createEmpiContext((RequestDetails)theRequestDetails));
    }

    @Operation(name="$empi-not-duplicate")
    public Parameters notDuplicate(@OperationParam(name="personId", min=1, max=1) StringType thePersonId, @OperationParam(name="targetId", min=1, max=1) StringType theTargetId, ServletRequestDetails theRequestDetails) {
        this.validateNotDuplicateParameters((IPrimitiveType<String>)thePersonId, (IPrimitiveType<String>)theTargetId);
        IAnyResource person = this.getLatestPersonFromIdOrThrowException("personId", (String)thePersonId.getValue());
        IAnyResource target = this.getLatestPersonFromIdOrThrowException("targetId", (String)theTargetId.getValue());
        this.validateSameVersion(person, (IPrimitiveType<String>)thePersonId);
        this.validateSameVersion(target, (IPrimitiveType<String>)theTargetId);
        return (Parameters)this.myEmpiLinkUpdaterSvc.notDuplicatePerson(person, target, this.createEmpiContext((RequestDetails)theRequestDetails));
    }

    @Operation(name="$empi-submit", idempotent=false, returnParameters={@OperationParam(name="submitted", type=IntegerType.class)})
    public Parameters empiBatchOnAllTargets(@OperationParam(name="criteria", min=0, max=1) StringType theCriteria, ServletRequestDetails theRequestDetails) {
        String criteria = this.convertCriteriaToString(theCriteria);
        long submittedCount = this.myEmpiBatchSvc.runEmpiOnAllTargetTypes(criteria);
        return this.buildEmpiOutParametersWithCount(submittedCount);
    }

    private String convertCriteriaToString(StringType theCriteria) {
        return theCriteria == null ? null : theCriteria.getValueAsString();
    }

    @Operation(name="$empi-submit", idempotent=false, type=Patient.class, returnParameters={@OperationParam(name="submitted", type=IntegerType.class)})
    public Parameters empiBatchPatientInstance(@IdParam IIdType theIdParam, RequestDetails theRequest) {
        long submittedCount = this.myEmpiBatchSvc.runEmpiOnTarget(theIdParam);
        return this.buildEmpiOutParametersWithCount(submittedCount);
    }

    @Operation(name="$empi-submit", idempotent=false, type=Patient.class, returnParameters={@OperationParam(name="submitted", type=IntegerType.class)})
    public Parameters empiBatchPatientType(@OperationParam(name="criteria") StringType theCriteria, RequestDetails theRequest) {
        String criteria = this.convertCriteriaToString(theCriteria);
        long submittedCount = this.myEmpiBatchSvc.runEmpiOnPatientType(criteria);
        return this.buildEmpiOutParametersWithCount(submittedCount);
    }

    @Operation(name="$empi-submit", idempotent=false, type=Practitioner.class, returnParameters={@OperationParam(name="submitted", type=IntegerType.class)})
    public Parameters empiBatchPractitionerInstance(@IdParam IIdType theIdParam, RequestDetails theRequest) {
        long submittedCount = this.myEmpiBatchSvc.runEmpiOnTarget(theIdParam);
        return this.buildEmpiOutParametersWithCount(submittedCount);
    }

    @Operation(name="$empi-submit", idempotent=false, type=Practitioner.class, returnParameters={@OperationParam(name="submitted", type=IntegerType.class)})
    public Parameters empiBatchPractitionerType(@OperationParam(name="criteria") StringType theCriteria, RequestDetails theRequest) {
        String criteria = this.convertCriteriaToString(theCriteria);
        long submittedCount = this.myEmpiBatchSvc.runEmpiOnPractitionerType(criteria);
        return this.buildEmpiOutParametersWithCount(submittedCount);
    }

    private Parameters buildEmpiOutParametersWithCount(long theCount) {
        Parameters parameters = new Parameters();
        parameters.addParameter().setName("submitted").setValue((Type)new DecimalType(theCount));
        return parameters;
    }
}

