/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.rules.config;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.empi.api.IEmpiRuleValidator;
import ca.uhn.fhir.empi.rules.json.EmpiFieldMatchJson;
import ca.uhn.fhir.empi.rules.json.EmpiFilterSearchParamJson;
import ca.uhn.fhir.empi.rules.json.EmpiResourceSearchParamJson;
import ca.uhn.fhir.empi.rules.json.EmpiRulesJson;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.server.util.ISearchParamRetriever;
import ca.uhn.fhir.util.FhirTerser;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmpiRuleValidator
implements IEmpiRuleValidator {
    private static final Logger ourLog = LoggerFactory.getLogger(EmpiRuleValidator.class);
    private final FhirContext myFhirContext;
    private final ISearchParamRetriever mySearchParamRetriever;
    private final Class<? extends IBaseResource> myPatientClass;
    private final Class<? extends IBaseResource> myPractitionerClass;
    private final FhirTerser myTerser;

    @Autowired
    public EmpiRuleValidator(FhirContext theFhirContext, ISearchParamRetriever theSearchParamRetriever) {
        this.myFhirContext = theFhirContext;
        this.myPatientClass = theFhirContext.getResourceDefinition("Patient").getImplementingClass();
        this.myPractitionerClass = theFhirContext.getResourceDefinition("Practitioner").getImplementingClass();
        this.myTerser = this.myFhirContext.newTerser();
        this.mySearchParamRetriever = theSearchParamRetriever;
    }

    @Override
    public void validate(EmpiRulesJson theEmpiRulesJson) {
        this.validateSearchParams(theEmpiRulesJson);
        this.validateMatchFields(theEmpiRulesJson);
        this.validateSystemIsUri(theEmpiRulesJson);
    }

    private void validateSearchParams(EmpiRulesJson theEmpiRulesJson) {
        for (EmpiResourceSearchParamJson searchParams : theEmpiRulesJson.getCandidateSearchParams()) {
            searchParams.iterator().forEachRemaining(searchParam -> this.validateSearchParam("candidateSearchParams", searchParams.getResourceType(), (String)searchParam));
        }
        for (EmpiFilterSearchParamJson filter : theEmpiRulesJson.getCandidateFilterSearchParams()) {
            this.validateSearchParam("candidateFilterSearchParams", filter.getResourceType(), filter.getSearchParam());
        }
    }

    private void validateSearchParam(String theFieldName, String theTheResourceType, String theTheSearchParam) {
        if ("*".equals(theTheResourceType)) {
            this.validateResourceSearchParam(theFieldName, "Patient", theTheSearchParam);
            this.validateResourceSearchParam(theFieldName, "Practitioner", theTheSearchParam);
        } else {
            this.validateResourceSearchParam(theFieldName, theTheResourceType, theTheSearchParam);
        }
    }

    private void validateResourceSearchParam(String theFieldName, String theResourceType, String theSearchParam) {
        if (this.mySearchParamRetriever.getActiveSearchParam(theResourceType, theSearchParam) == null) {
            throw new ConfigurationException("Error in " + theFieldName + ": " + theResourceType + " does not have a search parameter called '" + theSearchParam + "'");
        }
    }

    private void validateMatchFields(EmpiRulesJson theEmpiRulesJson) {
        HashSet<String> names = new HashSet<String>();
        for (EmpiFieldMatchJson fieldMatch : theEmpiRulesJson.getMatchFields()) {
            if (names.contains(fieldMatch.getName())) {
                throw new ConfigurationException("Two MatchFields have the same name '" + fieldMatch.getName() + "'");
            }
            names.add(fieldMatch.getName());
            this.validateThreshold(fieldMatch);
            this.validatePath(fieldMatch);
        }
    }

    private void validateThreshold(EmpiFieldMatchJson theFieldMatch) {
        if (theFieldMatch.getMetric().isSimilarity()) {
            if (theFieldMatch.getMatchThreshold() == null) {
                throw new ConfigurationException("MatchField " + theFieldMatch.getName() + " metric " + (Object)((Object)theFieldMatch.getMetric()) + " requires a matchThreshold");
            }
        } else if (theFieldMatch.getMatchThreshold() != null) {
            throw new ConfigurationException("MatchField " + theFieldMatch.getName() + " metric " + (Object)((Object)theFieldMatch.getMetric()) + " should not have a matchThreshold");
        }
    }

    private void validatePath(EmpiFieldMatchJson theFieldMatch) {
        String resourceType = theFieldMatch.getResourceType();
        if ("*".equals(resourceType)) {
            this.validatePatientPath(theFieldMatch);
            this.validatePractitionerPath(theFieldMatch);
        } else if ("Patient".equals(resourceType)) {
            this.validatePatientPath(theFieldMatch);
        } else if ("Practitioner".equals(resourceType)) {
            this.validatePractitionerPath(theFieldMatch);
        } else {
            throw new ConfigurationException("MatchField " + theFieldMatch.getName() + " has unknown resourceType " + resourceType);
        }
    }

    private void validatePatientPath(EmpiFieldMatchJson theFieldMatch) {
        try {
            this.myTerser.getDefinition(this.myPatientClass, "Patient." + theFieldMatch.getResourcePath());
        }
        catch (ConfigurationException | DataFormatException e) {
            throw new ConfigurationException("MatchField " + theFieldMatch.getName() + " resourceType " + theFieldMatch.getResourceType() + " has invalid path '" + theFieldMatch.getResourcePath() + "'.  " + e.getMessage());
        }
    }

    private void validatePractitionerPath(EmpiFieldMatchJson theFieldMatch) {
        try {
            this.myTerser.getDefinition(this.myPractitionerClass, "Practitioner." + theFieldMatch.getResourcePath());
        }
        catch (DataFormatException e) {
            throw new ConfigurationException("MatchField " + theFieldMatch.getName() + " resourceType " + theFieldMatch.getResourceType() + " has invalid path '" + theFieldMatch.getResourcePath() + "'.  " + e.getMessage());
        }
    }

    private void validateSystemIsUri(EmpiRulesJson theEmpiRulesJson) {
        if (theEmpiRulesJson.getEnterpriseEIDSystem() == null) {
            return;
        }
        try {
            new URI(theEmpiRulesJson.getEnterpriseEIDSystem());
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Enterprise Identifier System (eidSystem) must be a valid URI");
        }
    }
}

