/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.rules.config;

import ca.uhn.fhir.empi.api.IEmpiRuleValidator;
import ca.uhn.fhir.empi.api.IEmpiSettings;
import ca.uhn.fhir.empi.rules.json.EmpiRulesJson;
import ca.uhn.fhir.util.JsonUtil;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmpiSettings
implements IEmpiSettings {
    private final IEmpiRuleValidator myEmpiRuleValidator;
    private boolean myEnabled;
    private int myConcurrentConsumers = 5;
    private String myScriptText;
    private EmpiRulesJson myEmpiRules;
    private boolean myPreventEidUpdates;
    private boolean myPreventMultipleEids;

    @Autowired
    public EmpiSettings(IEmpiRuleValidator theEmpiRuleValidator) {
        this.myEmpiRuleValidator = theEmpiRuleValidator;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    public EmpiSettings setEnabled(boolean theEnabled) {
        this.myEnabled = theEnabled;
        return this;
    }

    @Override
    public int getConcurrentConsumers() {
        return this.myConcurrentConsumers;
    }

    public EmpiSettings setConcurrentConsumers(int theConcurrentConsumers) {
        this.myConcurrentConsumers = theConcurrentConsumers;
        return this;
    }

    public String getScriptText() {
        return this.myScriptText;
    }

    public EmpiSettings setScriptText(String theScriptText) throws IOException {
        this.myScriptText = theScriptText;
        this.setEmpiRules((EmpiRulesJson)JsonUtil.deserialize((String)theScriptText, EmpiRulesJson.class));
        return this;
    }

    @Override
    public EmpiRulesJson getEmpiRules() {
        return this.myEmpiRules;
    }

    @Override
    public boolean isPreventEidUpdates() {
        return this.myPreventEidUpdates;
    }

    public EmpiSettings setPreventEidUpdates(boolean thePreventEidUpdates) {
        this.myPreventEidUpdates = thePreventEidUpdates;
        return this;
    }

    public EmpiSettings setEmpiRules(EmpiRulesJson theEmpiRules) {
        this.myEmpiRuleValidator.validate(theEmpiRules);
        this.myEmpiRules = theEmpiRules;
        return this;
    }

    @Override
    public boolean isPreventMultipleEids() {
        return this.myPreventMultipleEids;
    }

    @Override
    public String getRuleVersion() {
        return this.myEmpiRules.getVersion();
    }

    public EmpiSettings setPreventMultipleEids(boolean thePreventMultipleEids) {
        this.myPreventMultipleEids = thePreventMultipleEids;
        return this;
    }
}

