/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.rules.json;

import ca.uhn.fhir.empi.api.EmpiMatchResultEnum;
import ca.uhn.fhir.empi.rules.json.EmpiFieldMatchJson;
import ca.uhn.fhir.empi.rules.json.EmpiFilterSearchParamJson;
import ca.uhn.fhir.empi.rules.json.EmpiResourceSearchParamJson;
import ca.uhn.fhir.empi.rules.json.VectorMatchResultMap;
import ca.uhn.fhir.model.api.IModelJson;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

@JsonDeserialize(converter=EmpiRulesJsonConverter.class)
public class EmpiRulesJson
implements IModelJson {
    @JsonProperty(value="version", required=true)
    String myVersion;
    @JsonProperty(value="candidateSearchParams", required=true)
    List<EmpiResourceSearchParamJson> myCandidateSearchParams = new ArrayList<EmpiResourceSearchParamJson>();
    @JsonProperty(value="candidateFilterSearchParams", required=true)
    List<EmpiFilterSearchParamJson> myCandidateFilterSearchParams = new ArrayList<EmpiFilterSearchParamJson>();
    @JsonProperty(value="matchFields", required=true)
    List<EmpiFieldMatchJson> myMatchFieldJsonList = new ArrayList<EmpiFieldMatchJson>();
    @JsonProperty(value="matchResultMap", required=true)
    Map<String, EmpiMatchResultEnum> myMatchResultMap = new HashMap<String, EmpiMatchResultEnum>();
    @JsonProperty(value="eidSystem")
    String myEnterpriseEIDSystem;
    transient VectorMatchResultMap myVectorMatchResultMap;

    public void addMatchField(EmpiFieldMatchJson theMatchRuleName) {
        this.myMatchFieldJsonList.add(theMatchRuleName);
    }

    public void addResourceSearchParam(EmpiResourceSearchParamJson theSearchParam) {
        this.myCandidateSearchParams.add(theSearchParam);
    }

    public void addFilterSearchParam(EmpiFilterSearchParamJson theSearchParam) {
        this.myCandidateFilterSearchParams.add(theSearchParam);
    }

    int size() {
        return this.myMatchFieldJsonList.size();
    }

    EmpiFieldMatchJson get(int theIndex) {
        return this.myMatchFieldJsonList.get(theIndex);
    }

    EmpiMatchResultEnum getMatchResult(String theFieldMatchNames) {
        return this.myMatchResultMap.get(theFieldMatchNames);
    }

    public EmpiMatchResultEnum getMatchResult(Long theMatchVector) {
        return this.myVectorMatchResultMap.get(theMatchVector);
    }

    public void putMatchResult(String theFieldMatchNames, EmpiMatchResultEnum theMatchResult) {
        this.myMatchResultMap.put(theFieldMatchNames, theMatchResult);
        this.initialize();
    }

    Map<String, EmpiMatchResultEnum> getMatchResultMap() {
        return Collections.unmodifiableMap(this.myMatchResultMap);
    }

    public void initialize() {
        this.myVectorMatchResultMap = new VectorMatchResultMap(this);
    }

    public List<EmpiFieldMatchJson> getMatchFields() {
        return Collections.unmodifiableList(this.myMatchFieldJsonList);
    }

    public List<EmpiResourceSearchParamJson> getCandidateSearchParams() {
        return Collections.unmodifiableList(this.myCandidateSearchParams);
    }

    public List<EmpiFilterSearchParamJson> getCandidateFilterSearchParams() {
        return Collections.unmodifiableList(this.myCandidateFilterSearchParams);
    }

    public String getEnterpriseEIDSystem() {
        return this.myEnterpriseEIDSystem;
    }

    public void setEnterpriseEIDSystem(String theEnterpriseEIDSystem) {
        this.myEnterpriseEIDSystem = theEnterpriseEIDSystem;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public EmpiRulesJson setVersion(String theVersion) {
        this.myVersion = theVersion;
        return this;
    }

    private void validate() {
        Validate.notBlank((CharSequence)this.myVersion, (String)"version may not be blank", (Object[])new Object[0]);
    }

    public String getSummary() {
        return this.myCandidateSearchParams.size() + " Candidate Search Params, " + this.myCandidateFilterSearchParams.size() + " Filter Search Params, " + this.myMatchFieldJsonList.size() + " Match Fields, " + this.myMatchResultMap.size() + " Match Result Entries";
    }

    public String getFieldMatchNamesForVector(long theVector) {
        return this.myVectorMatchResultMap.getFieldMatchNames(theVector);
    }

    public String getDetailedFieldMatchResultForUnmatchedVector(long theVector) {
        ArrayList<String> fieldMatchResult = new ArrayList<String>();
        for (int i = 0; i < this.myMatchFieldJsonList.size(); ++i) {
            if ((theVector & (long)(1 << i)) == 0L) {
                fieldMatchResult.add(this.myMatchFieldJsonList.get(i).getName() + ": NO");
                continue;
            }
            fieldMatchResult.add(this.myMatchFieldJsonList.get(i).getName() + ": YES");
        }
        return String.join((CharSequence)"\n", fieldMatchResult);
    }

    @VisibleForTesting
    VectorMatchResultMap getVectorMatchResultMapForUnitTest() {
        return this.myVectorMatchResultMap;
    }

    static class EmpiRulesJsonConverter
    extends StdConverter<EmpiRulesJson, EmpiRulesJson> {
        public EmpiRulesJson convert(EmpiRulesJson theEmpiRulesJson) {
            theEmpiRulesJson.validate();
            theEmpiRulesJson.initialize();
            return theEmpiRulesJson;
        }
    }
}

