/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.rules.json;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.empi.api.EmpiMatchResultEnum;
import ca.uhn.fhir.empi.rules.json.EmpiRulesJson;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class VectorMatchResultMap {
    private final EmpiRulesJson myEmpiRulesJson;
    private Map<Long, EmpiMatchResultEnum> myVectorToMatchResultMap = new HashMap<Long, EmpiMatchResultEnum>();
    private Set<Long> myMatchVectors = new HashSet<Long>();
    private Set<Long> myPossibleMatchVectors = new HashSet<Long>();
    private Map<Long, String> myVectorToFieldMatchNamesMap = new HashMap<Long, String>();

    VectorMatchResultMap(EmpiRulesJson theEmpiRulesJson) {
        this.myEmpiRulesJson = theEmpiRulesJson;
        this.initMap();
    }

    private void initMap() {
        for (Map.Entry<String, EmpiMatchResultEnum> entry : this.myEmpiRulesJson.getMatchResultMap().entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Nonnull
    public EmpiMatchResultEnum get(Long theMatchVector) {
        return this.myVectorToMatchResultMap.computeIfAbsent(theMatchVector, this::computeMatchResult);
    }

    private EmpiMatchResultEnum computeMatchResult(Long theVector) {
        if (this.myMatchVectors.stream().anyMatch(v -> (v & theVector) != 0L)) {
            return EmpiMatchResultEnum.MATCH;
        }
        if (this.myPossibleMatchVectors.stream().anyMatch(v -> (v & theVector) != 0L)) {
            return EmpiMatchResultEnum.POSSIBLE_MATCH;
        }
        return EmpiMatchResultEnum.NO_MATCH;
    }

    private void put(String theFieldMatchNames, EmpiMatchResultEnum theMatchResult) {
        long vector = this.getVector(theFieldMatchNames);
        this.myVectorToFieldMatchNamesMap.put(vector, theFieldMatchNames);
        this.myVectorToMatchResultMap.put(vector, theMatchResult);
        if (theMatchResult == EmpiMatchResultEnum.MATCH) {
            this.myMatchVectors.add(vector);
        } else if (theMatchResult == EmpiMatchResultEnum.POSSIBLE_MATCH) {
            this.myPossibleMatchVectors.add(vector);
        }
    }

    public long getVector(String theFieldMatchNames) {
        long retval = 0L;
        for (String fieldMatchName : VectorMatchResultMap.splitFieldMatchNames(theFieldMatchNames)) {
            int index = this.getFieldMatchIndex(fieldMatchName);
            if (index == -1) {
                throw new ConfigurationException("There is no matchField with name " + fieldMatchName);
            }
            retval |= (long)(1 << index);
        }
        return retval;
    }

    @Nonnull
    static String[] splitFieldMatchNames(String theFieldMatchNames) {
        return theFieldMatchNames.split(",\\s*");
    }

    private int getFieldMatchIndex(String theFieldMatchName) {
        for (int i = 0; i < this.myEmpiRulesJson.size(); ++i) {
            if (!this.myEmpiRulesJson.get(i).getName().equals(theFieldMatchName)) continue;
            return i;
        }
        return -1;
    }

    public String getFieldMatchNames(long theVector) {
        return this.myVectorToFieldMatchNamesMap.get(theVector);
    }
}

