/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.rules.metric;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.phonetic.PhoneticEncoderEnum;
import ca.uhn.fhir.empi.api.EmpiMatchEvaluation;
import ca.uhn.fhir.empi.rules.metric.IEmpiFieldMetric;
import ca.uhn.fhir.empi.rules.metric.matcher.EmpiPersonNameMatchModeEnum;
import ca.uhn.fhir.empi.rules.metric.matcher.HapiDateMatcher;
import ca.uhn.fhir.empi.rules.metric.matcher.HapiStringMatcher;
import ca.uhn.fhir.empi.rules.metric.matcher.IEmpiFieldMatcher;
import ca.uhn.fhir.empi.rules.metric.matcher.NameMatcher;
import ca.uhn.fhir.empi.rules.metric.matcher.PhoneticEncoderMatcher;
import ca.uhn.fhir.empi.rules.metric.matcher.SubstringStringMatcher;
import ca.uhn.fhir.empi.rules.metric.similarity.HapiStringSimilarity;
import ca.uhn.fhir.empi.rules.metric.similarity.IEmpiFieldSimilarity;
import info.debatty.java.stringsimilarity.Cosine;
import info.debatty.java.stringsimilarity.Jaccard;
import info.debatty.java.stringsimilarity.JaroWinkler;
import info.debatty.java.stringsimilarity.NormalizedLevenshtein;
import info.debatty.java.stringsimilarity.SorensenDice;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringSimilarity;
import javax.annotation.Nullable;
import org.hl7.fhir.instance.model.api.IBase;

public enum EmpiMetricEnum {
    CAVERPHONE1(new HapiStringMatcher(new PhoneticEncoderMatcher(PhoneticEncoderEnum.CAVERPHONE1))),
    CAVERPHONE2(new HapiStringMatcher(new PhoneticEncoderMatcher(PhoneticEncoderEnum.CAVERPHONE2))),
    COLOGNE(new HapiStringMatcher(new PhoneticEncoderMatcher(PhoneticEncoderEnum.COLOGNE))),
    DOUBLE_METAPHONE(new HapiStringMatcher(new PhoneticEncoderMatcher(PhoneticEncoderEnum.DOUBLE_METAPHONE))),
    MATCH_RATING_APPROACH(new HapiStringMatcher(new PhoneticEncoderMatcher(PhoneticEncoderEnum.MATCH_RATING_APPROACH))),
    METAPHONE(new HapiStringMatcher(new PhoneticEncoderMatcher(PhoneticEncoderEnum.METAPHONE))),
    NYSIIS(new HapiStringMatcher(new PhoneticEncoderMatcher(PhoneticEncoderEnum.NYSIIS))),
    REFINED_SOUNDEX(new HapiStringMatcher(new PhoneticEncoderMatcher(PhoneticEncoderEnum.REFINED_SOUNDEX))),
    SOUNDEX(new HapiStringMatcher(new PhoneticEncoderMatcher(PhoneticEncoderEnum.SOUNDEX))),
    STRING(new HapiStringMatcher()),
    SUBSTRING(new HapiStringMatcher(new SubstringStringMatcher())),
    DATE(new HapiDateMatcher()),
    JARO_WINKLER(new HapiStringSimilarity((NormalizedStringSimilarity)new JaroWinkler())),
    COSINE(new HapiStringSimilarity((NormalizedStringSimilarity)new Cosine())),
    JACCARD(new HapiStringSimilarity((NormalizedStringSimilarity)new Jaccard())),
    LEVENSCHTEIN(new HapiStringSimilarity((NormalizedStringSimilarity)new NormalizedLevenshtein())),
    SORENSEN_DICE(new HapiStringSimilarity((NormalizedStringSimilarity)new SorensenDice())),
    NAME_ANY_ORDER(new NameMatcher(EmpiPersonNameMatchModeEnum.ANY_ORDER)),
    NAME_FIRST_AND_LAST(new NameMatcher(EmpiPersonNameMatchModeEnum.FIRST_AND_LAST));

    private final IEmpiFieldMetric myEmpiFieldMetric;

    private EmpiMetricEnum(IEmpiFieldMetric theEmpiFieldMetric) {
        this.myEmpiFieldMetric = theEmpiFieldMetric;
    }

    public boolean match(FhirContext theFhirContext, IBase theLeftBase, IBase theRightBase, boolean theExact) {
        return ((IEmpiFieldMatcher)this.myEmpiFieldMetric).matches(theFhirContext, theLeftBase, theRightBase, theExact);
    }

    public EmpiMatchEvaluation match(FhirContext theFhirContext, IBase theLeftBase, IBase theRightBase, boolean theExact, @Nullable Double theThreshold) {
        if (this.isSimilarity()) {
            return this.matchBySimilarity((IEmpiFieldSimilarity)this.myEmpiFieldMetric, theFhirContext, theLeftBase, theRightBase, theExact, theThreshold);
        }
        return this.matchByMatcher((IEmpiFieldMatcher)this.myEmpiFieldMetric, theFhirContext, theLeftBase, theRightBase, theExact);
    }

    private EmpiMatchEvaluation matchBySimilarity(IEmpiFieldSimilarity theSimilarity, FhirContext theFhirContext, IBase theLeftBase, IBase theRightBase, boolean theExact, Double theThreshold) {
        double similarityResult = theSimilarity.similarity(theFhirContext, theLeftBase, theRightBase, theExact);
        return new EmpiMatchEvaluation(similarityResult >= theThreshold, similarityResult);
    }

    private EmpiMatchEvaluation matchByMatcher(IEmpiFieldMatcher theMatcher, FhirContext theFhirContext, IBase theLeftBase, IBase theRightBase, boolean theExact) {
        boolean matcherResult;
        return new EmpiMatchEvaluation(matcherResult, (matcherResult = theMatcher.matches(theFhirContext, theLeftBase, theRightBase, theExact)) ? 1.0 : 0.0);
    }

    public boolean isSimilarity() {
        return this.myEmpiFieldMetric instanceof IEmpiFieldSimilarity;
    }
}

