/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.rules.metric.matcher;

import java.util.Date;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r4.model.BaseDateTimeType;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;

public class HapiDateMatcherR4 {
    public boolean match(IBase theLeftBase, IBase theRightBase) {
        if (theLeftBase instanceof BaseDateTimeType && theRightBase instanceof BaseDateTimeType) {
            Object rightPDate;
            Object leftPDate;
            BaseDateTimeType leftDate = (BaseDateTimeType)theLeftBase;
            BaseDateTimeType rightDate = (BaseDateTimeType)theRightBase;
            int comparison = leftDate.getPrecision().compareTo((Enum)rightDate.getPrecision());
            if (comparison == 0) {
                return leftDate.getValueAsString().equals(rightDate.getValueAsString());
            }
            if (comparison > 0) {
                leftPDate = leftDate;
                rightPDate = rightDate instanceof DateType ? new DateType((Date)rightDate.getValue(), leftDate.getPrecision()) : new DateTimeType((Date)rightDate.getValue(), leftDate.getPrecision());
            } else {
                rightPDate = rightDate;
                leftPDate = leftDate instanceof DateType ? new DateType((Date)leftDate.getValue(), rightDate.getPrecision()) : new DateTimeType((Date)leftDate.getValue(), rightDate.getPrecision());
            }
            return leftPDate.getValueAsString().equals(rightPDate.getValueAsString());
        }
        return false;
    }
}

