/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.rules.metric.matcher;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.empi.rules.metric.matcher.BaseHapiStringMetric;
import ca.uhn.fhir.empi.rules.metric.matcher.IEmpiFieldMatcher;
import ca.uhn.fhir.empi.rules.metric.matcher.IEmpiStringMatcher;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class HapiStringMatcher
extends BaseHapiStringMetric
implements IEmpiFieldMatcher {
    private final IEmpiStringMatcher myStringMatcher;

    public HapiStringMatcher(IEmpiStringMatcher theStringMatcher) {
        this.myStringMatcher = theStringMatcher;
    }

    public HapiStringMatcher() {
        this.myStringMatcher = String::equals;
    }

    @Override
    public boolean matches(FhirContext theFhirContext, IBase theLeftBase, IBase theRightBase, boolean theExact) {
        if (theLeftBase instanceof IPrimitiveType && theRightBase instanceof IPrimitiveType) {
            String leftString = this.extractString((IPrimitiveType)theLeftBase, theExact);
            String rightString = this.extractString((IPrimitiveType)theRightBase, theExact);
            return this.myStringMatcher.matches(leftString, rightString);
        }
        return false;
    }
}

