/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.rules.metric.matcher;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.empi.rules.metric.matcher.EmpiPersonNameMatchModeEnum;
import ca.uhn.fhir.empi.rules.metric.matcher.IEmpiFieldMatcher;
import ca.uhn.fhir.empi.util.NameUtil;
import ca.uhn.fhir.util.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;

public class NameMatcher
implements IEmpiFieldMatcher {
    private final EmpiPersonNameMatchModeEnum myMatchMode;

    public NameMatcher(EmpiPersonNameMatchModeEnum theMatchMode) {
        this.myMatchMode = theMatchMode;
    }

    @Override
    public boolean matches(FhirContext theFhirContext, IBase theLeftBase, IBase theRightBase, boolean theExact) {
        String leftFamilyName = NameUtil.extractFamilyName(theFhirContext, theLeftBase);
        String rightFamilyName = NameUtil.extractFamilyName(theFhirContext, theRightBase);
        if (StringUtils.isEmpty((CharSequence)leftFamilyName) || StringUtils.isEmpty((CharSequence)rightFamilyName)) {
            return false;
        }
        boolean match = false;
        List<String> leftGivenNames = NameUtil.extractGivenNames(theFhirContext, theLeftBase);
        List<String> rightGivenNames = NameUtil.extractGivenNames(theFhirContext, theRightBase);
        if (!theExact) {
            leftFamilyName = StringUtil.normalizeStringForSearchIndexing((String)leftFamilyName);
            rightFamilyName = StringUtil.normalizeStringForSearchIndexing((String)rightFamilyName);
            leftGivenNames = leftGivenNames.stream().map(StringUtil::normalizeStringForSearchIndexing).collect(Collectors.toList());
            rightGivenNames = rightGivenNames.stream().map(StringUtil::normalizeStringForSearchIndexing).collect(Collectors.toList());
        }
        for (String leftGivenName : leftGivenNames) {
            for (String rightGivenName : rightGivenNames) {
                match |= leftGivenName.equals(rightGivenName) && leftFamilyName.equals(rightFamilyName);
                if (this.myMatchMode != EmpiPersonNameMatchModeEnum.ANY_ORDER) continue;
                match |= leftGivenName.equals(rightFamilyName) && leftFamilyName.equals(rightGivenName);
            }
        }
        return match;
    }
}

