/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.rules.metric.similarity;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.empi.rules.metric.matcher.BaseHapiStringMetric;
import ca.uhn.fhir.empi.rules.metric.similarity.IEmpiFieldSimilarity;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringSimilarity;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class HapiStringSimilarity
extends BaseHapiStringMetric
implements IEmpiFieldSimilarity {
    private final NormalizedStringSimilarity myStringSimilarity;

    public HapiStringSimilarity(NormalizedStringSimilarity theStringSimilarity) {
        this.myStringSimilarity = theStringSimilarity;
    }

    @Override
    public double similarity(FhirContext theFhirContext, IBase theLeftBase, IBase theRightBase, boolean theExact) {
        if (theLeftBase instanceof IPrimitiveType && theRightBase instanceof IPrimitiveType) {
            String leftString = this.extractString((IPrimitiveType)theLeftBase, theExact);
            String rightString = this.extractString((IPrimitiveType)theRightBase, theExact);
            return this.myStringSimilarity.similarity(leftString, rightString);
        }
        return 0.0;
    }
}

