/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.rules.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.empi.api.EmpiMatchEvaluation;
import ca.uhn.fhir.empi.rules.json.EmpiFieldMatchJson;
import ca.uhn.fhir.util.FhirTerser;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class EmpiResourceFieldMatcher {
    private final FhirContext myFhirContext;
    private final EmpiFieldMatchJson myEmpiFieldMatchJson;
    private final String myResourceType;
    private final String myResourcePath;

    public EmpiResourceFieldMatcher(FhirContext theFhirContext, EmpiFieldMatchJson theEmpiFieldMatchJson) {
        this.myFhirContext = theFhirContext;
        this.myEmpiFieldMatchJson = theEmpiFieldMatchJson;
        this.myResourceType = theEmpiFieldMatchJson.getResourceType();
        this.myResourcePath = theEmpiFieldMatchJson.getResourcePath();
    }

    public EmpiMatchEvaluation match(IBaseResource theLeftResource, IBaseResource theRightResource) {
        this.validate(theLeftResource);
        this.validate(theRightResource);
        FhirTerser terser = this.myFhirContext.newTerser();
        List leftValues = terser.getValues((IBase)theLeftResource, this.myResourcePath, IBase.class);
        List rightValues = terser.getValues((IBase)theRightResource, this.myResourcePath, IBase.class);
        return this.match(leftValues, rightValues);
    }

    private EmpiMatchEvaluation match(List<IBase> theLeftValues, List<IBase> theRightValues) {
        EmpiMatchEvaluation retval = new EmpiMatchEvaluation(false, 0.0);
        for (IBase leftValue : theLeftValues) {
            for (IBase rightValue : theRightValues) {
                EmpiMatchEvaluation nextMatch = this.match(leftValue, rightValue);
                retval = EmpiMatchEvaluation.max(retval, nextMatch);
            }
        }
        return retval;
    }

    private EmpiMatchEvaluation match(IBase theLeftValue, IBase theRightValue) {
        return this.myEmpiFieldMatchJson.getMetric().match(this.myFhirContext, theLeftValue, theRightValue, this.myEmpiFieldMatchJson.getExact(), this.myEmpiFieldMatchJson.getMatchThreshold());
    }

    private void validate(IBaseResource theResource) {
        String resourceType = this.myFhirContext.getResourceType(theResource);
        Validate.notNull((Object)resourceType, (String)"Resource type may not be null", (Object[])new Object[0]);
        if ("*".equals(this.myResourceType)) {
            Validate.isTrue(("Patient".equalsIgnoreCase(resourceType) || "Practitioner".equalsIgnoreCase(resourceType) ? 1 : 0) != 0, (String)"Expecting resource type Patient/Practitioner got resource type %s", (Object[])new Object[]{resourceType});
        } else {
            Validate.isTrue((boolean)this.myResourceType.equals(resourceType), (String)"Expecting resource type %s got resource type %s", (Object[])new Object[]{this.myResourceType, resourceType});
        }
    }
}

