/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.rules.svc;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.empi.api.EmpiMatchEvaluation;
import ca.uhn.fhir.empi.api.EmpiMatchOutcome;
import ca.uhn.fhir.empi.api.EmpiMatchResultEnum;
import ca.uhn.fhir.empi.api.IEmpiSettings;
import ca.uhn.fhir.empi.log.Logs;
import ca.uhn.fhir.empi.rules.json.EmpiFieldMatchJson;
import ca.uhn.fhir.empi.rules.json.EmpiRulesJson;
import ca.uhn.fhir.empi.rules.svc.EmpiResourceFieldMatcher;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmpiResourceMatcherSvc {
    private static final Logger ourLog = Logs.getEmpiTroubleshootingLog();
    private final FhirContext myFhirContext;
    private final IEmpiSettings myEmpiSettings;
    private EmpiRulesJson myEmpiRulesJson;
    private final List<EmpiResourceFieldMatcher> myFieldMatchers = new ArrayList<EmpiResourceFieldMatcher>();

    @Autowired
    public EmpiResourceMatcherSvc(FhirContext theFhirContext, IEmpiSettings theEmpiSettings) {
        this.myFhirContext = theFhirContext;
        this.myEmpiSettings = theEmpiSettings;
    }

    @PostConstruct
    public void init() {
        this.myEmpiRulesJson = this.myEmpiSettings.getEmpiRules();
        if (this.myEmpiRulesJson == null) {
            throw new ConfigurationException("Failed to load EMPI Rules.  If EMPI is enabled, then EMPI rules must be available in context.");
        }
        for (EmpiFieldMatchJson matchFieldJson : this.myEmpiRulesJson.getMatchFields()) {
            this.myFieldMatchers.add(new EmpiResourceFieldMatcher(this.myFhirContext, matchFieldJson));
        }
    }

    public EmpiMatchOutcome getMatchResult(IBaseResource theLeftResource, IBaseResource theRightResource) {
        return this.match(theLeftResource, theRightResource);
    }

    EmpiMatchOutcome match(IBaseResource theLeftResource, IBaseResource theRightResource) {
        EmpiMatchOutcome matchResult = this.getMatchOutcome(theLeftResource, theRightResource);
        EmpiMatchResultEnum matchResultEnum = this.myEmpiRulesJson.getMatchResult(matchResult.vector);
        matchResult.setMatchResultEnum(matchResultEnum);
        if (ourLog.isDebugEnabled()) {
            if (matchResult.isMatch() || matchResult.isPossibleMatch()) {
                ourLog.debug("{} {} with field matchers {}", new Object[]{matchResult, theRightResource.getIdElement().toUnqualifiedVersionless(), this.myEmpiRulesJson.getFieldMatchNamesForVector(matchResult.vector)});
            } else if (ourLog.isTraceEnabled()) {
                ourLog.trace("{} {}.  Field matcher results: {}", new Object[]{matchResult, theRightResource.getIdElement().toUnqualifiedVersionless(), this.myEmpiRulesJson.getDetailedFieldMatchResultForUnmatchedVector(matchResult.vector)});
            }
        }
        return matchResult;
    }

    private EmpiMatchOutcome getMatchOutcome(IBaseResource theLeftResource, IBaseResource theRightResource) {
        long vector = 0L;
        double score = 0.0;
        for (int i = 0; i < this.myFieldMatchers.size(); ++i) {
            EmpiResourceFieldMatcher fieldComparator = this.myFieldMatchers.get(i);
            EmpiMatchEvaluation matchEvaluation = fieldComparator.match(theLeftResource, theRightResource);
            if (matchEvaluation.match) {
                vector |= (long)(1 << i);
            }
            score += matchEvaluation.score;
        }
        return new EmpiMatchOutcome(vector, score);
    }
}

