/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.util;

import ca.uhn.fhir.empi.api.EmpiLinkSourceEnum;
import ca.uhn.fhir.empi.api.EmpiMatchResultEnum;
import ca.uhn.fhir.empi.model.CanonicalIdentityAssuranceLevel;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;

public final class AssuranceLevelUtil {
    private AssuranceLevelUtil() {
    }

    public static CanonicalIdentityAssuranceLevel getAssuranceLevel(EmpiMatchResultEnum theMatchResult, EmpiLinkSourceEnum theSource) {
        switch (theSource) {
            case MANUAL: {
                return AssuranceLevelUtil.getAssuranceFromManualResult(theMatchResult);
            }
            case AUTO: {
                return AssuranceLevelUtil.getAssuranceFromAutoResult(theMatchResult);
            }
        }
        throw new InvalidRequestException("Couldn't figure out an assurance level for result: " + (Object)((Object)theMatchResult) + " and source " + (Object)((Object)theSource));
    }

    private static CanonicalIdentityAssuranceLevel getAssuranceFromAutoResult(EmpiMatchResultEnum theMatchResult) {
        switch (theMatchResult) {
            case MATCH: {
                return CanonicalIdentityAssuranceLevel.LEVEL2;
            }
            case POSSIBLE_MATCH: {
                return CanonicalIdentityAssuranceLevel.LEVEL1;
            }
        }
        throw new InvalidRequestException("An AUTO EMPI Link may not have a match result of " + (Object)((Object)theMatchResult));
    }

    private static CanonicalIdentityAssuranceLevel getAssuranceFromManualResult(EmpiMatchResultEnum theMatchResult) {
        switch (theMatchResult) {
            case MATCH: {
                return CanonicalIdentityAssuranceLevel.LEVEL3;
            }
        }
        throw new InvalidRequestException("A MANUAL EMPI Link may not have a match result of " + (Object)((Object)theMatchResult));
    }
}

