/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.empi.api.IEmpiSettings;
import ca.uhn.fhir.empi.model.CanonicalEID;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class EIDHelper {
    private final FhirContext myFhirContext;
    private final IEmpiSettings myEmpiConfig;

    @Autowired
    public EIDHelper(FhirContext theFhirContext, IEmpiSettings theEmpiConfig) {
        this.myFhirContext = theFhirContext;
        this.myEmpiConfig = theEmpiConfig;
    }

    public CanonicalEID createHapiEid() {
        return new CanonicalEID("http://hapifhir.io/fhir/NamingSystem/empi-person-enterprise-id", UUID.randomUUID().toString(), null);
    }

    public List<CanonicalEID> getExternalEid(IBaseResource theResource) {
        return CanonicalEID.extractFromResource(this.myFhirContext, this.myEmpiConfig.getEmpiRules().getEnterpriseEIDSystem(), theResource);
    }

    public List<CanonicalEID> getHapiEid(IAnyResource theResource) {
        return CanonicalEID.extractFromResource(this.myFhirContext, "http://hapifhir.io/fhir/NamingSystem/empi-person-enterprise-id", (IBaseResource)theResource);
    }

    public boolean eidMatchExists(List<CanonicalEID> theFirstResourceEids, List<CanonicalEID> theSecondResourceEids) {
        List collect1;
        List collect = theFirstResourceEids.stream().map(CanonicalEID::getValue).collect(Collectors.toList());
        return !Collections.disjoint(collect, collect1 = theSecondResourceEids.stream().map(CanonicalEID::getValue).collect(Collectors.toList()));
    }

    public boolean hasEidOverlap(IAnyResource theExistingPerson, IAnyResource theComparingPerson) {
        List<CanonicalEID> firstEids = this.getExternalEid((IBaseResource)theExistingPerson);
        List<CanonicalEID> secondEids = this.getExternalEid((IBaseResource)theComparingPerson);
        if (firstEids.isEmpty() || secondEids.isEmpty()) {
            return false;
        }
        return this.eidMatchExists(firstEids, secondEids);
    }
}

