/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.util;

import ca.uhn.fhir.context.FhirContext;
import org.hl7.fhir.instance.model.api.IBaseResource;

public final class EmpiUtil {
    private EmpiUtil() {
    }

    public static boolean supportedTargetType(String theResourceType) {
        return "Patient".equals(theResourceType) || "Practitioner".equals(theResourceType);
    }

    public static boolean isEmpiResourceType(FhirContext theFhirContext, IBaseResource theResource) {
        String resourceType = theFhirContext.getResourceType(theResource);
        return "Patient".equals(resourceType) || "Practitioner".equals(resourceType) || "Person".equals(resourceType);
    }

    public static boolean isEmpiAccessible(IBaseResource theBaseResource) {
        return theBaseResource.getMeta().getTag("https://hapifhir.org/NamingSystem/managing-empi-system", "NO-EMPI") == null;
    }

    public static boolean isEmpiManaged(IBaseResource theBaseResource) {
        return theBaseResource.getMeta().getTag("https://hapifhir.org/NamingSystem/managing-empi-system", "HAPI-EMPI") != null;
    }

    public static boolean isEmpiManagedPerson(FhirContext theFhirContext, IBaseResource theResource) {
        String resourceType = theFhirContext.getResourceType(theResource);
        return "Person".equals(resourceType) && EmpiUtil.isEmpiManaged(theResource);
    }
}

