/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.empi.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.empi.api.IEmpiSettings;
import ca.uhn.fhir.empi.log.Logs;
import ca.uhn.fhir.empi.model.CanonicalEID;
import ca.uhn.fhir.empi.model.CanonicalIdentityAssuranceLevel;
import ca.uhn.fhir.empi.model.EmpiTransactionContext;
import ca.uhn.fhir.empi.util.EIDHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Person;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Person;
import org.hl7.fhir.r4.model.Reference;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonHelper {
    private static final Logger ourLog = Logs.getEmpiTroubleshootingLog();
    @Autowired
    private IEmpiSettings myEmpiConfig;
    @Autowired
    private EIDHelper myEIDHelper;
    private final FhirContext myFhirContext;

    @Autowired
    public PersonHelper(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    public Stream<IIdType> getLinkIds(IBaseResource thePerson) {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R4: {
                org.hl7.fhir.r4.model.Person personR4 = (org.hl7.fhir.r4.model.Person)thePerson;
                return personR4.getLink().stream().map(Person.PersonLinkComponent::getTarget).map(IBaseReference::getReferenceElement).map(IIdType::toUnqualifiedVersionless);
            }
            case DSTU3: {
                Person personStu3 = (Person)thePerson;
                return personStu3.getLink().stream().map(Person.PersonLinkComponent::getTarget).map(IBaseReference::getReferenceElement).map(IIdType::toUnqualifiedVersionless);
            }
        }
        throw new UnsupportedOperationException("Version not supported: " + this.myFhirContext.getVersion().getVersion());
    }

    public boolean containsLinkTo(IBaseResource thePerson, IIdType theResourceId) {
        Stream<IIdType> links = this.getLinkIds(thePerson);
        return links.anyMatch(link -> link.getValue().equals(theResourceId.getValue()));
    }

    public void addOrUpdateLink(IBaseResource thePerson, IIdType theResourceId, @Nonnull CanonicalIdentityAssuranceLevel canonicalAssuranceLevel, EmpiTransactionContext theEmpiTransactionContext) {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R4: {
                this.handleLinkUpdateR4(thePerson, theResourceId, canonicalAssuranceLevel, theEmpiTransactionContext);
                break;
            }
            case DSTU3: {
                this.handleLinkUpdateDSTU3(thePerson, theResourceId, canonicalAssuranceLevel, theEmpiTransactionContext);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Version not supported: " + this.myFhirContext.getVersion().getVersion());
            }
        }
    }

    private void handleLinkUpdateDSTU3(IBaseResource thePerson, IIdType theResourceId, CanonicalIdentityAssuranceLevel theCanonicalAssuranceLevel, EmpiTransactionContext theTransactionLogMessages) {
        if (theCanonicalAssuranceLevel == null) {
            ourLog.warn("Refusing to update or add a link without an Assurance Level.");
            return;
        }
        Person person = (Person)thePerson;
        if (!this.containsLinkTo(thePerson, theResourceId)) {
            person.addLink().setTarget(new org.hl7.fhir.dstu3.model.Reference(theResourceId)).setAssurance(theCanonicalAssuranceLevel.toDstu3());
            this.logLinkAddMessage(thePerson, theResourceId, theCanonicalAssuranceLevel, theTransactionLogMessages);
        } else {
            person.getLink().stream().filter(link -> link.getTarget().getReference().equalsIgnoreCase(theResourceId.getValue())).findFirst().ifPresent(link -> {
                this.logLinkUpdateMessage(thePerson, theResourceId, theCanonicalAssuranceLevel, theTransactionLogMessages, link.getAssurance().toCode());
                link.setAssurance(theCanonicalAssuranceLevel.toDstu3());
            });
        }
    }

    private void logLinkAddMessage(IBaseResource thePerson, IIdType theResourceId, CanonicalIdentityAssuranceLevel theCanonicalAssuranceLevel, EmpiTransactionContext theEmpiTransactionContext) {
        theEmpiTransactionContext.addTransactionLogMessage("Creating new link from " + (StringUtils.isBlank((CharSequence)thePerson.getIdElement().toUnqualifiedVersionless().getValue()) ? "new Person" : thePerson.getIdElement().toUnqualifiedVersionless()) + " -> " + theResourceId.toUnqualifiedVersionless() + " with IdentityAssuranceLevel: " + theCanonicalAssuranceLevel.name());
    }

    private void logLinkUpdateMessage(IBaseResource thePerson, IIdType theResourceId, CanonicalIdentityAssuranceLevel canonicalAssuranceLevel, EmpiTransactionContext theEmpiTransactionContext, String theOriginalAssuranceLevel) {
        theEmpiTransactionContext.addTransactionLogMessage("Updating link from " + thePerson.getIdElement().toUnqualifiedVersionless() + " -> " + theResourceId.toUnqualifiedVersionless() + ". Changing IdentityAssuranceLevel: " + theOriginalAssuranceLevel + " -> " + canonicalAssuranceLevel.name());
    }

    private void handleLinkUpdateR4(IBaseResource thePerson, IIdType theResourceId, CanonicalIdentityAssuranceLevel canonicalAssuranceLevel, EmpiTransactionContext theEmpiTransactionContext) {
        if (canonicalAssuranceLevel == null) {
            ourLog.warn("Refusing to update or add a link without an Assurance Level.");
            return;
        }
        org.hl7.fhir.r4.model.Person person = (org.hl7.fhir.r4.model.Person)thePerson;
        if (!this.containsLinkTo(thePerson, theResourceId)) {
            person.addLink().setTarget(new Reference(theResourceId)).setAssurance(canonicalAssuranceLevel.toR4());
            this.logLinkAddMessage(thePerson, theResourceId, canonicalAssuranceLevel, theEmpiTransactionContext);
        } else {
            person.getLink().stream().filter(link -> link.getTarget().getReference().equalsIgnoreCase(theResourceId.getValue())).findFirst().ifPresent(link -> {
                this.logLinkUpdateMessage(thePerson, theResourceId, canonicalAssuranceLevel, theEmpiTransactionContext, link.getAssurance().toCode());
                link.setAssurance(canonicalAssuranceLevel.toR4());
            });
        }
    }

    public void removeLink(IBaseResource thePerson, IIdType theResourceId, EmpiTransactionContext theEmpiTransactionContext) {
        if (!this.containsLinkTo(thePerson, theResourceId)) {
            return;
        }
        theEmpiTransactionContext.addTransactionLogMessage("Removing PersonLinkComponent from " + thePerson.getIdElement().toUnqualifiedVersionless() + " -> " + theResourceId.toUnqualifiedVersionless());
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R4: {
                org.hl7.fhir.r4.model.Person person = (org.hl7.fhir.r4.model.Person)thePerson;
                List links = person.getLink();
                links.removeIf(component -> component.hasTarget() && component.getTarget().getReference().equals(theResourceId.getValue()));
                break;
            }
            case DSTU3: {
                Person personDstu3 = (Person)thePerson;
                personDstu3.getLink().removeIf(component -> component.hasTarget() && component.getTarget().getReference().equalsIgnoreCase(theResourceId.getValue()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Version not supported: " + this.myFhirContext.getVersion().getVersion());
            }
        }
    }

    public IAnyResource createPersonFromEmpiTarget(IAnyResource theSourceResource) {
        String eidSystem = this.myEmpiConfig.getEmpiRules().getEnterpriseEIDSystem();
        List<CanonicalEID> eidsToApply = this.myEIDHelper.getExternalEid((IBaseResource)theSourceResource);
        if (eidsToApply.isEmpty()) {
            eidsToApply.add(this.myEIDHelper.createHapiEid());
        }
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R4: {
                org.hl7.fhir.r4.model.Person personR4 = new org.hl7.fhir.r4.model.Person();
                personR4.setActive(true);
                eidsToApply.forEach(eid -> personR4.addIdentifier(eid.toR4()));
                personR4.getMeta().addTag((Coding)this.buildEmpiManagedTag());
                this.copyEmpiTargetDataIntoPerson((IBaseResource)theSourceResource, (IBaseResource)personR4, true);
                return personR4;
            }
            case DSTU3: {
                Person personDstu3 = new Person();
                personDstu3.setActive(true);
                eidsToApply.forEach(eid -> personDstu3.addIdentifier(eid.toDSTU3()));
                personDstu3.getMeta().addTag((org.hl7.fhir.dstu3.model.Coding)this.buildEmpiManagedTag());
                this.copyEmpiTargetDataIntoPerson((IBaseResource)theSourceResource, (IBaseResource)personDstu3, true);
                return personDstu3;
            }
        }
        throw new UnsupportedOperationException("Version not supported: " + this.myFhirContext.getVersion().getVersion());
    }

    private void copyEmpiTargetDataIntoPerson(IBaseResource theBaseResource, IBaseResource thePerson, Boolean theAllowOverwriting) {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R4: {
                this.copyR4TargetInformation(theBaseResource, thePerson, theAllowOverwriting);
                break;
            }
            case DSTU3: {
                this.copyDSTU3TargetInformation(theBaseResource, thePerson, theAllowOverwriting);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Version not supported: " + this.myFhirContext.getVersion().getVersion());
            }
        }
    }

    private void copyR4TargetInformation(IBaseResource theBaseResource, IBaseResource thePerson, boolean theAllowOverwriting) {
        org.hl7.fhir.r4.model.Person person = (org.hl7.fhir.r4.model.Person)thePerson;
        switch (this.myFhirContext.getResourceType(theBaseResource)) {
            case "Patient": {
                org.hl7.fhir.r4.model.Patient patient = (org.hl7.fhir.r4.model.Patient)theBaseResource;
                if (theAllowOverwriting || person.getName().isEmpty()) {
                    person.setName(patient.getName());
                }
                if (theAllowOverwriting || person.getName().isEmpty()) {
                    person.setAddress(patient.getAddress());
                }
                if (theAllowOverwriting || person.getTelecom().isEmpty()) {
                    person.setTelecom(patient.getTelecom());
                }
                if (theAllowOverwriting || person.getBirthDate() == null) {
                    person.setBirthDate(patient.getBirthDate());
                }
                if (theAllowOverwriting || person.getGender() == null) {
                    person.setGender(patient.getGender());
                }
                if (!theAllowOverwriting && !person.getPhoto().isEmpty()) break;
                person.setPhoto(patient.getPhotoFirstRep());
                break;
            }
            case "Practitioner": {
                org.hl7.fhir.r4.model.Practitioner practitioner = (org.hl7.fhir.r4.model.Practitioner)theBaseResource;
                if (theAllowOverwriting || person.getName().isEmpty()) {
                    person.setName(practitioner.getName());
                }
                if (theAllowOverwriting || person.getAddress().isEmpty()) {
                    person.setAddress(practitioner.getAddress());
                }
                if (theAllowOverwriting || person.getTelecom().isEmpty()) {
                    person.setTelecom(practitioner.getTelecom());
                }
                if (theAllowOverwriting || person.getBirthDate() == null) {
                    person.setBirthDate(practitioner.getBirthDate());
                }
                if (theAllowOverwriting || person.getGender() == null) {
                    person.setGender(practitioner.getGender());
                }
                if (!theAllowOverwriting && !person.getPhoto().isEmpty()) break;
                person.setPhoto(practitioner.getPhotoFirstRep());
                break;
            }
            default: {
                throw new UnsupportedOperationException("EMPI targets are limited to Practitioner/Patient. This is a : " + this.myFhirContext.getResourceType(theBaseResource));
            }
        }
    }

    private void copyDSTU3TargetInformation(IBaseResource theBaseResource, IBaseResource thePerson, boolean theAllowOverwriting) {
        Person person = (Person)thePerson;
        switch (this.myFhirContext.getResourceType(theBaseResource)) {
            case "Patient": {
                Patient patient = (Patient)theBaseResource;
                if (theAllowOverwriting || person.getName().isEmpty()) {
                    person.setName(patient.getName());
                }
                if (theAllowOverwriting || person.getAddress().isEmpty()) {
                    person.setAddress(patient.getAddress());
                }
                if (theAllowOverwriting || person.getTelecom().isEmpty()) {
                    person.setTelecom(patient.getTelecom());
                }
                if (theAllowOverwriting || person.getBirthDate() == null) {
                    person.setBirthDate(patient.getBirthDate());
                }
                if (theAllowOverwriting || person.getGender() == null) {
                    person.setGender(patient.getGender());
                }
                if (!theAllowOverwriting && !person.getPhoto().isEmpty()) break;
                person.setPhoto(patient.getPhotoFirstRep());
                break;
            }
            case "Practitioner": {
                Practitioner practitioner = (Practitioner)theBaseResource;
                if (theAllowOverwriting || person.getName().isEmpty()) {
                    person.setName(practitioner.getName());
                }
                if (theAllowOverwriting || person.getAddress().isEmpty()) {
                    person.setAddress(practitioner.getAddress());
                }
                if (theAllowOverwriting || person.getTelecom().isEmpty()) {
                    person.setTelecom(practitioner.getTelecom());
                }
                if (theAllowOverwriting || person.getBirthDate() == null) {
                    person.setBirthDate(practitioner.getBirthDate());
                }
                if (theAllowOverwriting || person.getGender() == null) {
                    person.setGender(practitioner.getGender());
                }
                if (!theAllowOverwriting && !person.getPhoto().isEmpty()) break;
                person.setPhoto(practitioner.getPhotoFirstRep());
                break;
            }
            default: {
                throw new UnsupportedOperationException("EMPI targets are limited to Practitioner/Patient. This is a : " + this.myFhirContext.getResourceType(theBaseResource));
            }
        }
    }

    private IBaseCoding buildEmpiManagedTag() {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R4: {
                Coding empiManagedCoding = new Coding();
                empiManagedCoding.setSystem("https://hapifhir.org/NamingSystem/managing-empi-system");
                empiManagedCoding.setCode("HAPI-EMPI");
                empiManagedCoding.setDisplay("This Person can only be modified by Smile CDR's EMPI system.");
                return empiManagedCoding;
            }
            case DSTU3: {
                org.hl7.fhir.dstu3.model.Coding empiManagedCodingDstu3 = new org.hl7.fhir.dstu3.model.Coding();
                empiManagedCodingDstu3.setSystem("https://hapifhir.org/NamingSystem/managing-empi-system");
                empiManagedCodingDstu3.setCode("HAPI-EMPI");
                empiManagedCodingDstu3.setDisplay("This Person can only be modified by Smile CDR's EMPI system.");
                return empiManagedCodingDstu3;
            }
        }
        throw new UnsupportedOperationException("Version not supported: " + this.myFhirContext.getVersion().getVersion());
    }

    public IAnyResource updatePersonExternalEidFromEmpiTarget(IAnyResource thePerson, IAnyResource theEmpiTarget, EmpiTransactionContext theEmpiTransactionContext) {
        List<CanonicalEID> incomingTargetEid = this.myEIDHelper.getExternalEid((IBaseResource)theEmpiTarget);
        List<CanonicalEID> personOfficialEid = this.myEIDHelper.getExternalEid((IBaseResource)thePerson);
        if (!incomingTargetEid.isEmpty()) {
            if (personOfficialEid.isEmpty() || !this.myEmpiConfig.isPreventMultipleEids()) {
                this.log(theEmpiTransactionContext, "Incoming resource:" + theEmpiTarget.getIdElement().toUnqualifiedVersionless() + " + with EID " + incomingTargetEid.stream().map(CanonicalEID::toString).collect(Collectors.joining(",")) + " is applying this EIDs to its related Person, as this person does not yet have an external EID");
                this.addCanonicalEidsToPersonIfAbsent((IBaseResource)thePerson, incomingTargetEid);
            } else if (!personOfficialEid.isEmpty() && this.myEIDHelper.eidMatchExists(personOfficialEid, incomingTargetEid)) {
                this.log(theEmpiTransactionContext, "incoming resource:" + theEmpiTarget.getIdElement().toVersionless() + " with EIDs " + incomingTargetEid.stream().map(CanonicalEID::toString).collect(Collectors.joining(",")) + " does not need to overwrite person, as this EID is already present");
            } else {
                throw new IllegalArgumentException("This would create a duplicate person!");
            }
        }
        return thePerson;
    }

    public IBaseResource overwriteExternalEids(IBaseResource thePerson, List<CanonicalEID> theNewEid) {
        this.clearExternalEids(thePerson);
        this.addCanonicalEidsToPersonIfAbsent(thePerson, theNewEid);
        return thePerson;
    }

    private void clearExternalEids(IBaseResource thePerson) {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R4: {
                org.hl7.fhir.r4.model.Person personR4 = (org.hl7.fhir.r4.model.Person)thePerson;
                personR4.getIdentifier().removeIf(theIdentifier -> theIdentifier.getSystem().equalsIgnoreCase(this.myEmpiConfig.getEmpiRules().getEnterpriseEIDSystem()));
                break;
            }
            case DSTU3: {
                Person personDstu3 = (Person)thePerson;
                personDstu3.getIdentifier().removeIf(theIdentifier -> theIdentifier.getSystem().equalsIgnoreCase(this.myEmpiConfig.getEmpiRules().getEnterpriseEIDSystem()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Version not supported: " + this.myFhirContext.getVersion().getVersion());
            }
        }
    }

    private void addCanonicalEidsToPersonIfAbsent(IBaseResource thePerson, List<CanonicalEID> theIncomingTargetEid) {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R4: {
                theIncomingTargetEid.forEach(eid -> this.addIdentifierIfAbsent((org.hl7.fhir.r4.model.Person)thePerson, eid.toR4()));
                break;
            }
            case DSTU3: {
                theIncomingTargetEid.forEach(eid -> this.addIdentifierIfAbsent((Person)thePerson, eid.toDSTU3()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Version not supported: " + this.myFhirContext.getVersion().getVersion());
            }
        }
    }

    private void addIdentifierIfAbsent(Person thePerson, Identifier theIdentifier) {
        Optional<Identifier> first = thePerson.getIdentifier().stream().filter(identifier -> identifier.getSystem().equals(theIdentifier.getSystem())).filter(identifier -> identifier.getValue().equals(theIdentifier.getValue())).findFirst();
        if (first.isPresent()) {
            return;
        }
        thePerson.addIdentifier(theIdentifier);
    }

    private void addIdentifierIfAbsent(org.hl7.fhir.r4.model.Person thePerson, org.hl7.fhir.r4.model.Identifier theIdentifier) {
        Optional<org.hl7.fhir.r4.model.Identifier> first = thePerson.getIdentifier().stream().filter(identifier -> identifier.getSystem().equals(theIdentifier.getSystem())).filter(identifier -> identifier.getValue().equals(theIdentifier.getValue())).findFirst();
        if (first.isPresent()) {
            return;
        }
        thePerson.addIdentifier(theIdentifier);
    }

    public void mergePersonFields(IBaseResource theFromPerson, IBaseResource theToPerson) {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R4: {
                this.mergeR4PersonFields(theFromPerson, theToPerson);
                break;
            }
            case DSTU3: {
                this.mergeDstu3PersonFields(theFromPerson, theToPerson);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Version not supported: " + this.myFhirContext.getVersion().getVersion());
            }
        }
    }

    private void mergeR4PersonFields(IBaseResource theFromPerson, IBaseResource theToPerson) {
        org.hl7.fhir.r4.model.Person fromPerson = (org.hl7.fhir.r4.model.Person)theFromPerson;
        org.hl7.fhir.r4.model.Person toPerson = (org.hl7.fhir.r4.model.Person)theToPerson;
        this.mergeElementList(fromPerson, toPerson, org.hl7.fhir.r4.model.HumanName.class, org.hl7.fhir.r4.model.Person::getName, org.hl7.fhir.r4.model.HumanName::equalsDeep);
        this.mergeElementList(fromPerson, toPerson, org.hl7.fhir.r4.model.Identifier.class, org.hl7.fhir.r4.model.Person::getIdentifier, org.hl7.fhir.r4.model.Identifier::equalsDeep);
        this.mergeElementList(fromPerson, toPerson, org.hl7.fhir.r4.model.Address.class, org.hl7.fhir.r4.model.Person::getAddress, org.hl7.fhir.r4.model.Address::equalsDeep);
        this.mergeElementList(fromPerson, toPerson, org.hl7.fhir.r4.model.ContactPoint.class, org.hl7.fhir.r4.model.Person::getTelecom, org.hl7.fhir.r4.model.ContactPoint::equalsDeep);
        if (!toPerson.hasBirthDate()) {
            toPerson.setBirthDate(fromPerson.getBirthDate());
        }
        if (!toPerson.hasGender()) {
            toPerson.setGender(fromPerson.getGender());
        }
        if (!toPerson.hasPhoto()) {
            toPerson.setPhoto(fromPerson.getPhoto());
        }
    }

    private <P, T> void mergeElementList(P fromPerson, P toPerson, Class<T> theBase, Function<P, List<T>> theGetList, BiPredicate<T, T> theEquals) {
        List<T> fromList = theGetList.apply(fromPerson);
        List<T> toList = theGetList.apply(toPerson);
        ArrayList<T> itemsToAdd = new ArrayList<T>();
        for (Object fromItem : fromList) {
            if (!toList.stream().noneMatch(t -> theEquals.test(fromItem, t))) continue;
            itemsToAdd.add(fromItem);
        }
        toList.addAll(itemsToAdd);
    }

    private void mergeDstu3PersonFields(IBaseResource theFromPerson, IBaseResource theToPerson) {
        Person fromPerson = (Person)theFromPerson;
        Person toPerson = (Person)theToPerson;
        this.mergeElementList(fromPerson, toPerson, HumanName.class, Person::getName, HumanName::equalsDeep);
        this.mergeElementList(fromPerson, toPerson, Identifier.class, Person::getIdentifier, Identifier::equalsDeep);
        this.mergeElementList(fromPerson, toPerson, Address.class, Person::getAddress, Address::equalsDeep);
        this.mergeElementList(fromPerson, toPerson, ContactPoint.class, Person::getTelecom, ContactPoint::equalsDeep);
        if (!toPerson.hasBirthDate()) {
            toPerson.setBirthDate(fromPerson.getBirthDate());
        }
        if (!toPerson.hasGender()) {
            toPerson.setGender(fromPerson.getGender());
        }
        if (!toPerson.hasPhoto()) {
            toPerson.setPhoto(fromPerson.getPhoto());
        }
    }

    public boolean isPotentialDuplicate(IAnyResource theExistingPerson, IAnyResource theComparingPerson) {
        List<CanonicalEID> externalEidsPerson = this.myEIDHelper.getExternalEid((IBaseResource)theExistingPerson);
        List<CanonicalEID> externalEidsResource = this.myEIDHelper.getExternalEid((IBaseResource)theComparingPerson);
        return !externalEidsPerson.isEmpty() && !externalEidsResource.isEmpty() && !this.myEIDHelper.eidMatchExists(externalEidsResource, externalEidsPerson);
    }

    public IBaseBackboneElement newPersonLink(IIdType theTargetId, CanonicalIdentityAssuranceLevel theAssuranceLevel) {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R4: {
                return this.newR4PersonLink(theTargetId, theAssuranceLevel);
            }
            case DSTU3: {
                return this.newDstu3PersonLink(theTargetId, theAssuranceLevel);
            }
        }
        throw new UnsupportedOperationException("Version not supported: " + this.myFhirContext.getVersion().getVersion());
    }

    private IBaseBackboneElement newR4PersonLink(IIdType theTargetId, CanonicalIdentityAssuranceLevel theAssuranceLevel) {
        Person.PersonLinkComponent retval = new Person.PersonLinkComponent();
        retval.setTarget(new Reference(theTargetId));
        retval.setAssurance(theAssuranceLevel.toR4());
        return retval;
    }

    private IBaseBackboneElement newDstu3PersonLink(IIdType theTargetId, CanonicalIdentityAssuranceLevel theAssuranceLevel) {
        Person.PersonLinkComponent retval = new Person.PersonLinkComponent();
        retval.setTarget(new org.hl7.fhir.dstu3.model.Reference(theTargetId));
        retval.setAssurance(theAssuranceLevel.toDstu3());
        return retval;
    }

    public void setLinks(IAnyResource thePersonResource, List<IBaseBackboneElement> theNewLinks) {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R4: {
                this.setLinksR4(thePersonResource, theNewLinks);
                break;
            }
            case DSTU3: {
                this.setLinksDstu3(thePersonResource, theNewLinks);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Version not supported: " + this.myFhirContext.getVersion().getVersion());
            }
        }
    }

    private void setLinksDstu3(IAnyResource thePersonResource, List<IBaseBackboneElement> theLinks) {
        Person person = (Person)thePersonResource;
        List<IBaseBackboneElement> links = theLinks;
        person.setLink(links);
    }

    private void setLinksR4(IAnyResource thePersonResource, List<IBaseBackboneElement> theLinks) {
        org.hl7.fhir.r4.model.Person person = (org.hl7.fhir.r4.model.Person)thePersonResource;
        List<IBaseBackboneElement> links = theLinks;
        person.setLink(links);
    }

    public void updatePersonFromNewlyCreatedEmpiTarget(IBaseResource thePerson, IBaseResource theResource, EmpiTransactionContext theEmpiTransactionContext) {
        this.copyEmpiTargetDataIntoPerson(theResource, thePerson, false);
    }

    public void updatePersonFromUpdatedEmpiTarget(IBaseResource thePerson, IBaseResource theResource, EmpiTransactionContext theEmpiTransactionContext) {
        this.copyEmpiTargetDataIntoPerson(theResource, thePerson, true);
    }

    public int getLinkCount(IAnyResource thePerson) {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R4: {
                org.hl7.fhir.r4.model.Person personR4 = (org.hl7.fhir.r4.model.Person)thePerson;
                return personR4.getLink().size();
            }
            case DSTU3: {
                Person personStu3 = (Person)thePerson;
                return personStu3.getLink().size();
            }
        }
        throw new UnsupportedOperationException("Version not supported: " + this.myFhirContext.getVersion().getVersion());
    }

    private void log(EmpiTransactionContext theEmpiTransactionContext, String theMessage) {
        theEmpiTransactionContext.addTransactionLogMessage(theMessage);
        ourLog.debug(theMessage);
    }

    public void handleExternalEidAddition(IAnyResource thePerson, IAnyResource theResource, EmpiTransactionContext theEmpiTransactionContext) {
        List<CanonicalEID> eidFromResource = this.myEIDHelper.getExternalEid((IBaseResource)theResource);
        if (!eidFromResource.isEmpty()) {
            this.updatePersonExternalEidFromEmpiTarget(thePerson, theResource, theEmpiTransactionContext);
        }
    }

    public void deactivatePerson(IAnyResource thePerson) {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R4: {
                org.hl7.fhir.r4.model.Person personR4 = (org.hl7.fhir.r4.model.Person)thePerson;
                personR4.setActive(false);
                break;
            }
            case DSTU3: {
                Person personStu3 = (Person)thePerson;
                personStu3.setActive(false);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Version not supported: " + this.myFhirContext.getVersion().getVersion());
            }
        }
    }

    public boolean isDeactivated(IBaseResource thePerson) {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R4: {
                org.hl7.fhir.r4.model.Person personR4 = (org.hl7.fhir.r4.model.Person)thePerson;
                return !personR4.getActive();
            }
            case DSTU3: {
                Person personStu3 = (Person)thePerson;
                return !personStu3.getActive();
            }
        }
        throw new UnsupportedOperationException("Version not supported: " + this.myFhirContext.getVersion().getVersion());
    }
}

