/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate;

import ca.uhn.fhir.jpa.migrate.MigrationTaskSkipper;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.flywaydb.core.api.MigrationVersion;

public class MigrationTaskList
implements Iterable<BaseTask> {
    private final List<BaseTask> myTasks;

    public MigrationTaskList() {
        this.myTasks = new ArrayList<BaseTask>();
    }

    public MigrationTaskList(List<BaseTask> theTasks) {
        this.myTasks = theTasks;
    }

    public void addAll(Collection<BaseTask> theTasks) {
        this.myTasks.addAll(theTasks);
    }

    public void setDoNothingOnSkippedTasks(String theSkipVersions) {
        MigrationTaskSkipper.setDoNothingOnSkippedTasks(this.myTasks, theSkipVersions);
    }

    public int size() {
        return this.myTasks.size();
    }

    public MigrationTaskList diff(Set<MigrationVersion> theAppliedMigrationVersions) {
        List<BaseTask> unappliedTasks = this.myTasks.stream().filter(task -> !theAppliedMigrationVersions.contains(MigrationVersion.fromVersion((String)task.getMigrationVersion()))).collect(Collectors.toList());
        return new MigrationTaskList(unappliedTasks);
    }

    public void append(Iterable<BaseTask> theMigrationTasks) {
        for (BaseTask next : theMigrationTasks) {
            this.myTasks.add(next);
        }
    }

    public void add(BaseTask theTask) {
        this.myTasks.add(theTask);
    }

    public void clear() {
        this.myTasks.clear();
    }

    @Override
    @Nonnull
    public Iterator<BaseTask> iterator() {
        return this.myTasks.iterator();
    }

    @Override
    public void forEach(Consumer<? super BaseTask> theAction) {
        this.myTasks.forEach(theAction);
    }

    public String getLastVersion() {
        return this.myTasks.stream().map(BaseTask::getMigrationVersion).map(MigrationVersion::fromVersion).sorted().map(MigrationVersion::toString).reduce((first, second) -> second).orElse(null);
    }
}

