/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.HapiMigrationStorageSvc;
import ca.uhn.fhir.jpa.migrate.HapiMigrator;
import ca.uhn.fhir.jpa.migrate.IHapiMigrationCallback;
import ca.uhn.fhir.jpa.migrate.MigrationResult;
import ca.uhn.fhir.jpa.migrate.MigrationTaskList;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaMigrator {
    public static final String HAPI_FHIR_MIGRATION_TABLENAME = "FLY_HFJ_MIGRATION";
    private static final Logger ourLog = LoggerFactory.getLogger(SchemaMigrator.class);
    private final String mySchemaName;
    private final DataSource myDataSource;
    private final boolean mySkipValidation;
    private final String myMigrationTableName;
    private final MigrationTaskList myMigrationTasks;
    private DriverTypeEnum myDriverType;
    private List<IHapiMigrationCallback> myCallbacks = Collections.emptyList();
    private final HapiMigrationStorageSvc myHapiMigrationStorageSvc;

    public SchemaMigrator(String theSchemaName, String theMigrationTableName, DataSource theDataSource, Properties jpaProperties, MigrationTaskList theMigrationTasks, HapiMigrationStorageSvc theHapiMigrationStorageSvc) {
        this.mySchemaName = theSchemaName;
        this.myDataSource = theDataSource;
        this.myMigrationTableName = theMigrationTableName;
        this.myMigrationTasks = theMigrationTasks;
        this.mySkipValidation = jpaProperties.containsKey("hibernate.hbm2ddl.auto") && "update".equals(jpaProperties.getProperty("hibernate.hbm2ddl.auto"));
        this.myHapiMigrationStorageSvc = theHapiMigrationStorageSvc;
    }

    public void validate() {
        if (this.mySkipValidation) {
            ourLog.warn("Database running in hibernate auto-update mode.  Skipping schema validation.");
            return;
        }
        try (Connection connection = this.myDataSource.getConnection();){
            MigrationTaskList unappliedMigrations = this.myHapiMigrationStorageSvc.diff(this.myMigrationTasks);
            if (unappliedMigrations.size() > 0) {
                String url = connection.getMetaData().getURL();
                throw new ConfigurationException(Msg.code((int)27) + "The database schema for " + url + " is out of date.  Current database schema version is " + this.myHapiMigrationStorageSvc.getLatestAppliedVersion() + ".  Schema version required by application is " + unappliedMigrations.getLastVersion() + ".  Please run the database migrator.");
            }
            ourLog.info("Database schema confirmed at expected version " + this.myHapiMigrationStorageSvc.getLatestAppliedVersion());
        }
        catch (SQLException e) {
            throw new ConfigurationException(Msg.code((int)28) + "Unable to connect to " + this.myDataSource, (Throwable)e);
        }
    }

    public MigrationResult migrate() {
        if (this.mySkipValidation) {
            ourLog.warn("Database running in hibernate auto-update mode.  Skipping schema migration.");
            return null;
        }
        try {
            ourLog.info("Migrating " + this.mySchemaName);
            MigrationResult retval = this.newMigrator().migrate();
            ourLog.info(this.mySchemaName + " migrated successfully: {}", (Object)retval.summary());
            return retval;
        }
        catch (Exception e) {
            ourLog.error("Failed to migrate " + this.mySchemaName, (Throwable)e);
            throw e;
        }
    }

    private HapiMigrator newMigrator() {
        HapiMigrator migrator = new HapiMigrator(this.myMigrationTableName, this.myDataSource, this.myDriverType);
        migrator.addTasks(this.myMigrationTasks);
        migrator.setCallbacks(this.myCallbacks);
        return migrator;
    }

    public void setDriverType(DriverTypeEnum theDriverType) {
        this.myDriverType = theDriverType;
    }

    public void setCallbacks(List<IHapiMigrationCallback> theCallbacks) {
        this.myCallbacks = theCallbacks;
    }

    public boolean createMigrationTableIfRequired() {
        return this.myHapiMigrationStorageSvc.createMigrationTableIfRequired();
    }
}

