/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableColumnTypeTask;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnDriverMappingOverride;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnNameCase;
import java.sql.SQLException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddColumnTask
extends BaseTableColumnTypeTask {
    private static final Logger ourLog = LoggerFactory.getLogger(AddColumnTask.class);

    public static AddColumnTask lowerCase(Set<ColumnDriverMappingOverride> theColumnDriverMappingOverrides) {
        return new AddColumnTask(null, null, ColumnNameCase.ALL_LOWER, theColumnDriverMappingOverrides);
    }

    public AddColumnTask() {
        this(null, null);
        this.setDryRun(true);
        this.myCheckForExistingTables = false;
    }

    public AddColumnTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    private AddColumnTask(String theProductVersion, String theSchemaVersion, ColumnNameCase theColumnNameCase, Set<ColumnDriverMappingOverride> theColumnDriverMappingOverrides) {
        super(theProductVersion, theSchemaVersion, theColumnNameCase, theColumnDriverMappingOverrides);
    }

    @Override
    public void validate() {
        super.validate();
        this.setDescription("Add column " + this.getColumnName() + " on table " + this.getTableName());
    }

    @Override
    public void doExecute() throws SQLException {
        String sql;
        Set<String> columnNames;
        if (this.myCheckForExistingTables && (columnNames = JdbcUtils.getColumnNames(this.getConnectionProperties(), this.getTableName())).contains(this.getColumnName())) {
            this.logInfo(ourLog, "Column {} already exists on table {} - No action performed", this.getColumnName(), this.getTableName());
            return;
        }
        String typeStatement = this.getTypeStatement();
        switch (this.getDriverType()) {
            case MYSQL_5_7: 
            case MARIADB_10_1: {
                sql = "alter table " + this.getTableName() + " add column `" + this.getColumnName() + "` " + typeStatement;
                break;
            }
            case DERBY_EMBEDDED: 
            case POSTGRES_9_4: {
                sql = "alter table " + this.getTableName() + " add column " + this.getColumnName() + " " + typeStatement;
                break;
            }
            case MSSQL_2012: 
            case ORACLE_12C: 
            case H2_EMBEDDED: {
                sql = "alter table " + this.getTableName() + " add " + this.getColumnName() + " " + typeStatement;
                break;
            }
            default: {
                throw new IllegalStateException(Msg.code((int)60));
            }
        }
        this.logInfo(ourLog, "Adding column {} of type {} to table {}", this.getColumnName(), this.getSqlType(), this.getTableName());
        this.executeSql(this.getTableName(), sql, new Object[0]);
    }

    public String getTypeStatement() {
        String type = this.getSqlType();
        String nullable = this.getSqlNotNull();
        if (this.isNullable()) {
            nullable = "";
        }
        if (this.myPrettyPrint) {
            nullable = nullable.trim();
        }
        String space = this.isNullable() ? "" : " ";
        return type + space + nullable;
    }
}

