/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseColumnCalculatorTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnDriverMappingOverride;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnNameCase;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class BaseTableColumnTask
extends BaseTableTask {
    protected Map<String, Function<BaseColumnCalculatorTask.MandatoryKeyMap<String, Object>, Object>> myCalculators = new HashMap<String, Function<BaseColumnCalculatorTask.MandatoryKeyMap<String, Object>, Object>>();
    protected String myColumnName;
    protected String myWhereClause;
    private final ColumnNameCase myColumnNameCase;

    public BaseTableColumnTask(String theProductVersion, String theSchemaVersion) {
        this(theProductVersion, theSchemaVersion, ColumnNameCase.ALL_UPPER, Collections.emptySet());
    }

    BaseTableColumnTask(String theProductVersion, String theSchemaVersion, ColumnNameCase theColumnNameCase, Set<ColumnDriverMappingOverride> theColumnDriverMappingOverrides) {
        super(theProductVersion, theSchemaVersion, theColumnDriverMappingOverrides);
        this.myColumnNameCase = theColumnNameCase;
    }

    public String getColumnName() {
        return this.myColumnName;
    }

    public BaseTableColumnTask setColumnName(String theColumnName) {
        switch (this.myColumnNameCase) {
            case ALL_UPPER: {
                this.myColumnName = theColumnName.toUpperCase();
                break;
            }
            case ALL_LOWER: {
                this.myColumnName = theColumnName.toLowerCase();
                break;
            }
            default: {
                throw new IllegalArgumentException(Msg.code((int)2448) + " Unknown ColumnNameCase was passed when setting column name case: " + this.myColumnNameCase);
            }
        }
        return this;
    }

    protected String getWhereClause() {
        if (this.myWhereClause == null) {
            return this.getColumnName() + " IS NULL";
        }
        return this.myWhereClause;
    }

    protected void setWhereClause(String theWhereClause) {
        this.myWhereClause = theWhereClause;
    }

    @Override
    public void validate() {
        super.validate();
        Validate.notBlank((CharSequence)this.myColumnName, (String)"Column name not specified", (Object[])new Object[0]);
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        BaseTableColumnTask otherObject = (BaseTableColumnTask)theOtherObject;
        super.generateEquals(theBuilder, otherObject);
        theBuilder.append((Object)this.myColumnName, (Object)otherObject.myColumnName);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append((Object)this.myColumnName);
    }

    public BaseTableColumnTask addCalculator(String theColumnName, Function<BaseColumnCalculatorTask.MandatoryKeyMap<String, Object>, Object> theConsumer) {
        Validate.isTrue((!this.myCalculators.containsKey(theColumnName) ? 1 : 0) != 0);
        this.myCalculators.put(theColumnName, theConsumer);
        return this;
    }
}

