/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableColumnTypeTask;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.RowMapper;

public class ModifyColumnTask
extends BaseTableColumnTypeTask {
    private static final Logger ourLog = LoggerFactory.getLogger(ModifyColumnTask.class);

    public ModifyColumnTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    @Override
    public void validate() {
        super.validate();
        this.setDescription("Modify column " + this.getColumnName() + " on table " + this.getTableName());
    }

    @Override
    public void doExecute() throws SQLException {
        boolean alreadyCorrectNullable;
        boolean nullable;
        JdbcUtils.ColumnType existingType;
        Set<String> columnNames = JdbcUtils.getColumnNames(this.getConnectionProperties(), this.getTableName());
        if (!columnNames.contains(this.getColumnName())) {
            this.logInfo(ourLog, "Column {} doesn't exist on table {} - No action performed", this.getColumnName(), this.getTableName());
            return;
        }
        try {
            existingType = JdbcUtils.getColumnType(this.getConnectionProperties(), this.getTableName(), this.getColumnName());
            nullable = this.isColumnNullable(this.getTableName(), this.getColumnName());
        }
        catch (SQLException e) {
            throw new InternalErrorException(Msg.code((int)66) + e);
        }
        Long taskColumnLength = this.getColumnLength();
        boolean isShrinkOnly = false;
        if (taskColumnLength != null) {
            long existingLength;
            long l = existingLength = existingType.getLength() != null ? existingType.getLength() : 0L;
            if (existingLength > taskColumnLength) {
                if (this.isNoColumnShrink()) {
                    taskColumnLength = existingLength;
                } else if (existingType.getColumnTypeEnum() == this.getColumnType()) {
                    isShrinkOnly = true;
                }
            }
        }
        boolean alreadyOfCorrectType = existingType.equals(this.getColumnType(), taskColumnLength);
        boolean bl = alreadyCorrectNullable = this.isNullable() == nullable;
        if (alreadyOfCorrectType && alreadyCorrectNullable) {
            this.logInfo(ourLog, "Column {} on table {} is already of type {} and has nullable {} - No action performed", this.getColumnName(), this.getTableName(), existingType, nullable);
            return;
        }
        String type = this.getSqlType(taskColumnLength);
        String notNull = this.getSqlNotNull();
        String sql = null;
        String sqlNotNull = null;
        switch (this.getDriverType()) {
            case DERBY_EMBEDDED: {
                if (!alreadyOfCorrectType) {
                    sql = "alter table " + this.getTableName() + " alter column " + this.getColumnName() + " set data type " + type;
                }
                if (alreadyCorrectNullable) break;
                sqlNotNull = "alter table " + this.getTableName() + " alter column " + this.getColumnName() + notNull;
                break;
            }
            case MARIADB_10_1: 
            case MYSQL_5_7: {
                sql = "alter table " + this.getTableName() + " modify column `" + this.getColumnName() + "` " + type + notNull;
                break;
            }
            case POSTGRES_9_4: 
            case COCKROACHDB_21_1: {
                if (!alreadyOfCorrectType) {
                    sql = "alter table " + this.getTableName() + " alter column " + this.getColumnName() + " type " + type;
                }
                if (alreadyCorrectNullable) break;
                if (this.isNullable()) {
                    sqlNotNull = "alter table " + this.getTableName() + " alter column " + this.getColumnName() + " drop not null";
                    break;
                }
                sqlNotNull = "alter table " + this.getTableName() + " alter column " + this.getColumnName() + " set not null";
                break;
            }
            case ORACLE_12C: {
                String oracleNullableStmt = alreadyCorrectNullable ? "" : notNull;
                String oracleTypeStmt = alreadyOfCorrectType ? "" : type;
                sql = "alter table " + this.getTableName() + " modify ( " + this.getColumnName() + " " + oracleTypeStmt + " " + oracleNullableStmt + " )";
                break;
            }
            case MSSQL_2012: {
                sql = "alter table " + this.getTableName() + " alter column " + this.getColumnName() + " " + type + notNull;
                break;
            }
            case H2_EMBEDDED: {
                if (!alreadyOfCorrectType) {
                    sql = "alter table " + this.getTableName() + " alter column " + this.getColumnName() + " type " + type;
                }
                if (alreadyCorrectNullable) break;
                if (this.isNullable()) {
                    sqlNotNull = "alter table " + this.getTableName() + " alter column " + this.getColumnName() + " drop not null";
                    break;
                }
                sqlNotNull = "alter table " + this.getTableName() + " alter column " + this.getColumnName() + " set not null";
                break;
            }
            default: {
                throw new IllegalStateException(Msg.code((int)67) + "Dont know how to handle " + this.getDriverType());
            }
        }
        if (!this.isFailureAllowed() && isShrinkOnly) {
            this.setFailureAllowed(true);
        }
        this.logInfo(ourLog, "Updating column {} on table {} to type {}", this.getColumnName(), this.getTableName(), type);
        if (sql != null) {
            this.executeSql(this.getTableName(), sql, new Object[0]);
        }
        if (sqlNotNull != null) {
            this.logInfo(ourLog, "Updating column {} on table {} to not null", this.getColumnName(), this.getTableName());
            this.executeSql(this.getTableName(), sqlNotNull, new Object[0]);
        }
    }

    private boolean isColumnNullable(String tableName, String columnName) throws SQLException {
        boolean result = JdbcUtils.isColumnNullable(this.getConnectionProperties(), tableName, columnName);
        switch (this.getDriverType()) {
            case ORACLE_12C: {
                String findNullableConstraintSql = "SELECT acc.owner, acc.table_name, acc.column_name, search_condition_vc FROM all_cons_columns acc, user_constraints uc WHERE acc.constraint_name = uc.constraint_name AND acc.table_name = uc.table_name AND uc.constraint_type = ? AND acc.table_name = ? AND acc.column_name = ? AND search_condition_vc = ? ";
                String[] params = new String[]{"C", tableName.toUpperCase(), columnName.toUpperCase(), "\"" + columnName.toUpperCase() + "\" IS NOT NULL"};
                List queryResults = (List)this.getConnectionProperties().getTxTemplate().execute(t -> this.getConnectionProperties().newJdbcTemplate().query(findNullableConstraintSql, (Object[])params, (RowMapper)new ColumnMapRowMapper()));
                if (queryResults == null || queryResults.size() <= 0 || queryResults.get(0) == null || ((Map)queryResults.get(0)).isEmpty()) break;
                result = false;
                break;
            }
        }
        return result;
    }
}

