/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameIndexTask
extends BaseTableTask {
    private static final Logger ourLog = LoggerFactory.getLogger(RenameIndexTask.class);
    private String myOldIndexName;
    private String myNewIndexName;

    public RenameIndexTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    static List<String> createRenameIndexSql(DriverTypeEnum.ConnectionProperties theConnectionProperties, String theTableName, String theOldIndexName, String theNewIndexName, DriverTypeEnum theDriverType) throws SQLException {
        Validate.notBlank((CharSequence)theOldIndexName, (String)"theOldIndexName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)theNewIndexName, (String)"theNewIndexName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)theTableName, (String)"theTableName must not be blank", (Object[])new Object[0]);
        if (!JdbcUtils.getIndexNames(theConnectionProperties, theTableName).contains(theOldIndexName)) {
            return Collections.emptyList();
        }
        ArrayList<String> sql = new ArrayList<String>();
        switch (theDriverType) {
            case MYSQL_5_7: 
            case MARIADB_10_1: {
                sql.add("rename index `" + theOldIndexName + "` to `" + theNewIndexName + "`");
                break;
            }
            case DERBY_EMBEDDED: {
                sql.add("rename index " + theOldIndexName + " to " + theNewIndexName);
                break;
            }
            case H2_EMBEDDED: 
            case POSTGRES_9_4: 
            case ORACLE_12C: 
            case COCKROACHDB_21_1: {
                sql.add("alter index " + theOldIndexName + " rename to " + theNewIndexName);
                break;
            }
            case MSSQL_2012: {
                sql.add("EXEC sp_rename '" + theTableName + "." + theOldIndexName + "', '" + theNewIndexName + "'");
            }
        }
        return sql;
    }

    @Override
    public void validate() {
        super.validate();
        Validate.notBlank((CharSequence)this.myOldIndexName, (String)"The old index name must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.myNewIndexName, (String)"The new index name must not be blank", (Object[])new Object[0]);
        this.setDescription("Rename index from " + this.myOldIndexName + " to " + this.myNewIndexName + " on table " + this.getTableName());
    }

    @Override
    public void doExecute() throws SQLException {
        Set<String> indexNames = JdbcUtils.getIndexNames(this.getConnectionProperties(), this.getTableName());
        if (!indexNames.contains(this.myOldIndexName)) {
            this.logInfo(ourLog, "Index {} does not exist on table {} - No action needed", this.myOldIndexName, this.getTableName());
            return;
        }
        List<String> sqls = RenameIndexTask.createRenameIndexSql(this.getConnectionProperties(), this.getTableName(), this.myOldIndexName, this.myNewIndexName, this.getDriverType());
        if (!sqls.isEmpty()) {
            this.logInfo(ourLog, "Renaming index from {} to {} on table {}", this.myOldIndexName, this.myNewIndexName, this.getTableName());
        }
        for (String sql : sqls) {
            this.executeSql(this.getTableName(), sql, new Object[0]);
        }
    }

    public RenameIndexTask setNewIndexName(String theNewIndexName) {
        this.myNewIndexName = theNewIndexName;
        return this;
    }

    public RenameIndexTask setOldIndexName(String theOldIndexName) {
        this.myOldIndexName = theOldIndexName;
        return this;
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        RenameIndexTask otherObject = (RenameIndexTask)theOtherObject;
        super.generateEquals(theBuilder, otherObject);
        theBuilder.append((Object)this.myOldIndexName, (Object)otherObject.myOldIndexName);
        theBuilder.append((Object)this.myNewIndexName, (Object)otherObject.myNewIndexName);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append((Object)this.myOldIndexName);
        theBuilder.append((Object)this.myNewIndexName);
    }
}

