/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.AddColumnTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.jpa.migrate.taskdef.ForeignKeyContainer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddTableByColumnTask
extends BaseTableTask {
    private static final Logger ourLog = LoggerFactory.getLogger(AddTableByColumnTask.class);
    private final List<AddColumnTask> myAddColumnTasks = new ArrayList<AddColumnTask>();
    private List<String> myPkColumns;
    private final List<ForeignKeyContainer> myFKColumns = new ArrayList<ForeignKeyContainer>();
    private final Comparator<AddColumnTask> myColumnSortingRules;

    public AddTableByColumnTask() {
        this(null);
    }

    public AddTableByColumnTask(Comparator<AddColumnTask> theColumnSortingRules) {
        this(null, null, theColumnSortingRules);
        this.setDryRun(true);
        this.myCheckForExistingTables = false;
    }

    public AddTableByColumnTask(String theProductVersion, String theSchemaVersion) {
        this(theProductVersion, theSchemaVersion, (Comparator<AddColumnTask>)null);
    }

    public AddTableByColumnTask(String theProductVersion, String theSchemaVersion, Comparator<AddColumnTask> theColumnSortingRules) {
        super(theProductVersion, theSchemaVersion);
        this.myColumnSortingRules = theColumnSortingRules;
    }

    @Override
    public void validate() {
        super.validate();
        this.setDescription("Add table " + this.getTableName());
    }

    public void addAddColumnTask(AddColumnTask theTask) {
        Validate.notNull((Object)theTask);
        this.myAddColumnTasks.add(theTask);
    }

    public void setPkColumns(List<String> thePkColumns) {
        this.myPkColumns = thePkColumns;
    }

    public void addForeignKey(ForeignKeyContainer theForeignKeyContainer) {
        this.myFKColumns.add(theForeignKeyContainer);
    }

    public List<String> getPkColumns() {
        return this.myPkColumns;
    }

    public String generateSQLCreateScript() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(this.getTableName());
        sb.append(" (");
        if (this.myPrettyPrint) {
            sb.append("\n");
        } else {
            sb.append(" ");
        }
        for (AddColumnTask next : this.getOrderedAddColumnTasks()) {
            next.setDriverType(this.getDriverType());
            next.setTableName(this.getTableName());
            next.validate();
            if (this.myPrettyPrint) {
                sb.append("\t");
            }
            sb.append(next.getColumnName());
            sb.append(" ");
            sb.append(next.getTypeStatement());
            sb.append(",");
            if (this.myPrettyPrint) {
                sb.append("\n");
                continue;
            }
            sb.append(" ");
        }
        if (this.myPrettyPrint) {
            sb.append("\t");
        } else {
            sb.append(" ");
        }
        sb.append("PRIMARY KEY (");
        for (int i = 0; i < this.myPkColumns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.myPkColumns.get(i));
        }
        boolean hasForeignKeys = !this.myFKColumns.isEmpty();
        sb.append(")");
        if (hasForeignKeys) {
            sb.append(",");
        }
        if (this.myPrettyPrint) {
            sb.append("\n");
        } else {
            sb.append(" ");
        }
        DriverTypeEnum sqlEngine = this.getDriverType();
        if (!this.myFKColumns.isEmpty()) {
            for (int i = 0; i < this.myFKColumns.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                ForeignKeyContainer fk = this.myFKColumns.get(i);
                if (this.myPrettyPrint) {
                    sb.append("\t");
                }
                sb.append(fk.generateSQL(sqlEngine, this.myPrettyPrint));
                if (this.myPrettyPrint) {
                    sb.append("\n");
                    continue;
                }
                sb.append(" ");
            }
        }
        sb.append(")");
        switch (sqlEngine) {
            case MARIADB_10_1: 
            case MYSQL_5_7: {
                sb.append(" engine=InnoDB");
                break;
            }
        }
        return sb.toString();
    }

    @Override
    public void doExecute() throws SQLException {
        if (this.myCheckForExistingTables && JdbcUtils.getTableNames(this.getConnectionProperties()).contains(this.getTableName())) {
            this.logInfo(ourLog, "Already have table named {} - No action performed", this.getTableName());
            return;
        }
        this.executeSql(this.getTableName(), this.generateSQLCreateScript(), new Object[0]);
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        super.generateEquals(theBuilder, theOtherObject);
        AddTableByColumnTask otherObject = (AddTableByColumnTask)theOtherObject;
        theBuilder.append(this.myAddColumnTasks, otherObject.myAddColumnTasks);
        theBuilder.append(this.myPkColumns, otherObject.myPkColumns);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append(this.myAddColumnTasks);
        theBuilder.append(this.myPkColumns);
    }

    private List<AddColumnTask> getOrderedAddColumnTasks() {
        if (this.myColumnSortingRules == null) {
            return this.myAddColumnTasks;
        }
        return this.myAddColumnTasks.stream().sorted(this.myColumnSortingRules).collect(Collectors.toUnmodifiableList());
    }
}

