/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;

public class MetadataSource {
    public boolean isOnlineIndexSupported(DriverTypeEnum.ConnectionProperties theConnectionProperties) {
        switch (theConnectionProperties.getDriverType()) {
            case POSTGRES_9_4: 
            case COCKROACHDB_21_1: {
                return true;
            }
            case MSSQL_2012: {
                String mssqlEdition = this.getEdition(theConnectionProperties);
                return mssqlEdition == null || !mssqlEdition.startsWith("Standard Edition");
            }
            case ORACLE_12C: {
                String oracleEdition = this.getEdition(theConnectionProperties);
                return oracleEdition == null || oracleEdition.contains("Enterprise");
            }
        }
        return false;
    }

    private String getEdition(DriverTypeEnum.ConnectionProperties theConnectionProperties) {
        String result;
        if (theConnectionProperties.getDriverType() == DriverTypeEnum.MSSQL_2012) {
            result = (String)theConnectionProperties.newJdbcTemplate().queryForObject("SELECT SERVERPROPERTY ('edition')", String.class);
        } else if (theConnectionProperties.getDriverType() == DriverTypeEnum.ORACLE_12C) {
            result = (String)theConnectionProperties.newJdbcTemplate().queryForObject("SELECT BANNER FROM v$version WHERE banner LIKE 'Oracle%'", String.class);
        } else {
            throw new UnsupportedOperationException(Msg.code((int)2084) + "We only know about MSSQL editions.");
        }
        return result;
    }
}

