/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.interceptor;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.interceptor.IMdmStorageInterceptor;
import ca.uhn.fhir.mdm.interceptor.MdmSearchExpandingInterceptor;
import ca.uhn.fhir.mdm.log.Logs;
import jakarta.annotation.PostConstruct;
import org.hl7.fhir.dstu2.model.Subscription;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class MdmSubmitterInterceptorLoader {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private IMdmSettings myMdmSettings;
    @Autowired
    JpaStorageSettings myStorageSettings;
    @Autowired(required=false)
    private IMdmStorageInterceptor myMdmStorageInterceptor;
    @Autowired
    private MdmSearchExpandingInterceptor myMdmSearchExpandingInterceptorInterceptor;
    @Autowired
    private IInterceptorService myInterceptorService;

    @PostConstruct
    public void loadInterceptors() {
        if (!this.myMdmSettings.isEnabled()) {
            return;
        }
        if (!this.myStorageSettings.getSupportedSubscriptionTypes().contains(Subscription.SubscriptionChannelType.MESSAGE)) {
            throw new ConfigurationException(Msg.code((int)2421) + "MDM requires Message Subscriptions to be enabled in the Storage Settings");
        }
        if (this.myMdmStorageInterceptor != null) {
            this.myInterceptorService.registerInterceptor((Object)this.myMdmStorageInterceptor);
        }
        this.myInterceptorService.registerInterceptor((Object)this.myMdmSearchExpandingInterceptorInterceptor);
        ourLog.info("MDM interceptors registered");
    }
}

