/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.batch2.submit;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.jobs.chunk.ResourceIdListWorkChunkJson;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.mdm.api.IMdmChannelSubmitterSvc;
import ca.uhn.fhir.mdm.batch2.submit.MdmSubmitJobParameters;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.interceptor.ResponseTerminologyTranslationSvc;
import ca.uhn.fhir.util.Logs;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class MdmInflateAndSubmitResourcesStep
implements IJobStepWorker<MdmSubmitJobParameters, ResourceIdListWorkChunkJson, VoidModel> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired(required=false)
    private ResponseTerminologyTranslationSvc myResponseTerminologyTranslationSvc;
    @Autowired
    private IMdmChannelSubmitterSvc myMdmChannelSubmitterSvc;
    @Autowired
    private IIdHelperService<? extends IResourcePersistentId> myIdHelperService;

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<MdmSubmitJobParameters, ResourceIdListWorkChunkJson> theStepExecutionDetails, @Nonnull IJobDataSink<VoidModel> theDataSink) throws JobExecutionFailedException {
        ResourceIdListWorkChunkJson idList = (ResourceIdListWorkChunkJson)theStepExecutionDetails.getData();
        ourLog.info("Final Step  for $mdm-submit - Expand and submit resources");
        ourLog.info("About to expand {} resource IDs into their full resource bodies.", (Object)idList.getResourcePersistentIds(this.myIdHelperService).size());
        List<IBaseResource> allResources = this.fetchAllResources(idList.getResourcePersistentIds(this.myIdHelperService));
        if (this.myResponseTerminologyTranslationSvc != null) {
            this.myResponseTerminologyTranslationSvc.processResourcesForTerminologyTranslation(allResources);
        }
        for (IBaseResource nextResource : allResources) {
            this.myMdmChannelSubmitterSvc.submitResourceToMdmChannel(nextResource);
        }
        ourLog.info("Expanding of {} resources of type completed", (Object)idList.size());
        return new RunOutcome(allResources.size());
    }

    private List<IBaseResource> fetchAllResources(List<? extends IResourcePersistentId> theIds) {
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>();
        for (IResourcePersistentId iResourcePersistentId : theIds) {
            assert (iResourcePersistentId.getResourceType() != null);
            IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(iResourcePersistentId.getResourceType());
            try {
                resources.add(dao.readByPid(iResourcePersistentId));
            }
            catch (ResourceNotFoundException e) {
                ourLog.warn("While attempging to send [{}] to the MDM queue, the resource was not found.", (Object)iResourcePersistentId);
            }
        }
        return resources;
    }
}

