/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import org.hl7.fhir.utilities.Utilities;

public class ElementDecoration {
    private DecorationType type;
    private String link;
    private String text;

    public ElementDecoration(DecorationType type, String link, String text) {
        this.type = type;
        this.link = link;
        this.text = text;
    }

    public DecorationType getType() {
        return this.type;
    }

    public boolean hasLink() {
        return !Utilities.noString(this.link);
    }

    public String getLink() {
        return this.link;
    }

    public String getText() {
        return this.text;
    }

    public String getIcon() {
        switch (this.type) {
            case SLICE: {
                return "icon_slice.png";
            }
            case TYPE: {
                return "icon_element.gif";
            }
            case HINT: {
                return "icon-hint.png";
            }
            case ERROR: {
                return "icon-wanning.png";
            }
            case WARNING: {
                return "icon-error.gif";
            }
        }
        return "";
    }

    public static enum DecorationType {
        TYPE,
        SLICE,
        HINT,
        WARNING,
        ERROR;

    }
}

