/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.TranslatingUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class HierarchicalTableGenerator
extends TranslatingUtilities {
    public static final String TEXT_ICON_REFERENCE = "Reference to another Resource";
    public static final String TEXT_ICON_PRIMITIVE = "Primitive Data Type";
    public static final String TEXT_ICON_DATATYPE = "Data Type";
    public static final String TEXT_ICON_RESOURCE = "Resource";
    public static final String TEXT_ICON_ELEMENT = "Element";
    public static final String TEXT_ICON_REUSE = "Reference to another Element";
    public static final String TEXT_ICON_EXTENSION = "Extension";
    public static final String TEXT_ICON_CHOICE = "Choice of Types";
    public static final String TEXT_ICON_SLICE = "Slice Definition";
    public static final String TEXT_ICON_SLICE_ITEM = "Slice Item";
    public static final String TEXT_ICON_FIXED = "Fixed Value";
    public static final String TEXT_ICON_EXTENSION_SIMPLE = "Simple Extension";
    public static final String TEXT_ICON_PROFILE = "Profile";
    public static final String TEXT_ICON_EXTENSION_COMPLEX = "Complex Extension";
    public static final int NEW_REGULAR = 0;
    public static final int CONTINUE_REGULAR = 1;
    public static final int NEW_SLICER = 2;
    public static final int CONTINUE_SLICER = 3;
    public static final int NEW_SLICE = 4;
    public static final int CONTINUE_SLICE = 5;
    private static final String BACKGROUND_ALT_COLOR = "#F7F7F7";
    public static boolean ACTIVE_TABLES = false;
    private static Map<String, String> files = new HashMap<String, String>();
    private String dest;
    private boolean makeTargets;
    private boolean inLineGraphics;

    public HierarchicalTableGenerator() {
    }

    public HierarchicalTableGenerator(String dest, boolean inlineGraphics) {
        this.dest = dest;
        this.inLineGraphics = inlineGraphics;
        this.makeTargets = true;
    }

    public HierarchicalTableGenerator(String dest, boolean inlineGraphics, boolean makeTargets) {
        this.dest = dest;
        this.inLineGraphics = inlineGraphics;
        this.makeTargets = makeTargets;
    }

    public TableModel initNormalTable(String prefix, boolean isLogical, boolean alternating, String id, boolean isActive) {
        TableModel model = new TableModel(id, isActive);
        model.setAlternating(alternating);
        model.setDocoImg(prefix + "help16.png");
        model.setDocoRef(prefix + "formats.html#table");
        model.getTitles().add(new Title(null, model.getDocoRef(), this.translate("sd.head", "Name"), this.translate("sd.hint", "The logical name of the element"), null, 0));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.translate("sd.head", "Flags"), this.translate("sd.hint", "Information about the use of the element"), null, 0));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.translate("sd.head", "Card."), this.translate("sd.hint", "Minimum and Maximum # of times the the element can appear in the instance"), null, 0));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.translate("sd.head", "Type"), this.translate("sd.hint", "Reference to the type of the element"), null, 100));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.translate("sd.head", "Description & Constraints"), this.translate("sd.hint", "Additional information about the element"), null, 0));
        if (isLogical) {
            model.getTitles().add(new Title(null, prefix + "structuredefinition.html#logical", "Implemented As", "How this logical data item is implemented in a concrete resource", null, 0));
        }
        return model;
    }

    public TableModel initGridTable(String prefix, String id) {
        TableModel model = new TableModel(id, false);
        model.getTitles().add(new Title(null, model.getDocoRef(), this.translate("sd.head", "Name"), this.translate("sd.hint", "The name of the element (Slice name in brackets).  Mouse-over provides definition"), null, 0));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.translate("sd.head", "Card."), this.translate("sd.hint", "Minimum and Maximum # of times the the element can appear in the instance. Super-scripts indicate additional constraints on appearance"), null, 0));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.translate("sd.head", "Type"), this.translate("sd.hint", "Reference to the type of the element"), null, 100));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.translate("sd.head", "Constraints and Usage"), this.translate("sd.hint", "Fixed values, length limits, vocabulary bindings and other usage notes"), null, 0));
        return model;
    }

    public XhtmlNode generate(TableModel model, String imagePath, int border, Set<String> outputTracker) throws IOException, FHIRException {
        this.checkModel(model);
        XhtmlNode table = new XhtmlNode(NodeType.Element, "table").setAttribute("border", Integer.toString(border)).setAttribute("cellspacing", "0").setAttribute("cellpadding", "0");
        if (model.isActive()) {
            table.setAttribute("id", model.getId());
        }
        table.setAttribute("style", "border: " + border + "px #F0F0F0 solid; font-size: 11px; font-family: verdana; vertical-align: top;");
        XhtmlNode tr = table.addTag("tr");
        tr.setAttribute("style", "border: " + Integer.toString(1 + border) + "px #F0F0F0 solid; font-size: 11px; font-family: verdana; vertical-align: top;");
        XhtmlNode tc = null;
        for (Title title : model.getTitles()) {
            tc = this.renderCell(tr, title, "th", null, null, null, false, null, "white", 0, imagePath, border, outputTracker, model, null);
            if (title.width == 0) continue;
            tc.setAttribute("style", "width: " + Integer.toString(title.width) + "px");
        }
        if (tc != null && model.getDocoRef() != null) {
            XhtmlNode img = tc.addTag("span").setAttribute("style", "float: right").addTag("a").setAttribute("title", "Legend for this format").setAttribute("href", model.getDocoRef()).addTag("img");
            img.setAttribute("alt", "doco").setAttribute("style", "background-color: inherit").setAttribute("src", model.getDocoImg());
            if (model.isActive()) {
                img.setAttribute("onload", "fhirTableInit(this)");
            }
        }
        Counter counter = new Counter();
        for (Row r : model.getRows()) {
            this.renderRow(table, r, 0, new ArrayList<Integer>(), imagePath, border, outputTracker, counter, model);
        }
        if (model.getDocoRef() != null) {
            tr = table.addTag("tr");
            tc = tr.addTag("td");
            tc.setAttribute("class", "hierarchy");
            tc.setAttribute("colspan", Integer.toString(model.getTitles().size()));
            tc.addTag("br");
            XhtmlNode xhtmlNode = tc.addTag("a").setAttribute("title", this.translate("sd.doco", "Legend for this format")).setAttribute("href", model.getDocoRef());
            if (model.getDocoImg() != null) {
                xhtmlNode.addTag("img").setAttribute("alt", "doco").setAttribute("style", "background-color: inherit").setAttribute("src", model.getDocoImg());
            }
            xhtmlNode.addText(" " + this.translate("sd.doco", "Documentation for this format"));
        }
        return table;
    }

    private void renderRow(XhtmlNode table, Row r, int indent, List<Integer> indents, String imagePath, int border, Set<String> outputTracker, Counter counter, TableModel model) throws IOException {
        counter.row();
        XhtmlNode tr = table.addTag("tr");
        String color = "white";
        if (r.getColor() != null) {
            color = r.getColor();
        } else if (model.isAlternating() && counter.isOdd()) {
            color = BACKGROUND_ALT_COLOR;
        }
        tr.setAttribute("style", "border: " + border + "px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: " + color + ";");
        if (model.isActive()) {
            tr.setAttribute("id", r.getId());
        }
        boolean first = true;
        for (Cell t : r.getCells()) {
            this.renderCell(tr, t, "td", first ? r.getIcon() : null, first ? r.getHint() : null, first ? indents : null, !r.getSubRows().isEmpty(), first ? r.getAnchor() : null, color, r.getLineColor(), imagePath, border, outputTracker, model, r);
            first = false;
        }
        table.addText("\r\n");
        for (int i = 0; i < r.getSubRows().size(); ++i) {
            Row c = r.getSubRows().get(i);
            ArrayList<Integer> ind = new ArrayList<Integer>();
            ind.addAll(indents);
            if (i == r.getSubRows().size() - 1) {
                ind.add(r.getLineColor() * 2);
            } else {
                ind.add(r.getLineColor() * 2 + 1);
            }
            this.renderRow(table, c, indent + 1, ind, imagePath, border, outputTracker, counter, model);
        }
    }

    private XhtmlNode renderCell(XhtmlNode tr, Cell c, String name, String icon, String hint, List<Integer> indents, boolean hasChildren, String anchor, String color, int lineColor, String imagePath, int border, Set<String> outputTracker, TableModel table, Row row) throws IOException {
        XhtmlNode tc = tr.addTag(name);
        tc.setAttribute("class", "hierarchy");
        if (c.span > 1) {
            tc.colspan(Integer.toString(c.span));
        }
        if (indents != null) {
            tc.addTag("img").setAttribute("src", this.srcFor(imagePath, "tbl_spacer.png")).setAttribute("style", "background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
            tc.setAttribute("style", "vertical-align: top; text-align : left; " + (c.cellStyle != null && c.cellStyle.contains("background-color") ? "" : "background-color: " + color + "; ") + "border: " + border + "px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(" + imagePath + this.checkExists(indents, hasChildren, lineColor, outputTracker) + ")" + (c.cellStyle != null ? ";" + c.cellStyle : ""));
            block14: for (int i = 0; i < indents.size() - 1; ++i) {
                switch (indents.get(i)) {
                    case 0: 
                    case 2: 
                    case 4: {
                        tc.addTag("img").setAttribute("src", this.srcFor(imagePath, "tbl_blank.png")).setAttribute("style", "background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        continue block14;
                    }
                    case 1: {
                        tc.addTag("img").setAttribute("src", this.srcFor(imagePath, "tbl_vline.png")).setAttribute("style", "background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        continue block14;
                    }
                    case 3: {
                        tc.addTag("img").setAttribute("src", this.srcFor(imagePath, "tbl_vline_slicer.png")).setAttribute("style", "background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        continue block14;
                    }
                    case 5: {
                        tc.addTag("img").setAttribute("src", this.srcFor(imagePath, "tbl_vline_slice.png")).setAttribute("style", "background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        continue block14;
                    }
                    default: {
                        throw new Error("Unrecognized indent level: " + indents.get(i));
                    }
                }
            }
            if (!indents.isEmpty()) {
                String sfx = table.isActive() && hasChildren ? "-open" : "";
                XhtmlNode img = tc.addTag("img");
                switch (indents.get(indents.size() - 1)) {
                    case 0: {
                        img.setAttribute("src", this.srcFor(imagePath, "tbl_vjoin_end" + sfx + ".png")).setAttribute("style", "background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        break;
                    }
                    case 2: {
                        img.setAttribute("src", this.srcFor(imagePath, "tbl_vjoin_end_slicer" + sfx + ".png")).setAttribute("style", "background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        break;
                    }
                    case 4: {
                        img.setAttribute("src", this.srcFor(imagePath, "tbl_vjoin_end_slice" + sfx + ".png")).setAttribute("style", "background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        break;
                    }
                    case 1: {
                        img.setAttribute("src", this.srcFor(imagePath, "tbl_vjoin" + sfx + ".png")).setAttribute("style", "background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        break;
                    }
                    case 3: {
                        img.setAttribute("src", this.srcFor(imagePath, "tbl_vjoin_slicer" + sfx + ".png")).setAttribute("style", "background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        break;
                    }
                    case 5: {
                        img.setAttribute("src", this.srcFor(imagePath, "tbl_vjoin_slice" + sfx + ".png")).setAttribute("style", "background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        break;
                    }
                    default: {
                        throw new Error("Unrecognized indent level: " + indents.get(indents.size() - 1));
                    }
                }
                if (table.isActive() && hasChildren) {
                    img.setAttribute("onClick", "tableRowAction(this)");
                }
            }
        } else {
            tc.setAttribute("style", "vertical-align: top; text-align : left; " + (c.cellStyle != null && c.cellStyle.contains("background-color") ? "" : "background-color: " + color + "; ") + "border: " + border + "px #F0F0F0 solid; padding:0px 4px 0px 4px" + (c.cellStyle != null ? ";" + c.cellStyle : ""));
        }
        if (!Utilities.noString(icon)) {
            XhtmlNode img = tc.addTag("img").setAttribute("src", this.srcFor(imagePath, icon)).setAttribute("class", "hierarchy").setAttribute("style", "background-color: " + color + "; background-color: inherit").setAttribute("alt", ".");
            if (hint != null) {
                img.setAttribute("title", hint);
            }
            tc.addText(" ");
        }
        for (Piece p : c.pieces) {
            XhtmlNode s;
            if (!Utilities.noString(p.getTag())) {
                XhtmlNode tag = tc.addTag(p.getTag());
                if (p.attributes != null) {
                    for (String n : p.attributes.keySet()) {
                        tag.setAttribute(n, (String)p.attributes.get(n));
                    }
                }
                if (p.getHint() != null) {
                    tag.setAttribute("title", p.getHint());
                }
                this.addStyle(tag, p);
                if (!p.hasChildren()) continue;
                tag.getChildNodes().addAll(p.getChildren());
                continue;
            }
            if (!Utilities.noString(p.getReference())) {
                XhtmlNode a = this.addStyle(tc.addTag("a"), p);
                a.setAttribute("href", p.getReference());
                if (!Utilities.noString(p.getHint())) {
                    a.setAttribute("title", p.getHint());
                }
                a.addText(p.getText());
                this.addStyle(a, p);
                continue;
            }
            if (!Utilities.noString(p.getHint())) {
                s = this.addStyle(tc.addTag("span"), p);
                s.setAttribute("title", p.getHint());
                s.addText(p.getText());
                continue;
            }
            if (p.getStyle() != null) {
                s = this.addStyle(tc.addTag("span"), p);
                s.addText(p.getText());
                continue;
            }
            tc.addText(p.getText());
        }
        if (this.makeTargets && !Utilities.noString(anchor)) {
            tc.addTag("a").setAttribute("name", this.nmTokenize(anchor)).addText(" ");
        }
        return tc;
    }

    private XhtmlNode addStyle(XhtmlNode node, Piece p) {
        if (p.getStyle() != null) {
            node.setAttribute("style", p.getStyle());
        }
        return node;
    }

    private String nmTokenize(String anchor) {
        return anchor.replace("[", "_").replace("]", "_");
    }

    private String srcFor(String corePrefix, String filename) throws IOException {
        if (this.inLineGraphics) {
            if (files.containsKey(filename)) {
                return files.get(filename);
            }
            StringBuilder b = new StringBuilder();
            b.append("data:image/png;base64,");
            File file = new File(Utilities.path(this.dest, filename));
            byte[] bytes = !file.exists() ? new byte[]{} : FileUtils.readFileToByteArray((File)file);
            b.append(new String(Base64.encodeBase64((byte[])bytes)));
            return b.toString();
        }
        return corePrefix + filename;
    }

    private void checkModel(TableModel model) throws FHIRException {
        this.check(!model.getRows().isEmpty(), "Must have rows");
        this.check(!model.getTitles().isEmpty(), "Must have titles");
        int tc = 0;
        for (Cell cell : model.getTitles()) {
            this.check(cell);
            tc += cell.span;
        }
        int i = 0;
        for (Row r : model.getRows()) {
            this.check(r, "rows", tc, "", i, model.getRows().size());
            ++i;
        }
    }

    private void check(Cell c) throws FHIRException {
        boolean hasText = false;
        for (Piece p : c.pieces) {
            if (Utilities.noString(p.getText())) continue;
            hasText = true;
        }
        this.check(hasText, "Title cells must have text");
    }

    private void check(Row r, String string, int size, String path, int index, int total) throws FHIRException {
        String id = Integer.toString(index) + ".";
        if (total <= 26) {
            char c = (char)(97 + index);
            id = Character.toString(c);
        }
        path = path + id;
        r.setId(path);
        int tc = 0;
        for (Cell c : r.getCells()) {
            tc += c.span;
        }
        this.check(tc == size, "All rows must have the same number of columns as the titles  (" + Integer.toString(size) + ") but row " + path + " doesn't - it has " + tc + " (" + r.getCells().get(0).text() + "): " + r.getCells());
        int i = 0;
        for (Row c : r.getSubRows()) {
            this.check(c, "rows", size, path, i, r.getSubRows().size());
            ++i;
        }
    }

    private String checkExists(List<Integer> indents, boolean hasChildren, int lineColor, Set<String> outputTracker) throws IOException {
        String filename = this.makeName(indents);
        StringBuilder b = new StringBuilder();
        if (this.inLineGraphics) {
            if (files.containsKey(filename)) {
                return files.get(filename);
            }
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            this.genImage(indents, hasChildren, lineColor, bytes);
            b.append("data:image/png;base64,");
            byte[] encodeBase64 = Base64.encodeBase64((byte[])bytes.toByteArray());
            b.append(new String(encodeBase64));
            files.put(filename, b.toString());
            return b.toString();
        }
        b.append("tbl_bck");
        for (Integer i : indents) {
            b.append(Integer.toString(i));
        }
        int indent = lineColor * 2 + (hasChildren ? 1 : 0);
        b.append(Integer.toString(indent));
        b.append(".png");
        String file = Utilities.path(this.dest, b.toString());
        if (!new File(file).exists()) {
            FileOutputStream stream = new FileOutputStream(file);
            this.genImage(indents, hasChildren, lineColor, stream);
            if (outputTracker != null) {
                outputTracker.add(file);
            }
        }
        return b.toString();
    }

    private void genImage(List<Integer> indents, boolean hasChildren, int lineColor, OutputStream stream) throws IOException {
        BufferedImage bi = new BufferedImage(800, 2, 2);
        Color grey = new Color(99, 99, 99, 0);
        for (int i = 0; i < 800; ++i) {
            bi.setRGB(i, 0, grey.getRGB());
            bi.setRGB(i, 1, grey.getRGB());
        }
        Color black = new Color(0, 0, 0);
        Color green = new Color(14, 209, 69);
        Color gold = new Color(212, 168, 21);
        for (int i = 0; i < indents.size(); ++i) {
            int indent = indents.get(i);
            if (indent == 1) {
                bi.setRGB(12 + i * 16, 0, black.getRGB());
                continue;
            }
            if (indent == 3) {
                bi.setRGB(12 + i * 16, 0, green.getRGB());
                continue;
            }
            if (indent != 5) continue;
            bi.setRGB(12 + i * 16, 0, gold.getRGB());
        }
        if (hasChildren) {
            if (lineColor == 0) {
                bi.setRGB(12 + indents.size() * 16, 0, black.getRGB());
            } else if (lineColor == 1) {
                bi.setRGB(12 + indents.size() * 16, 0, green.getRGB());
            } else if (lineColor == 2) {
                bi.setRGB(12 + indents.size() * 16, 0, gold.getRGB());
            }
        }
        ImageIO.write((RenderedImage)bi, "PNG", stream);
    }

    private String makeName(List<Integer> indents) {
        StringBuilder b = new StringBuilder();
        b.append("indents:");
        for (Integer i : indents) {
            b.append(Integer.toString(i));
        }
        return b.toString();
    }

    private void check(boolean check, String message) throws FHIRException {
        if (!check) {
            throw new FHIRException(message);
        }
    }

    public class TableModel {
        private String id;
        private boolean active;
        private List<Title> titles = new ArrayList<Title>();
        private List<Row> rows = new ArrayList<Row>();
        private String docoRef;
        private String docoImg;
        private boolean alternating;

        public TableModel(String id, boolean active) {
            this.id = id;
            this.active = active;
        }

        public List<Title> getTitles() {
            return this.titles;
        }

        public List<Row> getRows() {
            return this.rows;
        }

        public String getDocoRef() {
            return this.docoRef;
        }

        public String getDocoImg() {
            return this.docoImg;
        }

        public void setDocoRef(String docoRef) {
            this.docoRef = docoRef;
        }

        public void setDocoImg(String docoImg) {
            this.docoImg = docoImg;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isActive() {
            return this.active && ACTIVE_TABLES;
        }

        public boolean isAlternating() {
            return this.alternating;
        }

        public void setAlternating(boolean alternating) {
            this.alternating = alternating;
        }
    }

    public class Row {
        private List<Row> subRows = new ArrayList<Row>();
        private List<Cell> cells = new ArrayList<Cell>();
        private String icon;
        private String anchor;
        private String hint;
        private String color;
        private int lineColor;
        private String id;

        public List<Row> getSubRows() {
            return this.subRows;
        }

        public List<Cell> getCells() {
            return this.cells;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon, String hint) {
            this.icon = icon;
            this.hint = hint;
        }

        public String getAnchor() {
            return this.anchor;
        }

        public void setAnchor(String anchor) {
            this.anchor = anchor;
        }

        public String getHint() {
            return this.hint;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public int getLineColor() {
            return this.lineColor;
        }

        public void setLineColor(int lineColor) {
            assert (lineColor >= 0);
            assert (lineColor <= 2);
            this.lineColor = lineColor;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public class Title
    extends Cell {
        private int width;

        public Title(String prefix, String reference, String text, String hint, String suffix, int width) {
            super(prefix, reference, text, hint, suffix);
            this.width = width;
        }

        public Title(String prefix, String reference, String text, String hint, String suffix, int width, int span) {
            super(prefix, reference, text, hint, suffix);
            this.width = width;
            this.span = span;
        }
    }

    public class Cell {
        private List<Piece> pieces = new ArrayList<Piece>();
        private String cellStyle;
        protected int span = 1;
        private TextAlignment alignment = TextAlignment.LEFT;

        public Cell() {
        }

        public Cell(String prefix, String reference, String text, String hint, String suffix) {
            if (!Utilities.noString(prefix)) {
                this.pieces.add(new Piece(null, prefix, null));
            }
            this.pieces.add(new Piece(reference, text, hint));
            if (!Utilities.noString(suffix)) {
                this.pieces.add(new Piece(null, suffix, null));
            }
        }

        public List<Piece> getPieces() {
            return this.pieces;
        }

        public Cell addPiece(Piece piece) {
            this.pieces.add(piece);
            return this;
        }

        public Cell addMarkdown(String md) {
            try {
                Parser parser = Parser.builder().build();
                Node document = parser.parse(md);
                HtmlRenderer renderer = HtmlRenderer.builder().escapeHtml(true).build();
                String html = renderer.render(document);
                this.pieces.addAll(this.htmlToParagraphPieces(html));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this;
        }

        private List<Piece> htmlToParagraphPieces(String html) {
            ArrayList<Piece> myPieces = new ArrayList<Piece>();
            try {
                XhtmlNode node = new XhtmlParser().parseFragment("<html>" + html + "</html>");
                boolean first = true;
                for (XhtmlNode c : node.getChildNodes()) {
                    if (first) {
                        first = false;
                    } else {
                        myPieces.add(new Piece("br"));
                        myPieces.add(new Piece("br"));
                    }
                    if (c.getNodeType() == NodeType.Text) {
                        if (Utilities.isWhitespace(c.getContent())) continue;
                        this.addNode(myPieces, c);
                        continue;
                    }
                    if ("p".equals(c.getName())) {
                        for (XhtmlNode g : c.getChildNodes()) {
                            this.addNode(myPieces, g);
                        }
                        continue;
                    }
                    Piece x = new Piece(c.getName());
                    x.getChildren().addAll(c.getChildNodes());
                    myPieces.add(x);
                }
            }
            catch (Exception e) {
                throw new FHIRException("Exception parsing html: " + e.getMessage() + " for " + html, e);
            }
            return myPieces;
        }

        private List<Piece> htmlFormattingToPieces(String html) throws IOException, FHIRException {
            ArrayList<Piece> myPieces = new ArrayList<Piece>();
            if (html.contains("<")) {
                XhtmlNode node = new XhtmlParser().parseFragment("<p>" + html + "</p>");
                for (XhtmlNode c : node.getChildNodes()) {
                    this.addNode(myPieces, c);
                }
            } else {
                myPieces.add(new Piece(null, html, null));
            }
            return myPieces;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addNode(List<Piece> list, XhtmlNode c) {
            if (c.getNodeType() == NodeType.Text) {
                list.add(new Piece(null, c.getContent(), null));
                return;
            } else {
                if (c.getNodeType() != NodeType.Element) throw new Error("Unhandled type " + c.getNodeType().toString());
                if (c.getName().equals("a")) {
                    list.add(new Piece(c.getAttribute("href"), c.allText(), c.getAttribute("title")));
                    return;
                } else if (c.getName().equals("b") || c.getName().equals("em") || c.getName().equals("strong")) {
                    list.add(new Piece(null, c.allText(), null).setStyle("font-face: bold"));
                    return;
                } else if (c.getName().equals("code")) {
                    list.add(new Piece(null, c.allText(), null).setStyle("padding: 2px 4px; color: #005c00; background-color: #f9f2f4; white-space: nowrap; border-radius: 4px"));
                    return;
                } else if (c.getName().equals("i")) {
                    list.add(new Piece(null, c.allText(), null).setStyle("font-style: italic"));
                    return;
                } else if (c.getName().equals("pre")) {
                    Piece p = new Piece(c.getName()).setStyle("white-space: pre; font-family: courier");
                    list.add(p);
                    p.getChildren().addAll(c.getChildNodes());
                    return;
                } else if (c.getName().equals("ul") || c.getName().equals("ol")) {
                    Piece p = new Piece(c.getName());
                    list.add(p);
                    p.getChildren().addAll(c.getChildNodes());
                    return;
                } else if (c.getName().equals("i")) {
                    list.add(new Piece(null, c.allText(), null).setStyle("font-style: italic"));
                    return;
                } else if (c.getName().equals("h1") || c.getName().equals("h2") || c.getName().equals("h3") || c.getName().equals("h4")) {
                    Piece p = new Piece(c.getName());
                    list.add(p);
                    p.getChildren().addAll(c.getChildNodes());
                    return;
                } else {
                    if (!c.getName().equals("br")) throw new Error("Not handled yet: " + c.getName());
                    list.add(new Piece(c.getName()));
                }
            }
        }

        public Cell addStyle(String style) {
            for (Piece p : this.pieces) {
                p.addStyle(style);
            }
            return this;
        }

        public void addToHint(String text) {
            for (Piece p : this.pieces) {
                p.addToHint(text);
            }
        }

        public Piece addStyledText(String hint, String alt, String fgColor, String bgColor, String link, boolean border) {
            Piece p = new Piece(link, alt, hint);
            p.addStyle("padding-left: 3px");
            p.addStyle("padding-right: 3px");
            if (border) {
                p.addStyle("border: 1px grey solid");
                p.addStyle("font-weight: bold");
            }
            if (fgColor != null) {
                p.addStyle("color: " + fgColor);
                p.addStyle("background-color: " + bgColor);
            } else {
                p.addStyle("color: black");
                p.addStyle("background-color: " + bgColor != null ? bgColor : "white");
            }
            this.pieces.add(p);
            return p;
        }

        public String text() {
            StringBuilder b = new StringBuilder();
            for (Piece p : this.pieces) {
                b.append(p.text);
            }
            return b.toString();
        }

        public String toString() {
            if (this.span != 1) {
                return this.text() + " {" + this.span + "}";
            }
            return this.text();
        }

        public Cell setStyle(String value) {
            this.cellStyle = value;
            return this;
        }

        public Cell span(int value) {
            this.span = value;
            return this;
        }

        public Cell center() {
            this.alignment = TextAlignment.CENTER;
            return this;
        }
    }

    public class Piece {
        private String tag;
        private String reference;
        private String text;
        private String hint;
        private String style;
        private Map<String, String> attributes;
        private List<XhtmlNode> children;

        public Piece(String tag) {
            this.tag = tag;
        }

        public Piece(String reference, String text, String hint) {
            this.reference = reference;
            this.text = text;
            this.hint = hint;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String value) {
            this.reference = value;
        }

        public String getText() {
            return this.text;
        }

        public String getHint() {
            return this.hint;
        }

        public String getTag() {
            return this.tag;
        }

        public String getStyle() {
            return this.style;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public Piece setText(String text) {
            this.text = text;
            return this;
        }

        public void setHint(String hint) {
            this.hint = hint;
        }

        public Piece setStyle(String style) {
            this.style = style;
            return this;
        }

        public Piece addStyle(String style) {
            this.style = this.style != null ? this.style + "; " + style : style;
            return this;
        }

        public void addToHint(String text) {
            this.hint = this.hint == null ? text : this.hint + (this.hint.endsWith(".") || this.hint.endsWith("?") ? " " : ". ") + text;
        }

        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        public List<XhtmlNode> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList<XhtmlNode>();
            }
            return this.children;
        }
    }

    private class Counter {
        private int count = -1;

        private Counter() {
        }

        private void row() {
            ++this.count;
        }

        private boolean isOdd() {
            return this.count % 2 == 1;
        }
    }

    public static enum TextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

