/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;

public abstract class I18nBase {
    private Locale locale;
    private ResourceBundle i18nMessages;
    private boolean warnAboutMissingMessages = true;

    public Locale getLocale() {
        if (Objects.nonNull(this.locale)) {
            return this.locale;
        }
        return Locale.US;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setValidationMessageLanguage(this.getLocale());
    }

    private void checkResourceBundleIsLoaded() {
        if (this.i18nMessages == null) {
            this.setValidationMessageLanguage(this.getLocale());
        }
    }

    private boolean messageExistsForLocale(String message, boolean hasArgs) {
        this.checkResourceBundleIsLoaded();
        if (!this.i18nMessages.containsKey(message) && this.warnAboutMissingMessages && (hasArgs || !message.contains(" "))) {
            System.out.println("Attempting to localize message " + message + ", but no such equivalent message exists for the local " + this.getLocale());
        }
        return this.i18nMessages.containsKey(message);
    }

    public String formatMessage(String theMessage, Object ... theMessageArguments) {
        String message = theMessage;
        if (this.messageExistsForLocale(theMessage, theMessageArguments != null && theMessageArguments.length > 0)) {
            message = Objects.nonNull(theMessageArguments) && theMessageArguments.length > 0 ? MessageFormat.format(this.i18nMessages.getString(theMessage), theMessageArguments) : this.i18nMessages.getString(theMessage);
        }
        return message;
    }

    public void setValidationMessageLanguage(Locale locale) {
        this.i18nMessages = ResourceBundle.getBundle("Messages", locale);
    }

    public boolean isWarnAboutMissingMessages() {
        return this.warnAboutMissingMessages;
    }

    public void setWarnAboutMissingMessages(boolean warnAboutMissingMessages) {
        this.warnAboutMissingMessages = warnAboutMissingMessages;
    }
}

