/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.json.JsonTrackingParser;

public class JSONUtil {
    public static JsonObject parse(String json) throws IOException {
        return JsonTrackingParser.parseJson(json);
    }

    public static JsonObject forceObject(JsonObject obj, String name) {
        if (obj.has(name) && obj.get(name).isJsonObject()) {
            return obj.getAsJsonObject(name);
        }
        if (obj.has(name)) {
            obj.remove(name);
        }
        JsonObject res = new JsonObject();
        obj.add(name, (JsonElement)res);
        return res;
    }

    public static JsonArray forceArray(JsonObject obj, String name) {
        if (obj.has(name) && obj.get(name).isJsonArray()) {
            return obj.getAsJsonArray(name);
        }
        if (obj.has(name)) {
            obj.remove(name);
        }
        JsonArray res = new JsonArray();
        obj.add(name, (JsonElement)res);
        return res;
    }

    public static JsonObject addObj(JsonArray arr) {
        JsonObject res = new JsonObject();
        arr.add((JsonElement)res);
        return res;
    }

    public static JsonObject findByStringProp(JsonArray arr, String prop, String value) {
        for (JsonElement e : arr) {
            JsonObject obj = (JsonObject)e;
            if (!obj.has(prop) || !obj.get(prop).getAsString().equals(value)) continue;
            return obj;
        }
        return null;
    }

    public static String str(JsonObject json, String name) {
        JsonElement e = json.get(name);
        return e == null || e instanceof JsonNull ? null : e.getAsString();
    }

    public static boolean bool(JsonObject json, String name) {
        JsonElement e = json.get(name);
        return e == null || e instanceof JsonNull ? false : e.getAsBoolean();
    }

    public static String str(JsonObject json, String name1, String name2) {
        JsonElement e = json.get(name1);
        if (e == null) {
            e = json.get(name2);
        }
        return e == null ? null : (e instanceof JsonNull ? null : e.getAsString());
    }

    public static boolean has(JsonObject json, String name1, String name2) {
        return json.has(name1) || json.has(name2);
    }

    public static List<JsonObject> objects(JsonObject json, String name) {
        ArrayList<JsonObject> res = new ArrayList<JsonObject>();
        if (json.has(name)) {
            for (JsonElement e : json.getAsJsonArray(name)) {
                if (!(e instanceof JsonObject)) continue;
                res.add((JsonObject)e);
            }
        }
        return res;
    }

    public static void merge(JsonObject source, JsonObject target) {
        for (Map.Entry pp : source.entrySet()) {
            if (target.has((String)pp.getKey())) {
                JsonElement te = target.get((String)pp.getKey());
                if (te.isJsonObject() && ((JsonElement)pp.getValue()).isJsonObject()) {
                    JSONUtil.merge(te.getAsJsonObject(), ((JsonElement)pp.getValue()).getAsJsonObject());
                    continue;
                }
                target.remove((String)pp.getKey());
                target.add((String)pp.getKey(), (JsonElement)pp.getValue());
                continue;
            }
            target.add((String)pp.getKey(), (JsonElement)pp.getValue());
        }
    }

    public static JsonObject fetchJson(String source) throws IOException {
        URL url = new URL(source);
        URLConnection c = url.openConnection();
        return (JsonObject)new JsonParser().parse(TextFile.streamToString(c.getInputStream()));
    }
}

