/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.ArrayList;
import java.util.List;

public class SIDUtilities {
    public static List<String> codeSystemList() {
        ArrayList<String> codeSystems = new ArrayList<String>();
        codeSystems.add("http://hl7.org/fhir/sid/ndc");
        codeSystems.add("http://hl7.org/fhir/sid/icd-10");
        codeSystems.add("http://hl7.org/fhir/sid/icpc2");
        codeSystems.add("http://hl7.org/fhir/sid/icd-9");
        codeSystems.add("http://hl7.org/fhir/sid/icd-10");
        codeSystems.add("http://hl7.org/fhir/sid/icpc2");
        codeSystems.add("http://hl7.org/fhir/sid/cvx");
        codeSystems.add("http://hl7.org/fhir/sid/srt");
        codeSystems.add("http://hl7.org/fhir/sid/icd-10-vn");
        codeSystems.add("http://hl7.org/fhir/sid/icd-10-cm");
        codeSystems.add("http://hl7.org/fhir/sid/icd-9-cm");
        return codeSystems;
    }

    public static List<String> idSystemList() {
        ArrayList<String> idSystems = new ArrayList<String>();
        idSystems.add("http://hl7.org/fhir/sid/us-ssn");
        idSystems.add("http://hl7.org/fhir/sid/us-npi");
        idSystems.add("http://hl7.org/fhir/sid/eui-48/bluetooth");
        idSystems.add("http://hl7.org/fhir/sid/eui-48/ethernet");
        return idSystems;
    }

    private static boolean isPassPortSID(String url) {
        return url.matches("^http:\\/\\/hl7.org\\/fhir\\/sid\\/passport-[a-zA-Z]{3}$");
    }

    public static boolean isknownCodeSystem(String system) {
        return SIDUtilities.codeSystemList().contains(system);
    }

    public static boolean isKnownSID(String url) {
        return SIDUtilities.isknownCodeSystem(url) || SIDUtilities.isknownIDSystem(url);
    }

    private static boolean isknownIDSystem(String url) {
        return SIDUtilities.idSystemList().contains(url) || SIDUtilities.isPassPortSID(url);
    }

    public static List<String> allSystemsList() {
        ArrayList<String> allSystems = new ArrayList<String>();
        allSystems.addAll(SIDUtilities.codeSystemList());
        allSystems.addAll(SIDUtilities.idSystemList());
        return allSystems;
    }
}

