/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.utilities.Utilities;

public class MimeType {
    private String source;
    private String base;
    private Map<String, String> params = new HashMap<String, String>();

    public MimeType(String s) {
        this.source = s;
        for (String p : s.split("\\;")) {
            if (this.base == null) {
                this.base = p;
                continue;
            }
            this.params.put(p.substring(0, p.indexOf("=")), p.substring(p.indexOf("=") + 1));
        }
        if ("xml".equals(this.base)) {
            this.base = "application/fhir+xml";
        }
        if ("json".equals(this.base)) {
            this.base = "application/fhir+json";
        }
        if ("ttl".equals(this.base)) {
            this.base = "application/fhir+ttl";
        }
    }

    public String main() {
        if (this.base.contains("/")) {
            return this.base.substring(0, this.base.indexOf("/"));
        }
        return this.base;
    }

    public String sub() {
        if (this.base.contains("/")) {
            return this.base.substring(this.base.indexOf("/") + 1);
        }
        return null;
    }

    public boolean hasParam(String name) {
        return this.params.containsKey(name);
    }

    public boolean isValid() {
        return (Utilities.existsInList(this.main(), "application", "audio", "font", "example", "image", "message", "model", "multipart", "text", "video") || this.main().startsWith("x-")) && !Utilities.noString(this.sub());
    }

    public static List<MimeType> parseList(String s) {
        ArrayList<MimeType> result = new ArrayList<MimeType>();
        for (String e : s.split("\\,")) {
            result.add(new MimeType(e));
        }
        return result;
    }

    public String display() {
        return this.source;
    }

    public static String getExtension(String mimeType) {
        MimeType mt = new MimeType(mimeType);
        return mt.getExtension();
    }

    public String getExtension() {
        switch (this.base) {
            case "text/html": {
                return "html";
            }
            case "text/xml": {
                return "xml";
            }
            case "application/xml": {
                return "xml";
            }
            case "text/markdown": {
                return "md";
            }
            case "application/js": {
                return "js";
            }
            case "application/css": {
                return "css";
            }
            case "text/x-csrc": {
                return "c";
            }
            case "text/x-csharp": {
                return "cs";
            }
            case "text/x-c++src": {
                return "c";
            }
            case "application/graphql": {
                return "graphql";
            }
            case "application/x-java": {
                return "java";
            }
            case "application/json": {
                return "json";
            }
            case "text/json": {
                return "json";
            }
            case "application/liquid": {
                return "liquid";
            }
            case "text/x-pascal": {
                return "pas";
            }
            case "text/x-python": {
                return "py";
            }
            case "text/x-rsrc": {
                return "r";
            }
            case "text/x-ruby": {
                return "ruby";
            }
            case "text/x-sas": {
                return "sas";
            }
            case "text/x-sql": {
                return "sql";
            }
            case "application/typescript": {
                return "ts";
            }
            case "text/cql": {
                return "cql";
            }
            case "image/png": {
                return "png";
            }
            case "image/gif": {
                return "gif";
            }
            case "image/jpeg": {
                return "jpg";
            }
        }
        if (this.base.contains("xml+") || this.base.contains("+xml")) {
            return "xml";
        }
        if (this.base.contains("json+") || this.base.contains("+json")) {
            return "json";
        }
        if (this.base.contains("turtle+") || this.base.contains("+turtle")) {
            return "ttl";
        }
        return null;
    }
}

